/*
 * Decompiled with CFR 0.152.
 */
package com.intellij;

import com.intellij.util.ArrayUtil;
import java.lang.reflect.Method;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import junit.framework.AssertionFailedError;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestListener;
import org.junit.runner.Describable;
import org.junit.runner.Description;

public class TestDiscoveryBasicListener
implements TestListener {
    public void addError(Test test, Throwable t) {
    }

    public void addFailure(Test test, AssertionFailedError t) {
    }

    public void endTest(Test test) {
        String className = TestDiscoveryBasicListener.getClassName(test);
        String methodName = TestDiscoveryBasicListener.getMethodName(test);
        try {
            Object data = this.getData();
            Method testEnded = data.getClass().getMethod("testDiscoveryEnded", String.class, String.class);
            testEnded.invoke(data, className, methodName);
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    public void startTest(Test test) {
        try {
            Object data = this.getData();
            Method testStarted = data.getClass().getMethod("testDiscoveryStarted", String.class, String.class);
            testStarted.invoke(data, TestDiscoveryBasicListener.getClassName(test), TestDiscoveryBasicListener.getMethodName(test));
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    protected Object getData() throws Exception {
        return Class.forName("com.intellij.rt.coverage.data.TestDiscoveryProjectData").getMethod("getProjectData", ArrayUtil.EMPTY_CLASS_ARRAY).invoke(null, ArrayUtil.EMPTY_OBJECT_ARRAY);
    }

    private static String getMethodName(Test test) {
        Description description;
        String name2;
        String name3;
        if (test instanceof TestCase && (name3 = ((TestCase)test).getName()) != null) {
            return name3;
        }
        if (test instanceof Describable && (name2 = TestDiscoveryBasicListener.getMethodName(description = ((Describable)test).getDescription())) != null) {
            return name2;
        }
        String toString = test.toString();
        int braceIdx = toString.indexOf("(");
        return braceIdx > 0 ? toString.substring(0, braceIdx) : toString;
    }

    private static String getClassName(Test test) {
        Description description;
        String name2;
        if (test instanceof Describable && (name2 = TestDiscoveryBasicListener.getClassName(description = ((Describable)test).getDescription())) != null) {
            return name2;
        }
        return test.getClass().getName();
    }

    public static String getClassName(Description description) {
        try {
            return description.getClassName();
        }
        catch (NoSuchMethodError e) {
            String displayName = description.getDisplayName();
            Matcher matcher = Pattern.compile("(.*)\\((.*)\\)").matcher(displayName);
            return matcher.matches() ? matcher.group(2) : displayName;
        }
    }

    public static String getMethodName(Description description) {
        try {
            return description.getMethodName();
        }
        catch (NoSuchMethodError e) {
            String displayName = description.getDisplayName();
            Matcher matcher = Pattern.compile("(.*)\\((.*)\\)").matcher(displayName);
            if (matcher.matches()) {
                return matcher.group(1);
            }
            return null;
        }
    }
}

