/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.actions;

import com.intellij.debugger.DebuggerManagerEx;
import com.intellij.debugger.actions.ThreadDumpAction;
import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.events.DebuggerCommandImpl;
import com.intellij.debugger.impl.DebuggerContextImpl;
import com.intellij.debugger.impl.DebuggerSession;
import com.intellij.ide.ExporterToTextFile;
import com.intellij.ide.actions.ExportToTextFileAction;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.project.Project;
import com.intellij.unscramble.ThreadDumpPanel;
import com.intellij.unscramble.ThreadState;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class ExportThreadsAction
extends AnAction
implements AnAction.TransparentUpdate {
    public void actionPerformed(@NotNull AnActionEvent e) {
        DebugProcessImpl process2;
        Project project2;
        if (e == null) {
            ExportThreadsAction.$$$reportNull$$$0(0);
        }
        if ((project2 = e.getProject()) == null) {
            return;
        }
        DebuggerContextImpl context = DebuggerManagerEx.getInstanceEx(project2).getContext();
        DebuggerSession session = context.getDebuggerSession();
        if (session != null && session.isAttached() && (process2 = context.getDebugProcess()) != null) {
            process2.getManagerThread().invoke(new DebuggerCommandImpl(){

                @Override
                protected void action() {
                    List<ThreadState> threads = ThreadDumpAction.buildThreadStates(process2.getVirtualMachineProxy());
                    ApplicationManager.getApplication().invokeLater(() -> ExportToTextFileAction.export((Project)project2, (ExporterToTextFile)ThreadDumpPanel.createToFileExporter((Project)project2, (List)threads)), ModalityState.NON_MODAL);
                }
            });
        }
    }

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            ExportThreadsAction.$$$reportNull$$$0(1);
        }
        Presentation presentation = e.getPresentation();
        Project project2 = e.getProject();
        if (project2 == null) {
            presentation.setEnabled(false);
            return;
        }
        DebuggerSession debuggerSession = DebuggerManagerEx.getInstanceEx(project2).getContext().getDebuggerSession();
        presentation.setEnabled(debuggerSession != null && debuggerSession.isPaused());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "e";
        objectArray2[1] = "com/intellij/debugger/actions/ExportThreadsAction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "actionPerformed";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "update";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

