/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.actions;

import com.intellij.debugger.SourcePosition;
import com.intellij.debugger.actions.JvmSmartStepIntoHandler;
import com.intellij.debugger.actions.LambdaSmartStepTarget;
import com.intellij.debugger.actions.MethodSmartStepTarget;
import com.intellij.debugger.actions.SmartStepTarget;
import com.intellij.debugger.engine.DebuggerUtils;
import com.intellij.debugger.engine.SuspendContextImpl;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.engine.evaluation.expression.EvaluatorBuilderImpl;
import com.intellij.debugger.engine.evaluation.expression.ExpressionEvaluator;
import com.intellij.debugger.engine.events.DebuggerContextCommandImpl;
import com.intellij.debugger.impl.DebuggerContextImpl;
import com.intellij.debugger.impl.DebuggerSession;
import com.intellij.debugger.impl.DebuggerUtilsEx;
import com.intellij.debugger.impl.PrioritizedTask;
import com.intellij.debugger.jdi.MethodBytecodeUtil;
import com.intellij.debugger.jdi.StackFrameProxyImpl;
import com.intellij.lang.Language;
import com.intellij.lang.java.JavaLanguage;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaRecursiveElementVisitor;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiCallExpression;
import com.intellij.psi.PsiCompiledElement;
import com.intellij.psi.PsiConditionalExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiIfStatement;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiMethodReferenceExpression;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiStatement;
import com.intellij.util.DocumentUtil;
import com.intellij.util.Range;
import com.intellij.util.ThreeState;
import com.intellij.util.containers.OrderedSet;
import com.intellij.xdebugger.impl.ui.DebuggerUIUtil;
import com.sun.jdi.Location;
import java.util.Collections;
import java.util.Deque;
import java.util.LinkedList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.org.objectweb.asm.Label;
import org.jetbrains.org.objectweb.asm.MethodVisitor;

public class JavaSmartStepIntoHandler
extends JvmSmartStepIntoHandler {
    private static final Logger LOG = Logger.getInstance(JavaSmartStepIntoHandler.class);

    @Override
    public boolean isAvailable(SourcePosition position) {
        PsiFile file = position.getFile();
        return file.getLanguage().isKindOf((Language)JavaLanguage.INSTANCE);
    }

    @Override
    public boolean doSmartStep(final SourcePosition position, final DebuggerSession session, final TextEditor fileEditor) {
        session.getProcess().getManagerThread().schedule(new DebuggerContextCommandImpl(session.getContextManager().getContext()){

            @Override
            public void threadAction(@NotNull SuspendContextImpl suspendContext) {
                if (suspendContext == null) {
                    1.$$$reportNull$$$0(0);
                }
                List targets = (List)ReadAction.compute(() -> {
                    if (suspendContext == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    return JavaSmartStepIntoHandler.this.findSmartStepTargets(position, suspendContext, this.getDebuggerContext());
                });
                DebuggerUIUtil.invokeLater(() -> {
                    if (targets.isEmpty()) {
                        JavaSmartStepIntoHandler.this.doStepInto(session, Registry.is((String)"debugger.single.smart.step.force"), null);
                    } else {
                        JavaSmartStepIntoHandler.this.handleTargets(position, session, fileEditor, targets);
                    }
                });
            }

            @Override
            public PrioritizedTask.Priority getPriority() {
                return PrioritizedTask.Priority.NORMAL;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "suspendContext";
                objectArray2[1] = "com/intellij/debugger/actions/JavaSmartStepIntoHandler$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "threadAction";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "lambda$threadAction$0";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        return true;
    }

    @Override
    @NotNull
    public List<SmartStepTarget> findSmartStepTargets(SourcePosition position) {
        throw new IllegalStateException("Should not be used");
    }

    protected List<SmartStepTarget> findSmartStepTargets(SourcePosition position, @Nullable SuspendContextImpl suspendContext, @NotNull DebuggerContextImpl debuggerContext) {
        TextRange lineRange;
        int line;
        if (debuggerContext == null) {
            JavaSmartStepIntoHandler.$$$reportNull$$$0(0);
        }
        if ((line = position.getLine()) < 0) {
            return Collections.emptyList();
        }
        PsiFile file = position.getFile();
        VirtualFile vFile = file.getVirtualFile();
        if (vFile == null) {
            return Collections.emptyList();
        }
        Document doc = FileDocumentManager.getInstance().getDocument(vFile);
        if (doc == null) {
            return Collections.emptyList();
        }
        if (line >= doc.getLineCount()) {
            return Collections.emptyList();
        }
        TextRange curLineRange = DocumentUtil.getLineTextRange((Document)doc, (int)line);
        PsiElement element = position.getElementAt();
        PsiElement body = DebuggerUtilsEx.getBody(DebuggerUtilsEx.getContainingMethod(element));
        TextRange textRange = lineRange = body != null ? curLineRange.intersection(body.getTextRange()) : curLineRange;
        if (lineRange == null || lineRange.isEmpty()) {
            return Collections.emptyList();
        }
        if (element != null && !(element instanceof PsiCompiledElement)) {
            PsiElement parent;
            while ((parent = element.getParent()) != null && parent.getTextOffset() >= lineRange.getStartOffset()) {
                element = parent;
            }
            OrderedSet targets = new OrderedSet();
            Ref textRange2 = new Ref((Object)lineRange);
            JavaRecursiveElementVisitor methodCollector = new JavaRecursiveElementVisitor((List)targets, position, debuggerContext, lineRange, textRange2){
                final Deque<PsiMethod> myContextStack = new LinkedList<PsiMethod>();
                final Deque<String> myParamNameStack = new LinkedList<String>();
                private int myNextLambdaExpressionOrdinal = 0;
                private boolean myInsideLambda = false;
                final /* synthetic */ List val$targets;
                final /* synthetic */ SourcePosition val$position;
                final /* synthetic */ DebuggerContextImpl val$debuggerContext;
                final /* synthetic */ TextRange val$lineRange;
                final /* synthetic */ Ref val$textRange;
                {
                    this.val$targets = list;
                    this.val$position = sourcePosition;
                    this.val$debuggerContext = debuggerContextImpl;
                    this.val$lineRange = textRange;
                    this.val$textRange = ref;
                }

                @Nullable
                private String getCurrentParamName() {
                    return this.myParamNameStack.peekFirst();
                }

                public void visitAnonymousClass(PsiAnonymousClass aClass) {
                    for (PsiMethod psiMethod : aClass.getMethods()) {
                        this.val$targets.add(0, new MethodSmartStepTarget(psiMethod, this.getCurrentParamName(), (PsiElement)psiMethod.getBody(), true, null));
                    }
                }

                public void visitLambdaExpression(PsiLambdaExpression expression) {
                    boolean inLambda = this.myInsideLambda;
                    this.myInsideLambda = true;
                    super.visitLambdaExpression(expression);
                    this.myInsideLambda = inLambda;
                    this.val$targets.add(0, new LambdaSmartStepTarget(expression, this.getCurrentParamName(), expression.getBody(), this.myNextLambdaExpressionOrdinal++, null, !this.myInsideLambda));
                }

                public void visitMethodReferenceExpression(PsiMethodReferenceExpression expression) {
                    PsiElement navMethod;
                    PsiElement element = expression.resolve();
                    if (element instanceof PsiMethod && (navMethod = element.getNavigationElement()) instanceof PsiMethod) {
                        this.val$targets.add(0, new MethodSmartStepTarget((PsiMethod)navMethod, null, (PsiElement)expression, true, null));
                    }
                }

                public void visitField(PsiField field) {
                    if (this.checkTextRange((PsiElement)field, false)) {
                        super.visitField(field);
                    }
                }

                public void visitMethod(PsiMethod method) {
                    if (this.checkTextRange((PsiElement)method, false)) {
                        super.visitMethod(method);
                    }
                }

                public void visitStatement(PsiStatement statement2) {
                    if (this.checkTextRange((PsiElement)statement2, true)) {
                        super.visitStatement(statement2);
                    }
                }

                public void visitIfStatement(PsiIfStatement statement2) {
                    this.visitConditional((PsiElement)statement2.getCondition(), (PsiElement)statement2.getThenBranch(), (PsiElement)statement2.getElseBranch());
                }

                public void visitConditionalExpression(PsiConditionalExpression expression) {
                    this.visitConditional((PsiElement)expression.getCondition(), (PsiElement)expression.getThenExpression(), (PsiElement)expression.getElseExpression());
                }

                private void visitConditional(@Nullable PsiElement condition, @Nullable PsiElement thenBranch, @Nullable PsiElement elseBranch) {
                    ThreeState conditionRes;
                    if (condition != null && this.checkTextRange(condition, true)) {
                        condition.accept((PsiElementVisitor)this);
                    }
                    if ((conditionRes = this.evaluateCondition(condition)) != ThreeState.NO && thenBranch != null && this.checkTextRange(thenBranch, true)) {
                        thenBranch.accept((PsiElementVisitor)this);
                    }
                    if (conditionRes != ThreeState.YES && elseBranch != null && this.checkTextRange(elseBranch, true)) {
                        elseBranch.accept((PsiElementVisitor)this);
                    }
                }

                private ThreeState evaluateCondition(@Nullable PsiElement condition) {
                    if (condition != null && !DebuggerUtils.hasSideEffects((PsiElement)condition)) {
                        try {
                            ExpressionEvaluator evaluator = EvaluatorBuilderImpl.getInstance().build(condition, this.val$position);
                            return ThreeState.fromBoolean((boolean)DebuggerUtilsEx.evaluateBoolean(evaluator, this.val$debuggerContext.createEvaluationContext()));
                        }
                        catch (EvaluateException e) {
                            LOG.info((Throwable)e);
                        }
                    }
                    return ThreeState.UNSURE;
                }

                public void visitExpression(PsiExpression expression) {
                    this.checkTextRange((PsiElement)expression, true);
                    super.visitExpression(expression);
                }

                boolean checkTextRange(@NotNull PsiElement expression, boolean expand) {
                    TextRange range;
                    if (expression == null) {
                        2.$$$reportNull$$$0(0);
                    }
                    if (this.val$lineRange.intersects(range = expression.getTextRange())) {
                        if (expand) {
                            this.val$textRange.set((Object)((TextRange)this.val$textRange.get()).union(range));
                        }
                        return true;
                    }
                    return false;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void visitExpressionList(PsiExpressionList expressionList) {
                    PsiMethod psiMethod = this.myContextStack.peekFirst();
                    if (psiMethod != null) {
                        String methodName = psiMethod.getName();
                        PsiExpression[] expressions = expressionList.getExpressions();
                        PsiParameter[] parameters = psiMethod.getParameterList().getParameters();
                        for (int idx = 0; idx < expressions.length; ++idx) {
                            String paramName = idx < parameters.length && !parameters[idx].isVarArgs() ? parameters[idx].getName() : "arg" + (idx + 1);
                            this.myParamNameStack.push(methodName + ": " + paramName + ".");
                            PsiExpression argExpression = expressions[idx];
                            try {
                                argExpression.accept((PsiElementVisitor)this);
                                continue;
                            }
                            finally {
                                this.myParamNameStack.pop();
                            }
                        }
                    } else {
                        super.visitExpressionList(expressionList);
                    }
                }

                public void visitCallExpression(PsiCallExpression expression) {
                    PsiMethod psiMethod = expression.resolveMethod();
                    if (psiMethod != null) {
                        this.myContextStack.push(psiMethod);
                        this.val$targets.add(new MethodSmartStepTarget(psiMethod, null, (PsiElement)(expression instanceof PsiMethodCallExpression ? ((PsiMethodCallExpression)expression).getMethodExpression().getReferenceNameElement() : (expression instanceof PsiNewExpression ? ((PsiNewExpression)expression).getClassOrAnonymousClassReference() : expression)), this.myInsideLambda || expression instanceof PsiNewExpression && ((PsiNewExpression)expression).getAnonymousClass() != null, null));
                    }
                    try {
                        super.visitCallExpression(expression);
                    }
                    finally {
                        if (psiMethod != null) {
                            this.myContextStack.pop();
                        }
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/intellij/debugger/actions/JavaSmartStepIntoHandler$2", "checkTextRange"));
                }
            };
            element.accept((PsiElementVisitor)methodCollector);
            for (PsiElement sibling = element.getNextSibling(); sibling != null && lineRange.intersects(sibling.getTextRange()); sibling = sibling.getNextSibling()) {
                sibling.accept((PsiElementVisitor)methodCollector);
            }
            final Range lines = new Range((Comparable)Integer.valueOf(doc.getLineNumber(((TextRange)textRange2.get()).getStartOffset())), (Comparable)Integer.valueOf(doc.getLineNumber(((TextRange)textRange2.get()).getEndOffset())));
            targets.forEach(t -> t.setCallingExpressionLines((Range<Integer>)lines));
            if (!targets.isEmpty()) {
                StackFrameProxyImpl frameProxy;
                StackFrameProxyImpl stackFrameProxyImpl = frameProxy = suspendContext != null ? suspendContext.getFrameProxy() : null;
                if (frameProxy != null) {
                    try {
                        Location location = frameProxy.location();
                        MethodBytecodeUtil.visit(location.method(), location.codeIndex(), new MethodVisitor(458752, (List)targets, suspendContext){
                            boolean myLineMatch;
                            final /* synthetic */ List val$targets;
                            final /* synthetic */ SuspendContextImpl val$suspendContext;
                            {
                                this.val$targets = list;
                                this.val$suspendContext = suspendContextImpl;
                                super(x0);
                                this.myLineMatch = false;
                            }

                            public void visitLineNumber(int line, Label start) {
                                this.myLineMatch = lines.isWithin((Comparable)Integer.valueOf(line - 1));
                            }

                            public void visitMethodInsn(int opcode, String owner2, String name2, String desc, boolean itf) {
                                if (this.myLineMatch) {
                                    this.val$targets.removeIf(t -> {
                                        if (t instanceof MethodSmartStepTarget) {
                                            return DebuggerUtilsEx.methodMatches(((MethodSmartStepTarget)t).getMethod(), owner2.replace("/", "."), name2, desc, this.val$suspendContext.getDebugProcess());
                                        }
                                        return false;
                                    });
                                }
                            }
                        }, true);
                    }
                    catch (Exception e) {
                        LOG.info((Throwable)e);
                    }
                }
                return targets;
            }
        }
        return Collections.emptyList();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "debuggerContext", "com/intellij/debugger/actions/JavaSmartStepIntoHandler", "findSmartStepTargets"));
    }
}

