/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.engine;

import com.intellij.debugger.engine.SuspendContextImpl;
import com.intellij.debugger.engine.events.DebuggerCommandImpl;
import com.intellij.debugger.engine.events.SuspendContextCommandImpl;
import com.intellij.debugger.engine.managerThread.DebuggerCommand;
import com.intellij.debugger.engine.managerThread.DebuggerManagerThread;
import com.intellij.debugger.engine.managerThread.SuspendContextCommand;
import com.intellij.debugger.impl.InvokeAndWaitThread;
import com.intellij.debugger.impl.InvokeThread;
import com.intellij.debugger.impl.PrioritizedTask;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.util.ProgressIndicatorListenerAdapter;
import com.intellij.openapi.progress.util.ProgressWindow;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.wm.ex.ProgressIndicatorEx;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.sun.jdi.VMDisconnectedException;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;

public class DebuggerManagerThreadImpl
extends InvokeAndWaitThread<DebuggerCommandImpl>
implements DebuggerManagerThread,
Disposable {
    private static final Logger LOG = Logger.getInstance(DebuggerManagerThreadImpl.class);
    static final int COMMAND_TIMEOUT = 3000;
    private volatile boolean myDisposed;

    DebuggerManagerThreadImpl(@NotNull Disposable parent, Project project2) {
        if (parent == null) {
            DebuggerManagerThreadImpl.$$$reportNull$$$0(0);
        }
        super(project2);
        Disposer.register((Disposable)parent, (Disposable)this);
    }

    public void dispose() {
        this.myDisposed = true;
    }

    public static DebuggerManagerThreadImpl createTestInstance(@NotNull Disposable parent, Project project2) {
        if (parent == null) {
            DebuggerManagerThreadImpl.$$$reportNull$$$0(1);
        }
        return new DebuggerManagerThreadImpl(parent, project2);
    }

    public static boolean isManagerThread() {
        return DebuggerManagerThreadImpl.currentThread() instanceof DebuggerManagerThreadImpl;
    }

    public static void assertIsManagerThread() {
        LOG.assertTrue(DebuggerManagerThreadImpl.isManagerThread(), (Object)"Should be invoked in manager thread, use DebuggerManagerThreadImpl.getInstance(..).invoke...");
    }

    @Override
    public void invokeAndWait(DebuggerCommandImpl managerCommand) {
        LOG.assertTrue(!DebuggerManagerThreadImpl.isManagerThread(), (Object)"Should be invoked outside manager thread, use DebuggerManagerThreadImpl.getInstance(..).invoke...");
        super.invokeAndWait(managerCommand);
    }

    public void invoke(DebuggerCommandImpl managerCommand) {
        if (DebuggerManagerThreadImpl.currentThread() == this) {
            this.processEvent(managerCommand);
        } else {
            this.schedule(managerCommand);
        }
    }

    public void invoke(PrioritizedTask.Priority priority, final Runnable runnable) {
        this.invoke(new DebuggerCommandImpl(priority){

            @Override
            protected void action() {
                runnable.run();
            }
        });
    }

    @Override
    public boolean pushBack(DebuggerCommandImpl managerCommand) {
        boolean pushed = super.pushBack(managerCommand);
        if (!pushed) {
            managerCommand.notifyCancelled();
        }
        return pushed;
    }

    public void schedule(PrioritizedTask.Priority priority, final Runnable runnable) {
        this.schedule(new DebuggerCommandImpl(priority){

            @Override
            protected void action() {
                runnable.run();
            }
        });
    }

    @Override
    public boolean schedule(DebuggerCommandImpl managerCommand) {
        boolean scheduled = super.schedule(managerCommand);
        if (!scheduled) {
            managerCommand.notifyCancelled();
        }
        return scheduled;
    }

    public void terminateAndInvoke(DebuggerCommandImpl command, int terminateTimeoutMillis) {
        DebuggerCommandImpl currentCommand = (DebuggerCommandImpl)this.myEvents.getCurrentEvent();
        this.invoke(command);
        if (currentCommand != null) {
            AppExecutorUtil.getAppScheduledExecutorService().schedule(() -> {
                if (currentCommand == this.myEvents.getCurrentEvent()) {
                    this.getCurrentRequest().requestStop();
                    try {
                        this.getCurrentRequest().join();
                    }
                    catch (InterruptedException interruptedException) {
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                    finally {
                        if (!this.myDisposed) {
                            this.startNewWorkerThread();
                        }
                    }
                }
            }, (long)terminateTimeoutMillis, TimeUnit.MILLISECONDS);
        }
    }

    @Override
    public void processEvent(@NotNull DebuggerCommandImpl managerCommand) {
        if (managerCommand == null) {
            DebuggerManagerThreadImpl.$$$reportNull$$$0(2);
        }
        DebuggerManagerThreadImpl.assertIsManagerThread();
        try {
            if (this.myEvents.isClosed()) {
                managerCommand.notifyCancelled();
            } else {
                managerCommand.run();
            }
        }
        catch (VMDisconnectedException e) {
            LOG.debug((Throwable)e);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        catch (Exception e) {
            LOG.error((Throwable)e);
        }
    }

    public void startProgress(final DebuggerCommandImpl command, ProgressWindow progressWindow) {
        new ProgressIndicatorListenerAdapter(){

            public void cancelled() {
                command.release();
            }
        }.installToProgress((ProgressIndicatorEx)progressWindow);
        ApplicationManager.getApplication().executeOnPooledThread(() -> ProgressManager.getInstance().runProcess(() -> this.invokeAndWait(command), (ProgressIndicator)progressWindow));
    }

    void startLongProcessAndFork(Runnable process2) {
        DebuggerManagerThreadImpl.assertIsManagerThread();
        this.startNewWorkerThread();
        try {
            process2.run();
        }
        catch (Throwable throwable) {
            InvokeThread.WorkerThreadRequest request = DebuggerManagerThreadImpl.getCurrentThreadRequest();
            if (LOG.isDebugEnabled()) {
                LOG.debug("Switching back to " + request);
            }
            super.invokeAndWait(new DebuggerCommandImpl(request){
                final /* synthetic */ InvokeThread.WorkerThreadRequest val$request;
                {
                    this.val$request = workerThreadRequest;
                }

                @Override
                protected void action() {
                    DebuggerManagerThreadImpl.this.switchToRequest(this.val$request);
                }

                @Override
                protected void commandCancelled() {
                    LOG.debug("Event queue was closed, killing request");
                    this.val$request.requestStop();
                }
            });
            throw throwable;
        }
        InvokeThread.WorkerThreadRequest request = DebuggerManagerThreadImpl.getCurrentThreadRequest();
        if (LOG.isDebugEnabled()) {
            LOG.debug("Switching back to " + request);
        }
        super.invokeAndWait(new /* invalid duplicate definition of identical inner class */);
    }

    public void invokeCommand(final DebuggerCommand command) {
        if (command instanceof SuspendContextCommand) {
            SuspendContextCommand suspendContextCommand = (SuspendContextCommand)command;
            this.schedule(new SuspendContextCommandImpl((SuspendContextImpl)suspendContextCommand.getSuspendContext()){

                @Override
                public void contextAction(@NotNull SuspendContextImpl suspendContext) {
                    if (suspendContext == null) {
                        5.$$$reportNull$$$0(0);
                    }
                    command.action();
                }

                @Override
                protected void commandCancelled() {
                    command.commandCancelled();
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "suspendContext", "com/intellij/debugger/engine/DebuggerManagerThreadImpl$5", "contextAction"));
                }
            });
        } else {
            this.schedule(new DebuggerCommandImpl(){

                @Override
                protected void action() {
                    command.action();
                }

                @Override
                protected void commandCancelled() {
                    command.commandCancelled();
                }
            });
        }
    }

    void restartIfNeeded() {
        if (this.myEvents.isClosed()) {
            this.myEvents.reopen();
            this.startNewWorkerThread();
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "managerCommand";
                break;
            }
        }
        objectArray2[1] = "com/intellij/debugger/engine/DebuggerManagerThreadImpl";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "createTestInstance";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "processEvent";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

