/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.engine.evaluation.expression;

import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.engine.evaluation.EvaluationContextImpl;
import com.intellij.debugger.engine.evaluation.expression.Evaluator;
import org.jetbrains.annotations.Nullable;

public class ReturnEvaluator
implements Evaluator {
    @Nullable
    private final Evaluator myReturnValueEvaluator;

    public ReturnEvaluator(@Nullable Evaluator returnValueEvaluator) {
        this.myReturnValueEvaluator = returnValueEvaluator;
    }

    @Override
    public Object evaluate(EvaluationContextImpl context) throws EvaluateException {
        Object returnValue = this.myReturnValueEvaluator == null ? context.getDebugProcess().getVirtualMachineProxy().mirrorOfVoid() : this.myReturnValueEvaluator.evaluate(context);
        throw new ReturnException(returnValue);
    }

    public static class ReturnException
    extends EvaluateException {
        private final Object myReturnValue;

        public ReturnException(Object returnValue) {
            super("Return");
            this.myReturnValue = returnValue;
        }

        public Object getReturnValue() {
            return this.myReturnValue;
        }
    }
}

