/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.impl.attach;

import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.impl.attach.PidRemoteConnection;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.CapturingProcessAdapter;
import com.intellij.execution.process.CapturingProcessHandler;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.execution.util.ExecUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Key;
import com.intellij.util.io.BaseOutputReader;
import com.sun.jdi.VirtualMachine;
import com.sun.jdi.connect.Connector;
import com.sun.jdi.connect.IllegalConnectorArgumentsException;
import com.sun.tools.jdi.SocketListeningConnector;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class SAJDWPRemoteConnection
extends PidRemoteConnection {
    private static final Logger LOG = Logger.getInstance(SAJDWPRemoteConnection.class);
    private final List<String> myCommands;

    public SAJDWPRemoteConnection(String pid, List<String> commands) {
        super(pid);
        this.setServerMode(true);
        this.setAddress("0");
        this.myCommands = commands;
    }

    @Override
    public Connector getConnector(DebugProcessImpl debugProcess) {
        return new SAJDWPListeningConnector(debugProcess);
    }

    public class SAJDWPListeningConnector
    extends SocketListeningConnector {
        private final DebugProcessImpl myDebugProcess;

        public SAJDWPListeningConnector(DebugProcessImpl process2) {
            this.myDebugProcess = process2;
        }

        @Override
        public String startListening(Map<String, ? extends Connector.Argument> arguments) throws IOException, IllegalConnectorArgumentsException {
            String address = super.startListening(null, arguments);
            SAJDWPRemoteConnection.this.myCommands.set(SAJDWPRemoteConnection.this.myCommands.size() - 1, address);
            return address;
        }

        @Override
        public VirtualMachine accept(Map<String, ? extends Connector.Argument> map) throws IOException, IllegalConnectorArgumentsException {
            try {
                this.startServer(new GeneralCommandLine(SAJDWPRemoteConnection.this.myCommands), false);
            }
            catch (IOException e) {
                throw e;
            }
            catch (Exception e) {
                throw new IOException("Unable to start sa-jdwp server", e);
            }
            return super.accept(map);
        }

        private void startServer(GeneralCommandLine commandLine, final boolean sudo) throws Exception {
            if (sudo) {
                commandLine = ExecUtil.sudoCommand((GeneralCommandLine)commandLine, (String)"Please enter your password to attach with su privileges: ");
            }
            final GeneralCommandLine finalCommandLine = commandLine;
            new CapturingProcessHandler(commandLine){

                protected CapturingProcessAdapter createProcessAdapter(ProcessOutput processOutput) {
                    return new CapturingProcessAdapter(processOutput){

                        public void onTextAvailable(@NotNull ProcessEvent event, @NotNull Key outputType) {
                            if (event == null) {
                                SAJDWPListeningConnector.1.$$$reportNull$$$0(0);
                            }
                            if (outputType == null) {
                                SAJDWPListeningConnector.1.$$$reportNull$$$0(1);
                            }
                            SAJDWPListeningConnector.this.myDebugProcess.printToConsole(event.getText());
                        }

                        public void processTerminated(@NotNull ProcessEvent event) {
                            if (event == null) {
                                SAJDWPListeningConnector.1.$$$reportNull$$$0(2);
                            }
                            if (!sudo && SAJDWPListeningConnector.this.myDebugProcess.isInInitialState()) {
                                try {
                                    SAJDWPListeningConnector.this.startServer(finalCommandLine, true);
                                }
                                catch (Exception e) {
                                    LOG.error((Throwable)e);
                                }
                            } else {
                                SAJDWPListeningConnector.this.myDebugProcess.stop(true);
                            }
                        }

                        private static /* synthetic */ void $$$reportNull$$$0(int n) {
                            Object[] objectArray;
                            Object[] objectArray2;
                            Object[] objectArray3 = new Object[3];
                            switch (n) {
                                default: {
                                    objectArray2 = objectArray3;
                                    objectArray3[0] = "event";
                                    break;
                                }
                                case 1: {
                                    objectArray2 = objectArray3;
                                    objectArray3[0] = "outputType";
                                    break;
                                }
                            }
                            objectArray2[1] = "com/intellij/debugger/impl/attach/SAJDWPRemoteConnection$SAJDWPListeningConnector$1$1";
                            switch (n) {
                                default: {
                                    objectArray = objectArray2;
                                    objectArray2[2] = "onTextAvailable";
                                    break;
                                }
                                case 2: {
                                    objectArray = objectArray2;
                                    objectArray2[2] = "processTerminated";
                                    break;
                                }
                            }
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                        }
                    };
                }

                @NotNull
                protected BaseOutputReader.Options readerOptions() {
                    BaseOutputReader.Options options = BaseOutputReader.Options.forMostlySilentProcess();
                    if (options == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    return options;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/debugger/impl/attach/SAJDWPRemoteConnection$SAJDWPListeningConnector$1", "readerOptions"));
                }
            }.startNotify();
        }
    }
}

