/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.ui.breakpoints;

import com.intellij.debugger.DebuggerBundle;
import com.intellij.ide.util.ClassFilter;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.classFilter.ClassFilterEditor;
import com.intellij.util.ui.JBUI;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import javax.swing.Box;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.border.Border;

public class EditClassFiltersDialog
extends DialogWrapper {
    private ClassFilterEditor myClassFilterEditor;
    private ClassFilterEditor myClassExclusionFilterEditor;
    private final Project myProject;
    private final ClassFilter myChooserFilter;

    public EditClassFiltersDialog(Project project2) {
        this(project2, null);
    }

    public EditClassFiltersDialog(Project project2, ClassFilter filter) {
        super(project2, true);
        this.myChooserFilter = filter;
        this.myProject = project2;
        this.setTitle(DebuggerBundle.message((String)"class.filters.dialog.title", (Object[])new Object[0]));
        this.init();
    }

    protected ClassFilterEditor createClassFilterEditor(Project project2) {
        return new ClassFilterEditor(project2, this.myChooserFilter, "reference.viewBreakpoints.classFilters.newPattern");
    }

    protected JComponent createCenterPanel() {
        JPanel contentPanel = new JPanel(new BorderLayout());
        Box mainPanel = Box.createHorizontalBox();
        this.myClassFilterEditor = this.createClassFilterEditor(this.myProject);
        this.myClassFilterEditor.setPreferredSize((Dimension)JBUI.size((int)400, (int)200));
        this.myClassFilterEditor.setBorder((Border)IdeBorderFactory.createTitledBorder((String)DebuggerBundle.message((String)"class.filters.dialog.inclusion.filters.group", (Object[])new Object[0]), (boolean)false));
        mainPanel.add((Component)this.myClassFilterEditor);
        this.myClassExclusionFilterEditor = this.createClassFilterEditor(this.myProject);
        this.myClassExclusionFilterEditor.setPreferredSize((Dimension)JBUI.size((int)400, (int)200));
        this.myClassExclusionFilterEditor.setBorder((Border)IdeBorderFactory.createTitledBorder((String)DebuggerBundle.message((String)"class.filters.dialog.exclusion.filters.group", (Object[])new Object[0]), (boolean)false));
        mainPanel.add((Component)this.myClassExclusionFilterEditor);
        contentPanel.add((Component)mainPanel, "Center");
        return contentPanel;
    }

    public void dispose() {
        this.myClassFilterEditor.stopEditing();
        this.myClassExclusionFilterEditor.stopEditing();
        super.dispose();
    }

    public void setFilters(com.intellij.ui.classFilter.ClassFilter[] filters, com.intellij.ui.classFilter.ClassFilter[] inverseFilters) {
        this.myClassFilterEditor.setFilters(filters);
        this.myClassExclusionFilterEditor.setFilters(inverseFilters);
    }

    protected String getDimensionServiceKey() {
        return "#com.intellij.debugger.ui.breakpoints.EditClassFiltersDialog";
    }

    public com.intellij.ui.classFilter.ClassFilter[] getFilters() {
        return this.myClassFilterEditor.getFilters();
    }

    public com.intellij.ui.classFilter.ClassFilter[] getExclusionFilters() {
        return this.myClassExclusionFilterEditor.getFilters();
    }

    protected String getHelpId() {
        return "reference.viewBreakpoints.classFilters";
    }
}

