/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.ui.breakpoints;

import com.intellij.debugger.SourcePosition;
import com.intellij.debugger.engine.BreakpointStepMethodFilter;
import com.intellij.debugger.engine.CompoundPositionManager;
import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.LambdaMethodFilter;
import com.intellij.debugger.engine.RequestHint;
import com.intellij.debugger.engine.SuspendContextImpl;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.engine.events.SuspendContextCommandImpl;
import com.intellij.debugger.engine.requests.LocatableEventRequestor;
import com.intellij.debugger.impl.DebuggerUtilsEx;
import com.intellij.debugger.ui.breakpoints.RunToCursorBreakpoint;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiFile;
import com.intellij.ui.classFilter.ClassFilter;
import com.intellij.util.Consumer;
import com.intellij.util.containers.MultiMap;
import com.sun.jdi.ClassNotPreparedException;
import com.sun.jdi.Location;
import com.sun.jdi.Method;
import com.sun.jdi.ObjectCollectedException;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.event.LocatableEvent;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StepIntoBreakpoint
extends RunToCursorBreakpoint {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.debugger.ui.breakpoints.StepIntoBreakpoint");
    @NotNull
    private final BreakpointStepMethodFilter myFilter;
    @Nullable
    private RequestHint myHint;

    protected StepIntoBreakpoint(@NotNull Project project2, @NotNull SourcePosition pos, @NotNull BreakpointStepMethodFilter filter) {
        if (project2 == null) {
            StepIntoBreakpoint.$$$reportNull$$$0(0);
        }
        if (pos == null) {
            StepIntoBreakpoint.$$$reportNull$$$0(1);
        }
        if (filter == null) {
            StepIntoBreakpoint.$$$reportNull$$$0(2);
        }
        super(project2, pos, false);
        this.myFilter = filter;
    }

    @Override
    protected void createRequestForPreparedClass(DebugProcessImpl debugProcess, ReferenceType classType) {
        try {
            int lastLine;
            CompoundPositionManager positionManager = debugProcess.getPositionManager();
            List<Location> locations = positionManager.locationsOfLine(classType, this.myCustomPosition);
            if (locations.isEmpty() && (lastLine = this.myFilter.getLastStatementLine()) >= 0) {
                int nextLine = this.myCustomPosition.getLine() + 1;
                while (nextLine <= lastLine && locations.isEmpty()) {
                    locations = positionManager.locationsOfLine(classType, SourcePosition.createFromLine((PsiFile)this.myCustomPosition.getFile(), (int)nextLine++));
                }
            }
            if (!locations.isEmpty()) {
                MultiMap methods = new MultiMap();
                for (Location loc : locations) {
                    if (!this.acceptLocation(debugProcess, classType, loc)) continue;
                    methods.putValue((Object)loc.method(), (Object)loc);
                }
                Location location = null;
                int methodsFound = methods.size();
                if (methodsFound == 1) {
                    location = (Location)methods.values().iterator().next();
                } else if (this.myFilter instanceof LambdaMethodFilter) {
                    LambdaMethodFilter lambdaFilter = (LambdaMethodFilter)this.myFilter;
                    if (lambdaFilter.getLambdaOrdinal() < methodsFound) {
                        Method[] candidates = methods.keySet().toArray(new Method[methodsFound]);
                        Arrays.sort(candidates, DebuggerUtilsEx.LAMBDA_ORDINAL_COMPARATOR);
                        location = (Location)methods.get((Object)candidates[lambdaFilter.getLambdaOrdinal()]).iterator().next();
                    }
                } else if (methodsFound > 0) {
                    location = (Location)methods.values().iterator().next();
                }
                StepIntoBreakpoint.createLocationBreakpointRequest(this, location, debugProcess);
            }
        }
        catch (ClassNotPreparedException ex) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("ClassNotPreparedException: " + ex.getMessage());
            }
        }
        catch (ObjectCollectedException ex) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("ObjectCollectedException: " + ex.getMessage());
            }
        }
        catch (Exception ex) {
            LOG.info((Throwable)ex);
        }
    }

    @Override
    protected boolean acceptLocation(DebugProcessImpl debugProcess, ReferenceType classType, Location loc) {
        try {
            return this.myFilter.locationMatches(debugProcess, loc);
        }
        catch (EvaluateException e) {
            LOG.info((Throwable)e);
            return true;
        }
    }

    @Nullable
    protected static StepIntoBreakpoint create(@NotNull Project project2, @NotNull BreakpointStepMethodFilter filter) {
        SourcePosition pos;
        if (project2 == null) {
            StepIntoBreakpoint.$$$reportNull$$$0(3);
        }
        if (filter == null) {
            StepIntoBreakpoint.$$$reportNull$$$0(4);
        }
        if ((pos = filter.getBreakpointPosition()) != null) {
            StepIntoBreakpoint breakpoint = new StepIntoBreakpoint(project2, pos, filter);
            breakpoint.init();
            return breakpoint;
        }
        return null;
    }

    @Override
    public boolean processLocatableEvent(SuspendContextCommandImpl action, LocatableEvent event) throws LocatableEventRequestor.EventProcessingException {
        SuspendContextImpl context;
        boolean res = super.processLocatableEvent(action, event);
        if (res && this.myHint != null && this.myHint.isResetIgnoreFilters() && (context = action.getSuspendContext()) != null) {
            DebugProcessImpl process2 = context.getDebugProcess();
            process2.checkPositionNotFiltered(context.getThread(), (Consumer<List<ClassFilter>>)((Consumer)f -> process2.getSession().resetIgnoreStepFiltersFlag()));
        }
        return res;
    }

    public void setRequestHint(RequestHint hint) {
        this.myHint = hint;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pos";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filter";
                break;
            }
        }
        objectArray2[1] = "com/intellij/debugger/ui/breakpoints/StepIntoBreakpoint";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "create";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

