/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.ui.impl.watch;

import com.intellij.debugger.DebuggerBundle;
import com.intellij.debugger.engine.StackFrameContext;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.engine.evaluation.EvaluateExceptionUtil;
import com.intellij.debugger.engine.evaluation.EvaluationContextImpl;
import com.intellij.debugger.engine.evaluation.TextWithImports;
import com.intellij.debugger.impl.DebuggerUtilsImpl;
import com.intellij.debugger.ui.impl.watch.EvaluationDescriptor;
import com.intellij.debugger.ui.impl.watch.ValueDescriptorImpl;
import com.intellij.debugger.ui.tree.UserExpressionDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaCodeFragment;
import com.intellij.psi.PsiCodeFragment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiType;
import com.sun.jdi.Type;
import org.jetbrains.annotations.Nullable;

public class UserExpressionDescriptorImpl
extends EvaluationDescriptor
implements UserExpressionDescriptor {
    private final ValueDescriptorImpl myParentDescriptor;
    private final String myTypeName;
    private final String myName;
    private final int myEnumerationIndex;

    public UserExpressionDescriptorImpl(Project project2, ValueDescriptorImpl parent, String typeName, String name2, TextWithImports text, int enumerationIndex) {
        super(text, project2);
        this.myParentDescriptor = parent;
        this.myTypeName = typeName;
        this.myName = name2;
        this.myEnumerationIndex = enumerationIndex;
    }

    @Override
    public String getName() {
        return StringUtil.isEmpty((String)this.myName) ? this.myText.getText() : this.myName;
    }

    @Override
    @Nullable
    public String getDeclaredType() {
        Type type = this.getType();
        return type != null ? type.name() : null;
    }

    @Override
    protected PsiCodeFragment getEvaluationCode(StackFrameContext context) throws EvaluateException {
        Pair<PsiElement, PsiType> psiClassAndType = DebuggerUtilsImpl.getPsiClassAndType(this.myTypeName, this.myProject);
        if (psiClassAndType.first == null) {
            throw EvaluateExceptionUtil.createEvaluateException((String)DebuggerBundle.message((String)"evaluation.error.invalid.type.name", (Object[])new Object[]{this.myTypeName}));
        }
        PsiCodeFragment fragment = this.createCodeFragment((PsiElement)psiClassAndType.first);
        if (fragment instanceof JavaCodeFragment) {
            ((JavaCodeFragment)fragment).setThisType((PsiType)psiClassAndType.second);
        }
        return fragment;
    }

    public ValueDescriptorImpl getParentDescriptor() {
        return this.myParentDescriptor;
    }

    @Override
    protected EvaluationContextImpl getEvaluationContext(EvaluationContextImpl evaluationContext) {
        return evaluationContext.createEvaluationContext(this.myParentDescriptor.getValue());
    }

    public int getEnumerationIndex() {
        return this.myEnumerationIndex;
    }
}

