/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.ui.tree.render;

import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.SuspendContextImpl;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.engine.evaluation.EvaluationContext;
import com.intellij.debugger.engine.evaluation.EvaluationContextImpl;
import com.intellij.debugger.engine.events.SuspendContextCommandImpl;
import com.intellij.debugger.settings.NodeRendererSettings;
import com.intellij.debugger.ui.tree.ValueDescriptor;
import com.intellij.debugger.ui.tree.render.CompoundReferenceRenderer;
import com.intellij.debugger.ui.tree.render.CompoundTypeRenderer;
import com.intellij.debugger.ui.tree.render.DescriptorLabelListener;
import com.intellij.util.ui.ColorIcon;
import com.intellij.util.ui.JBUI;
import com.sun.jdi.ClassType;
import com.sun.jdi.Field;
import com.sun.jdi.IntegerValue;
import com.sun.jdi.Method;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.Value;
import java.awt.Color;
import java.util.Collections;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

class ColorObjectRenderer
extends CompoundReferenceRenderer {
    ColorObjectRenderer(NodeRendererSettings rendererSettings) {
        super(rendererSettings, "Color", null, null);
        this.setClassName("java.awt.Color");
        this.setEnabled(true);
    }

    @Override
    public Icon calcValueIcon(final ValueDescriptor descriptor2, final EvaluationContext evaluationContext, final DescriptorLabelListener listener) throws EvaluateException {
        Value value = descriptor2.getValue();
        if (value instanceof ObjectReference) {
            try {
                final ObjectReference objRef = (ObjectReference)value;
                ReferenceType refType = objRef.referenceType();
                if (refType instanceof ClassType) {
                    Value rgbValue = null;
                    final Method getRGBMethod = ((ClassType)refType).concreteMethodByName("getRGB", "()I");
                    if (getRGBMethod != null) {
                        Field valueField;
                        ReferenceType rgbMethodDeclaringType = getRGBMethod.declaringType();
                        if (rgbMethodDeclaringType.name().equals(this.getClassName()) && (valueField = rgbMethodDeclaringType.fieldByName("value")) != null) {
                            rgbValue = objRef.getValue(valueField);
                        }
                        if (rgbValue instanceof IntegerValue) {
                            return ColorObjectRenderer.createIcon((IntegerValue)rgbValue);
                        }
                        EvaluationContextImpl evalContext = (EvaluationContextImpl)evaluationContext;
                        final DebugProcessImpl debugProcess = evalContext.getDebugProcess();
                        debugProcess.getManagerThread().schedule(new SuspendContextCommandImpl(evalContext.getSuspendContext()){

                            @Override
                            public void contextAction(@NotNull SuspendContextImpl suspendContext) {
                                if (suspendContext == null) {
                                    1.$$$reportNull$$$0(0);
                                }
                                try {
                                    Value rgbValue = debugProcess.invokeMethod(evaluationContext, objRef, getRGBMethod, Collections.emptyList());
                                    if (rgbValue instanceof IntegerValue) {
                                        descriptor2.setValueIcon(ColorObjectRenderer.createIcon((IntegerValue)rgbValue));
                                        listener.labelChanged();
                                    }
                                }
                                catch (EvaluateException e) {
                                    CompoundTypeRenderer.LOG.info((Throwable)e);
                                }
                            }

                            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "suspendContext", "com/intellij/debugger/ui/tree/render/ColorObjectRenderer$1", "contextAction"));
                            }
                        });
                    }
                }
            }
            catch (Exception e) {
                throw new EvaluateException(e.getMessage(), (Throwable)e);
            }
        }
        return null;
    }

    private static Icon createIcon(IntegerValue rgbValue) {
        return JBUI.scale((JBUI.JBIcon)new ColorIcon(16, 12, new Color(rgbValue.value(), true), true));
    }
}

