/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.designer.componentTree;

import com.intellij.codeHighlighting.HighlightDisplayLevel;
import com.intellij.codeInsight.daemon.impl.SeverityRegistrar;
import com.intellij.designer.actions.DesignerActionPanel;
import com.intellij.designer.actions.SelectAllAction;
import com.intellij.designer.actions.StartInplaceEditing;
import com.intellij.designer.componentTree.AttributeWrapper;
import com.intellij.designer.componentTree.QuickFixManager;
import com.intellij.designer.componentTree.TreeNodeDescriptor;
import com.intellij.designer.designSurface.DesignerEditorPanel;
import com.intellij.designer.designSurface.EditableArea;
import com.intellij.designer.model.ErrorInfo;
import com.intellij.designer.model.RadComponent;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.project.Project;
import com.intellij.ui.ColoredTreeCellRenderer;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.util.ui.tree.TreeUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JTree;
import javax.swing.JViewport;
import javax.swing.ToolTipManager;
import javax.swing.border.LineBorder;
import javax.swing.plaf.TreeUI;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ComponentTree
extends Tree
implements DataProvider {
    private final StartInplaceEditing myInplaceEditingAction;
    private QuickFixManager myQuickFixManager;
    private DesignerEditorPanel myDesigner;
    private EditableArea myArea;
    private RadComponent myMarkComponent;
    private int myMarkFeedback;

    public ComponentTree() {
        this.newModel();
        this.setScrollsOnExpand(true);
        this.installCellRenderer();
        this.setRootVisible(false);
        this.setShowsRootHandles(true);
        ToolTipManager.sharedInstance().registerComponent((JComponent)((Object)this));
        TreeUtil.installActions((JTree)((Object)this));
        this.myInplaceEditingAction = DesignerActionPanel.createInplaceEditingAction((JComponent)((Object)this));
    }

    public void setUI(TreeUI ui) {
        super.setUI(ui);
        this.getActionMap().put("selectAll", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (ComponentTree.this.myDesigner != null) {
                    ((SelectAllAction)ComponentTree.this.myDesigner.getActionPanel().createSelectAllAction(ComponentTree.this.myDesigner.getSurfaceArea())).perform();
                }
            }
        });
    }

    public void newModel() {
        this.setModel(new DefaultTreeModel(new DefaultMutableTreeNode()));
    }

    public void initQuickFixManager(JViewport viewPort) {
        this.myQuickFixManager = new QuickFixManager((JComponent)((Object)this), viewPort);
    }

    public void updateInspections() {
        this.myQuickFixManager.update();
    }

    public void setDesignerPanel(@Nullable DesignerEditorPanel designer) {
        this.myDesigner = designer;
        this.myMarkComponent = null;
        this.myArea = null;
        this.myInplaceEditingAction.setDesignerPanel(designer);
        this.myQuickFixManager.setDesigner(designer);
    }

    public void setArea(@Nullable EditableArea area) {
        this.myArea = area;
        this.myQuickFixManager.setEditableArea(area);
    }

    public void mark(RadComponent component, int feedback) {
        this.myMarkComponent = component;
        this.myMarkFeedback = feedback;
        this.repaint();
    }

    public Object getData(@NotNull @NonNls String dataId) {
        if (dataId == null) {
            ComponentTree.$$$reportNull$$$0(0);
        }
        if (EditableArea.DATA_KEY.is(dataId)) {
            return this.myArea;
        }
        if (this.myDesigner != null) {
            if (PlatformDataKeys.FILE_EDITOR.is(dataId)) {
                return this.myDesigner.getEditor();
            }
            return this.myDesigner.getActionPanel().getData(dataId);
        }
        return null;
    }

    @Nullable
    public RadComponent extractComponent(Object value) {
        TreeNodeDescriptor descriptor2;
        Object element;
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)value;
        Object userObject = node.getUserObject();
        if (this.myDesigner != null && userObject instanceof TreeNodeDescriptor && (element = (descriptor2 = (TreeNodeDescriptor)((Object)userObject)).getElement()) instanceof RadComponent) {
            return (RadComponent)((Object)element);
        }
        return null;
    }

    public int getEdgeSize() {
        return Math.max(5, ((JComponent)((Object)this.getCellRenderer())).getPreferredSize().height / 2 - 3);
    }

    public String getToolTipText(MouseEvent event) {
        List<ErrorInfo> errorInfos;
        RadComponent component;
        TreePath path = this.getPathForLocation(event.getX(), event.getY());
        if (path != null && (component = this.extractComponent(path.getLastPathComponent())) != null && !(errorInfos = RadComponent.getError(component)).isEmpty()) {
            return errorInfos.get(0).getName();
        }
        return super.getToolTipText(event);
    }

    @Nullable
    private static HighlightDisplayLevel getHighlightDisplayLevel(Project project2, RadComponent component) {
        HighlightDisplayLevel displayLevel = null;
        SeverityRegistrar severityRegistrar = SeverityRegistrar.getSeverityRegistrar((Project)project2);
        for (ErrorInfo errorInfo : RadComponent.getError(component)) {
            if (displayLevel != null && severityRegistrar.compare(errorInfo.getLevel().getSeverity(), displayLevel.getSeverity()) <= 0) continue;
            displayLevel = errorInfo.getLevel();
        }
        return displayLevel;
    }

    private AttributeWrapper getAttributeWrapper(RadComponent component) {
        AttributeWrapper wrapper = AttributeWrapper.DEFAULT;
        HighlightDisplayLevel level = ComponentTree.getHighlightDisplayLevel(this.myDesigner.getProject(), component);
        if (level != null) {
            TextAttributesKey attributesKey = SeverityRegistrar.getSeverityRegistrar((Project)this.myDesigner.getProject()).getHighlightInfoTypeBySeverity(level.getSeverity()).getAttributesKey();
            final TextAttributes textAttributes = EditorColorsManager.getInstance().getGlobalScheme().getAttributes(attributesKey);
            wrapper = new AttributeWrapper(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public SimpleTextAttributes getAttribute(SimpleTextAttributes attributes) {
                    Color bgColor = textAttributes.getBackgroundColor();
                    try {
                        textAttributes.setBackgroundColor(null);
                        SimpleTextAttributes simpleTextAttributes = SimpleTextAttributes.fromTextAttributes((TextAttributes)TextAttributes.merge((TextAttributes)attributes.toTextAttributes(), (TextAttributes)textAttributes));
                        return simpleTextAttributes;
                    }
                    finally {
                        textAttributes.setBackgroundColor(bgColor);
                    }
                }
            };
        }
        return wrapper;
    }

    private void installCellRenderer() {
        this.setCellRenderer((TreeCellRenderer)new ColoredTreeCellRenderer(){

            public void customizeCellRenderer(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
                try {
                    RadComponent component = ComponentTree.this.extractComponent(value);
                    if (component != null) {
                        ComponentTree.this.myDesigner.getTreeDecorator().decorate(component, (SimpleColoredComponent)this, ComponentTree.this.getAttributeWrapper(component), true);
                        if (ComponentTree.this.myMarkComponent == component) {
                            if (ComponentTree.this.myMarkFeedback == 2) {
                                this.setBorder(BorderFactory.createLineBorder(Color.RED, 1));
                            } else {
                                this.setBorder(new InsertBorder(ComponentTree.this.myMarkFeedback));
                            }
                        } else {
                            this.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
                        }
                    }
                }
                catch (RuntimeException e) {
                    if (ComponentTree.this.myDesigner == null) {
                        throw e;
                    }
                    ComponentTree.this.myDesigner.showError("Tree paint operation", e);
                }
            }
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataId", "com/intellij/designer/componentTree/ComponentTree", "getData"));
    }

    private static class InsertBorder
    extends LineBorder {
        private final int myMode;

        InsertBorder(int mode) {
            super(Color.BLACK, 2);
            this.myMode = mode;
        }

        @Override
        public Insets getBorderInsets(Component component) {
            return this.getBorderInsets(component, new Insets(0, 0, 0, 0));
        }

        @Override
        public Insets getBorderInsets(Component component, Insets insets) {
            insets.top = this.myMode == 0 ? this.thickness : 0;
            insets.left = insets.right = this.thickness;
            insets.bottom = this.myMode == 1 ? this.thickness : 0;
            return insets;
        }

        @Override
        public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
            Color oldColor = g.getColor();
            g.setColor(this.getLineColor());
            if (this.myMode == 0) {
                g.fillRect(x, y, width, this.thickness);
                g.fillRect(x, y, this.thickness, 2 * this.thickness);
                g.fillRect(x + width - this.thickness, y, this.thickness, 2 * this.thickness);
            } else {
                g.fillRect(x, y + height - this.thickness, width, this.thickness);
                g.fillRect(x, y + height - 2 * this.thickness, this.thickness, 2 * this.thickness);
                g.fillRect(x + width - this.thickness, y + height - 2 * this.thickness, this.thickness, 2 * this.thickness);
            }
            g.setColor(oldColor);
        }
    }
}

