/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.designer.designSurface;

import com.intellij.designer.DesignerBundle;
import com.intellij.designer.designSurface.ComponentSelectionListener;
import com.intellij.designer.designSurface.DesignerEditorPanel;
import com.intellij.designer.designSurface.EditableArea;
import com.intellij.designer.designSurface.feedbacks.LineMarginBorder;
import com.intellij.designer.model.PropertiesContainer;
import com.intellij.designer.model.Property;
import com.intellij.designer.model.PropertyContext;
import com.intellij.designer.model.RadComponent;
import com.intellij.designer.propertyTable.InplaceContext;
import com.intellij.designer.propertyTable.PropertyEditor;
import com.intellij.designer.propertyTable.PropertyEditorListener;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonShortcuts;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.wm.FocusWatcher;
import com.intellij.openapi.wm.ex.IdeFocusTraversalPolicy;
import com.intellij.openapi.wm.ex.LayoutFocusTraversalPolicyExt;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.util.ThrowableRunnable;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.event.FocusEvent;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class InplaceEditingLayer
extends JComponent {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.designer.designSurface.InplaceEditingLayer");
    private final FocusWatcher myFocusWatcher = new FocusWatcher(){

        protected void focusLostImpl(FocusEvent e) {
            Component opposite = e.getOppositeComponent();
            if (e.isTemporary() || opposite != null && SwingUtilities.isDescendingFrom(opposite, this.getTopComponent())) {
                return;
            }
            ApplicationManager.getApplication().invokeLater(() -> InplaceEditingLayer.this.finishEditing(true), ModalityState.NON_MODAL);
        }
    };
    private final ComponentSelectionListener mySelectionListener = new ComponentSelectionListener(){

        @Override
        public void selectionChanged(EditableArea area) {
            InplaceEditingLayer.this.finishEditing(true);
        }
    };
    private final PropertyEditorListener myEditorListener = new PropertyEditorListener(){

        public void valueCommitted(@NotNull PropertyEditor source, boolean continueEditing, boolean closeEditorOnError) {
            if (source == null) {
                3.$$$reportNull$$$0(0);
            }
            InplaceEditingLayer.this.finishEditing(true);
        }

        public void editingCanceled(@NotNull PropertyEditor source) {
            if (source == null) {
                3.$$$reportNull$$$0(1);
            }
            InplaceEditingLayer.this.finishEditing(false);
        }

        public void preferredSizeChanged(@NotNull PropertyEditor source) {
            if (source == null) {
                3.$$$reportNull$$$0(2);
            }
            InplaceEditingLayer.this.adjustInplaceComponentSize();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "source";
            objectArray2[1] = "com/intellij/designer/designSurface/InplaceEditingLayer$3";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "valueCommitted";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "editingCanceled";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "preferredSizeChanged";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    };
    private RadComponent myRadComponent;
    private List<Property> myProperties;
    private List<PropertyEditor> myEditors;
    private final DesignerEditorPanel myDesigner;
    private JComponent myInplaceComponent;
    private int myPreferredWidth;

    public InplaceEditingLayer(DesignerEditorPanel designer) {
        this.myDesigner = designer;
    }

    public void startEditing(@Nullable InplaceContext inplaceContext) {
        try {
            List<RadComponent> selection = this.myDesigner.getSurfaceArea().getSelection();
            if (selection.size() != 1) {
                return;
            }
            this.myRadComponent = selection.get(0);
            this.myProperties = this.myRadComponent.getInplaceProperties();
            if (this.myProperties.isEmpty()) {
                this.myRadComponent = null;
                this.myProperties = null;
                return;
            }
            this.myInplaceComponent = new JPanel((LayoutManager)new GridLayoutManager(this.myProperties.size(), 2));
            this.myInplaceComponent.setBorder(new LineMarginBorder(5, 5, 5, 5));
            new AnAction(){

                public void actionPerformed(@NotNull AnActionEvent e) {
                    if (e == null) {
                        4.$$$reportNull$$$0(0);
                    }
                    InplaceEditingLayer.this.finishEditing(false);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/designer/designSurface/InplaceEditingLayer$4", "actionPerformed"));
                }
            }.registerCustomShortcutSet(CommonShortcuts.ESCAPE, this.myInplaceComponent);
            this.myEditors = new ArrayList<PropertyEditor>();
            JComponent componentToFocus = null;
            Font font = null;
            if (inplaceContext == null) {
                inplaceContext = new InplaceContext();
            }
            int row = 0;
            for (Property property : this.myProperties) {
                JLabel label = new JLabel(property.getName() + ":");
                if (font == null) {
                    font = label.getFont().deriveFont(1);
                }
                label.setFont(font);
                this.myInplaceComponent.add((Component)label, new GridConstraints(row, 0, 1, 1, 8, 0, 0, 0, null, null, null));
                PropertyEditor editor = property.getEditor();
                this.myEditors.add(editor);
                JComponent component = editor.getComponent((PropertiesContainer)this.myRadComponent, (PropertyContext)this.myDesigner, property.getValue((PropertiesContainer)this.myRadComponent), inplaceContext);
                this.myInplaceComponent.add((Component)component, new GridConstraints(row++, 1, 1, 1, 0, 1, 2, 0, null, null, null));
                if (componentToFocus != null) continue;
                componentToFocus = editor.getPreferredFocusedComponent();
            }
            for (PropertyEditor editor : this.myEditors) {
                editor.addPropertyEditorListener(this.myEditorListener);
            }
            Rectangle bounds = this.myRadComponent.getBounds(this);
            Dimension size = this.myInplaceComponent.getPreferredSize();
            this.myPreferredWidth = Math.max(size.width, bounds.width);
            this.myInplaceComponent.setBounds(bounds.x, bounds.y, this.myPreferredWidth, size.height);
            this.add(this.myInplaceComponent);
            this.myDesigner.getSurfaceArea().addSelectionListener(this.mySelectionListener);
            if (componentToFocus == null) {
                componentToFocus = IdeFocusTraversalPolicy.getPreferredFocusedComponent((JComponent)this.myInplaceComponent);
            }
            if (componentToFocus == null) {
                componentToFocus = this.myInplaceComponent;
            }
            if (componentToFocus.requestFocusInWindow()) {
                this.myFocusWatcher.install((Component)this.myInplaceComponent);
            } else {
                this.grabFocus();
                JComponent finalComponentToFocus = componentToFocus;
                ApplicationManager.getApplication().invokeLater(() -> {
                    finalComponentToFocus.requestFocusInWindow();
                    this.myFocusWatcher.install((Component)this.myInplaceComponent);
                });
            }
            this.enableEvents(16L);
            this.repaint();
        }
        catch (Throwable e) {
            LOG.error(e);
        }
    }

    private void finishEditing(boolean commit) {
        this.myDesigner.getSurfaceArea().removeSelectionListener(this.mySelectionListener);
        if (this.myInplaceComponent != null) {
            if (commit) {
                this.myDesigner.getToolProvider().execute((ThrowableRunnable<Exception>)((ThrowableRunnable)() -> {
                    int size = this.myProperties.size();
                    for (int i = 0; i < size; ++i) {
                        Object newValue;
                        Property property = this.myProperties.get(i);
                        Object oldValue = property.getValue((PropertiesContainer)this.myRadComponent);
                        if (Comparing.equal((Object)oldValue, (Object)(newValue = this.myEditors.get(i).getValue()))) continue;
                        property.setValue((PropertiesContainer)this.myRadComponent, newValue);
                    }
                }), DesignerBundle.message("command.set.property.value", new Object[0]), true);
            }
            for (PropertyEditor editor : this.myEditors) {
                editor.removePropertyEditorListener(this.myEditorListener);
            }
            this.removeInplaceComponent();
            this.myFocusWatcher.deinstall((Component)this.myInplaceComponent);
            this.myInplaceComponent = null;
        }
        this.myRadComponent = null;
        this.myProperties = null;
        this.myEditors = null;
        this.myDesigner.getPreferredFocusedComponent().requestFocusInWindow();
        this.disableEvents(16L);
        this.repaint();
    }

    private void adjustInplaceComponentSize() {
        this.myInplaceComponent.revalidate();
        Dimension size = this.myInplaceComponent.getPreferredSize();
        this.myInplaceComponent.setSize(Math.max(size.width, this.myPreferredWidth), this.myInplaceComponent.getHeight());
        this.myInplaceComponent.revalidate();
        this.repaint();
    }

    private void removeInplaceComponent() {
        LayoutFocusTraversalPolicyExt.setOverridenDefaultComponent((JComponent)this.myDesigner.getPreferredFocusedComponent());
        try {
            this.remove(this.myInplaceComponent);
        }
        finally {
            LayoutFocusTraversalPolicyExt.setOverridenDefaultComponent(null);
        }
    }

    @Override
    protected void processMouseEvent(MouseEvent e) {
        if (this.myInplaceComponent != null && (501 == e.getID() || 502 == e.getID())) {
            this.finishEditing(true);
        }
        super.processMouseEvent(e);
    }

    public boolean isEditing() {
        return this.myInplaceComponent != null;
    }
}

