/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.designer.model;

import com.intellij.designer.model.MetaModel;
import com.intellij.designer.model.ModelLoader;
import com.intellij.designer.model.RadComponent;
import com.intellij.designer.model.VariationPaletteItem;
import com.intellij.designer.palette.DefaultPaletteItem;
import com.intellij.designer.palette.PaletteGroup;
import com.intellij.designer.palette.PaletteItem;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jdom.Attribute;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class MetaManager
extends ModelLoader {
    private static final String META = "meta";
    private static final String PALETTE = "palette";
    private static final String GROUP = "group";
    private static final String NAME = "name";
    private static final String ITEM = "item";
    private static final String TAG = "tag";
    private static final String WRAP_IN = "wrap-in";
    private final Map<String, MetaModel> myTag2Model = new HashMap<String, MetaModel>();
    private final Map<String, MetaModel> myTarget2Model = new HashMap<String, MetaModel>();
    private final List<PaletteGroup> myPaletteGroups = new ArrayList<PaletteGroup>();
    private final List<MetaModel> myWrapModels = new ArrayList<MetaModel>();
    private final Map<Object, Object> myCache = new HashMap<Object, Object>();

    protected MetaManager(Project project2, String name2) {
        super(project2);
        this.load(name2);
    }

    @Override
    protected void loadDocument(Element rootElement) throws Exception {
        ClassLoader classLoader = this.getClass().getClassLoader();
        HashMap<MetaModel, List<String>> modelToMorphing = new HashMap<MetaModel, List<String>>();
        for (Element element : rootElement.getChildren(META)) {
            this.loadModel(classLoader, element, modelToMorphing);
        }
        for (Element element : rootElement.getChild(PALETTE).getChildren(GROUP)) {
            this.loadGroup(element);
        }
        Element wrapInElement = rootElement.getChild(WRAP_IN);
        if (wrapInElement != null) {
            for (Element element : wrapInElement.getChildren(ITEM)) {
                this.myWrapModels.add(this.myTag2Model.get(element.getAttributeValue(TAG)));
            }
        }
        for (Map.Entry entry : modelToMorphing.entrySet()) {
            MetaModel meta = (MetaModel)entry.getKey();
            ArrayList<MetaModel> morphingModels = new ArrayList<MetaModel>();
            for (String tag : (List)entry.getValue()) {
                MetaModel morphingModel = this.myTag2Model.get(tag);
                if (morphingModel == null) continue;
                morphingModels.add(morphingModel);
            }
            if (morphingModels.isEmpty()) continue;
            meta.setMorphingModels(morphingModels);
        }
    }

    @NotNull
    protected MetaModel loadModel(ClassLoader classLoader, Element element, Map<MetaModel, List<String>> modelToMorphing) throws Exception {
        Element morphing;
        Element properties;
        Element creation;
        Element palette;
        Element presentation;
        String delete;
        String modelValue = element.getAttributeValue("model");
        Class<RadComponent> model = modelValue == null ? null : classLoader.loadClass(modelValue);
        String target = element.getAttributeValue("class");
        String tag = element.getAttributeValue(TAG);
        MetaModel meta = this.createModel(model, target, tag);
        String layout = element.getAttributeValue("layout");
        if (layout != null) {
            meta.setLayout(classLoader.loadClass(layout));
        }
        if ((delete = element.getAttributeValue("delete")) != null) {
            meta.setDelete(Boolean.parseBoolean(delete));
        }
        if ((presentation = element.getChild("presentation")) != null) {
            meta.setPresentation(presentation.getAttributeValue("title"), presentation.getAttributeValue("icon"));
        }
        if ((palette = element.getChild(PALETTE)) != null) {
            meta.setPaletteItem(this.createPaletteItem(palette));
        }
        if ((creation = element.getChild("creation")) != null) {
            meta.setCreation(creation.getTextTrim());
        }
        if ((properties = element.getChild("properties")) != null) {
            this.loadProperties(meta, properties);
        }
        if ((morphing = element.getChild("morphing")) != null) {
            modelToMorphing.put(meta, StringUtil.split((String)morphing.getAttribute("to").getValue(), (String)" "));
        }
        this.loadOther(meta, element);
        if (tag != null) {
            this.myTag2Model.put(tag, meta);
        }
        if (target != null) {
            this.myTarget2Model.put(target, meta);
        }
        MetaModel metaModel = meta;
        if (metaModel == null) {
            MetaManager.$$$reportNull$$$0(0);
        }
        return metaModel;
    }

    @NotNull
    protected MetaModel createModel(Class<RadComponent> model, String target, String tag) throws Exception {
        MetaModel metaModel = new MetaModel(model, target, tag);
        if (metaModel == null) {
            MetaManager.$$$reportNull$$$0(1);
        }
        return metaModel;
    }

    @NotNull
    protected DefaultPaletteItem createPaletteItem(Element palette) {
        DefaultPaletteItem defaultPaletteItem = new DefaultPaletteItem(palette);
        if (defaultPaletteItem == null) {
            MetaManager.$$$reportNull$$$0(2);
        }
        return defaultPaletteItem;
    }

    @NotNull
    protected VariationPaletteItem createVariationPaletteItem(PaletteItem paletteItem, MetaModel model, Element itemElement) {
        VariationPaletteItem variationPaletteItem = new VariationPaletteItem(paletteItem, model, itemElement);
        if (variationPaletteItem == null) {
            MetaManager.$$$reportNull$$$0(3);
        }
        return variationPaletteItem;
    }

    @NotNull
    protected PaletteGroup createPaletteGroup(String name2) {
        PaletteGroup paletteGroup = new PaletteGroup(name2);
        if (paletteGroup == null) {
            MetaManager.$$$reportNull$$$0(4);
        }
        return paletteGroup;
    }

    protected void loadProperties(MetaModel meta, Element properties) throws Exception {
        Attribute deprecated;
        Attribute expert;
        Attribute important;
        Attribute normal;
        Attribute top;
        Attribute inplace = properties.getAttribute("inplace");
        if (inplace != null) {
            meta.setInplaceProperties(StringUtil.split((String)inplace.getValue(), (String)" "));
        }
        if ((top = properties.getAttribute("top")) != null) {
            meta.setTopProperties(StringUtil.split((String)top.getValue(), (String)" "));
        }
        if ((normal = properties.getAttribute("normal")) != null) {
            meta.setNormalProperties(StringUtil.split((String)normal.getValue(), (String)" "));
        }
        if ((important = properties.getAttribute("important")) != null) {
            meta.setImportantProperties(StringUtil.split((String)important.getValue(), (String)" "));
        }
        if ((expert = properties.getAttribute("expert")) != null) {
            meta.setExpertProperties(StringUtil.split((String)expert.getValue(), (String)" "));
        }
        if ((deprecated = properties.getAttribute("deprecated")) != null) {
            meta.setDeprecatedProperties(StringUtil.split((String)deprecated.getValue(), (String)" "));
        }
    }

    protected void loadOther(MetaModel meta, Element element) throws Exception {
    }

    @NotNull
    protected PaletteGroup loadGroup(Element element) throws Exception {
        PaletteGroup group = this.createPaletteGroup(element.getAttributeValue(NAME));
        for (Element itemElement : element.getChildren(ITEM)) {
            MetaModel model = this.getModelByTag(itemElement.getAttributeValue(TAG));
            PaletteItem paletteItem = model.getPaletteItem();
            if (!itemElement.getChildren().isEmpty()) {
                if (itemElement.getAttribute("title") != null) {
                    paletteItem = this.createVariationPaletteItem(paletteItem, model, itemElement);
                }
                group.addItem(paletteItem);
                for (Element grandChild : itemElement.getChildren(ITEM)) {
                    group.addItem(this.createVariationPaletteItem(paletteItem, model, grandChild));
                }
                continue;
            }
            group.addItem(paletteItem);
        }
        this.myPaletteGroups.add(group);
        PaletteGroup paletteGroup = group;
        if (paletteGroup == null) {
            MetaManager.$$$reportNull$$$0(5);
        }
        return paletteGroup;
    }

    public <K, V> Map<K, V> getCache(Object key) {
        return (Map)this.myCache.get(key);
    }

    public void setCache(Object key, Object value) {
        this.myCache.put(key, value);
    }

    @Nullable
    public MetaModel getModelByTag(String tag) {
        return this.myTag2Model.get(tag);
    }

    @Nullable
    public MetaModel getModelByTarget(String target) {
        return this.myTarget2Model.get(target);
    }

    public List<MetaModel> getWrapInModels() {
        return this.myWrapModels;
    }

    public List<PaletteGroup> getPaletteGroups() {
        return this.myPaletteGroups;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/intellij/designer/model/MetaManager";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "loadModel";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "createModel";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createPaletteItem";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createVariationPaletteItem";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "createPaletteGroup";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "loadGroup";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }
}

