/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.projectWizard;

import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.popup.ListItemDescriptor;
import com.intellij.openapi.ui.popup.ListItemDescriptorAdapter;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.IconLoader;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.platform.ProjectTemplate;
import com.intellij.platform.templates.ArchivedProjectTemplate;
import com.intellij.ui.CollectionListModel;
import com.intellij.ui.components.JBList;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.ui.popup.list.GroupedItemsListRenderer;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.JBUI;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.Collections;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JTextPane;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.border.Border;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.jetbrains.annotations.Nullable;

public class ProjectTemplateList
extends JPanel {
    private static final String PROJECT_WIZARD_TEMPLATE = "project.wizard.template";
    private JBList<ProjectTemplate> myList;
    private JPanel myPanel;
    private JTextPane myDescriptionPane;

    public ProjectTemplateList() {
        super(new BorderLayout());
        this.$$$setupUI$$$();
        this.add((Component)this.myPanel, "Center");
        GroupedItemsListRenderer<ProjectTemplate> renderer = new GroupedItemsListRenderer<ProjectTemplate>((ListItemDescriptor)new ListItemDescriptorAdapter<ProjectTemplate>(){

            @Nullable
            public String getTextFor(ProjectTemplate value) {
                return value.getName();
            }

            @Nullable
            public Icon getIconFor(ProjectTemplate value) {
                return value.getIcon();
            }
        }){

            protected void customizeComponent(JList<? extends ProjectTemplate> list, ProjectTemplate value, boolean isSelected) {
                super.customizeComponent(list, (Object)value, isSelected);
                Icon icon = this.myTextLabel.getIcon();
                if (icon != null && this.myTextLabel.getDisabledIcon() == icon) {
                    this.myTextLabel.setDisabledIcon(IconLoader.getDisabledIcon((Icon)icon));
                }
                this.myTextLabel.setEnabled(ProjectTemplateList.this.myList.isEnabled());
                this.myTextLabel.setBorder((Border)JBUI.Borders.empty((int)3, (int)3, (int)3, (int)3));
            }
        };
        this.myList.setCellRenderer((ListCellRenderer)renderer);
        this.myList.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                ProjectTemplateList.this.updateSelection();
            }
        });
        Messages.installHyperlinkSupport((JTextPane)this.myDescriptionPane);
    }

    private void updateSelection() {
        String description;
        this.myDescriptionPane.setText("");
        ProjectTemplate template = this.getSelectedTemplate();
        if (template != null && StringUtil.isNotEmpty((String)(description = template.getDescription()))) {
            description = "<html><body><font " + (SystemInfo.isMac ? "" : "face=\"Verdana\" size=\"-1\"") + '>' + description + "</font></body></html>";
            this.myDescriptionPane.setText(description);
        }
    }

    public void setTemplates(List<ProjectTemplate> list, boolean preserveSelection) {
        Collections.sort(list, (o1, o2) -> Comparing.compare((boolean)(o1 instanceof ArchivedProjectTemplate), (boolean)(o2 instanceof ArchivedProjectTemplate)));
        int index = preserveSelection ? this.myList.getSelectedIndex() : -1;
        this.myList.setModel((ListModel)new CollectionListModel(list));
        if (this.myList.isEnabled()) {
            this.myList.setSelectedIndex(index == -1 ? 0 : index);
        }
        this.updateSelection();
    }

    @Nullable
    public ProjectTemplate getSelectedTemplate() {
        return (ProjectTemplate)this.myList.getSelectedValue();
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.myList.setEnabled(enabled);
        if (!enabled) {
            this.myList.clearSelection();
        } else {
            this.myList.setSelectedIndex(0);
        }
        this.myDescriptionPane.setEnabled(enabled);
    }

    void restoreSelection() {
        List list;
        ProjectTemplate template;
        String templateName = PropertiesComponent.getInstance().getValue(PROJECT_WIZARD_TEMPLATE);
        if (templateName != null && this.myList.getModel() instanceof CollectionListModel && (template = (ProjectTemplate)ContainerUtil.find((Iterable)(list = ((CollectionListModel)this.myList.getModel()).toList()), template1 -> templateName.equals(template1.getName()))) != null) {
            this.myList.setSelectedValue((Object)template, true);
        }
        this.myList.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                ProjectTemplate template = ProjectTemplateList.this.getSelectedTemplate();
                if (template != null) {
                    PropertiesComponent.getInstance().setValue(ProjectTemplateList.PROJECT_WIZARD_TEMPLATE, template.getName());
                }
            }
        });
    }

    public JBList getList() {
        return this.myList;
    }

    public void addListSelectionListener(ListSelectionListener listener) {
        this.myList.addListSelectionListener(listener);
    }

    public void setPaintBusy(boolean b) {
        this.myList.setPaintBusy(b);
    }

    public boolean setSelectedTemplate(String name2) {
        ListModel model1 = this.myList.getModel();
        for (int j = 0; j < model1.getSize(); ++j) {
            if (!name2.equals(((ProjectTemplate)model1.getElementAt(j)).getName())) continue;
            this.myList.setSelectedIndex(j);
            return true;
        }
        return false;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JTextPane jTextPane;
        JBList jBList;
        JPanel jPanel;
        this.myPanel = jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(0, 0));
        JBScrollPane jBScrollPane = new JBScrollPane();
        jPanel.add((Component)jBScrollPane, "Center");
        this.myList = jBList = new JBList();
        jBList.setSelectionMode(0);
        jBScrollPane.setViewportView((Component)jBList);
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel.add((Component)jPanel2, "South");
        JBScrollPane jBScrollPane2 = new JBScrollPane();
        jPanel2.add((Component)jBScrollPane2, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 0, null, new Dimension(500, 100), null));
        this.myDescriptionPane = jTextPane = new JTextPane();
        jBScrollPane2.setViewportView(jTextPane);
        Spacer spacer = new Spacer();
        jPanel2.add((Component)spacer, new GridConstraints(0, 0, 1, 1, 1, 0, 1, 0, null, new Dimension(-1, 3), null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }
}

