/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.util.newProjectWizard;

import com.intellij.ide.util.newProjectWizard.AbstractProjectWizard;
import com.intellij.ide.util.newProjectWizard.StepSequence;
import com.intellij.ide.util.newProjectWizard.modes.ImportMode;
import com.intellij.ide.util.newProjectWizard.modes.WizardMode;
import com.intellij.ide.util.projectWizard.ModuleWizardStep;
import com.intellij.ide.util.projectWizard.ProjectBuilder;
import com.intellij.ide.util.projectWizard.WizardContext;
import com.intellij.ide.wizard.Step;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.ProjectJdkTable;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkTypeId;
import com.intellij.openapi.roots.ui.configuration.DefaultModulesProvider;
import com.intellij.openapi.roots.ui.configuration.ModulesProvider;
import com.intellij.projectImport.ProjectImportBuilder;
import com.intellij.projectImport.ProjectImportProvider;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import java.awt.Component;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AddModuleWizard
extends AbstractProjectWizard {
    private final List<ProjectImportProvider> myImportProviders;
    private final ModulesProvider myModulesProvider;
    private WizardMode myWizardMode;

    public AddModuleWizard(@Nullable Project project2, String filePath, ProjectImportProvider ... importProviders) {
        super(AddModuleWizard.getImportWizardTitle(project2, importProviders), project2, filePath);
        this.myImportProviders = Arrays.asList(importProviders);
        this.myModulesProvider = DefaultModulesProvider.createForProject((Project)project2);
        this.initModuleWizard(project2, filePath);
    }

    public AddModuleWizard(Project project2, Component dialogParent, String filePath, ProjectImportProvider ... importProviders) {
        super(AddModuleWizard.getImportWizardTitle(project2, importProviders), project2, dialogParent);
        this.myImportProviders = Arrays.asList(importProviders);
        this.myModulesProvider = DefaultModulesProvider.createForProject((Project)project2);
        this.initModuleWizard(project2, filePath);
    }

    private static String getImportWizardTitle(Project project2, ProjectImportProvider ... providers) {
        StringBuilder builder = new StringBuilder("Import ");
        builder.append(project2 == null ? "Project" : "Module");
        if (providers.length == 1) {
            builder.append(" from ").append(providers[0].getName());
        }
        return builder.toString();
    }

    private void initModuleWizard(@Nullable Project project2, @Nullable String defaultPath) {
        this.myWizardContext.addContextListener(new WizardContext.Listener(){

            public void buttonsUpdateRequested() {
                AddModuleWizard.this.updateButtons();
            }

            public void nextStepRequested() {
                AddModuleWizard.this.doNextAction();
            }
        });
        this.myWizardMode = new ImportMode(this.myImportProviders);
        StepSequence sequence = this.myWizardMode.getSteps(this.myWizardContext, DefaultModulesProvider.createForProject((Project)project2));
        this.appendSteps(sequence);
        for (ProjectImportProvider provider : this.myImportProviders) {
            provider.getBuilder().setFileToImport(defaultPath);
        }
        if (this.myImportProviders.size() == 1) {
            ProjectImportBuilder builder = this.myImportProviders.get(0).getBuilder();
            this.myWizardContext.setProjectBuilder((ProjectBuilder)builder);
            builder.setUpdate(this.getWizardContext().getProject() != null);
        }
        this.init();
    }

    private void appendSteps(@Nullable StepSequence sequence) {
        if (sequence != null) {
            for (ModuleWizardStep step : sequence.getAllSteps()) {
                this.addStep((Step)step);
            }
        }
    }

    @Override
    public StepSequence getSequence() {
        return this.myWizardMode.getSteps(this.myWizardContext, this.myModulesProvider);
    }

    @Nullable
    public static Sdk getMostRecentSuitableSdk(WizardContext context) {
        if (context.getProject() == null) {
            Map sdksByType;
            Map.Entry pair2;
            List sdks = Arrays.asList(ProjectJdkTable.getInstance().getAllJdks());
            ProjectBuilder builder = context.getProjectBuilder();
            if (builder != null) {
                sdks = ContainerUtil.filter(sdks, sdk -> builder.isSuitableSdkType(sdk.getSdkType()));
            }
            if ((pair2 = (Map.Entry)ContainerUtil.getFirstItem((sdksByType = sdks.stream().collect(Collectors.groupingBy(Sdk::getSdkType, Collectors.mapping(java.util.function.Function.identity(), Collectors.toList())))).entrySet())) != null) {
                return ((List)pair2.getValue()).stream().max(((SdkTypeId)pair2.getKey()).versionComparator()).orElse(null);
            }
        }
        return null;
    }

    @NotNull
    public WizardContext getWizardContext() {
        WizardContext wizardContext = this.myWizardContext;
        if (wizardContext == null) {
            AddModuleWizard.$$$reportNull$$$0(0);
        }
        return wizardContext;
    }

    protected String getDimensionServiceKey() {
        return "NewModule_or_Project.wizard";
    }

    public boolean navigateToStep(@NotNull Function<Step, Boolean> filter) {
        if (filter == null) {
            AddModuleWizard.$$$reportNull$$$0(1);
        }
        int myStepsSize = this.mySteps.size();
        for (int i = 0; i < myStepsSize; ++i) {
            ModuleWizardStep step = (ModuleWizardStep)this.mySteps.get(i);
            if (filter.fun((Object)step) != Boolean.TRUE) continue;
            this.myCurrentStep = i;
            this.updateStep();
            return true;
        }
        return false;
    }

    public void commit() {
        this.commitStepData((ModuleWizardStep)this.getCurrentStepObject());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/util/newProjectWizard/AddModuleWizard";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filter";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getWizardContext";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/util/newProjectWizard/AddModuleWizard";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "navigateToStep";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

