/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.action;

import com.intellij.execution.RunManager;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.externalSystem.action.ExternalSystemAction;
import com.intellij.openapi.externalSystem.model.ExternalSystemDataKeys;
import com.intellij.openapi.externalSystem.statistics.ExternalSystemActionsCollector;
import com.intellij.openapi.externalSystem.view.RunConfigurationNode;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public class RemoveExternalSystemRunConfigurationAction
extends ExternalSystemAction {
    @Override
    protected boolean isEnabled(@NotNull AnActionEvent e) {
        if (e == null) {
            RemoveExternalSystemRunConfigurationAction.$$$reportNull$$$0(0);
        }
        if (!super.isEnabled(e)) {
            return false;
        }
        List selectedNodes = (List)ExternalSystemDataKeys.SELECTED_NODES.getData(e.getDataContext());
        if (selectedNodes == null || selectedNodes.size() != 1) {
            return false;
        }
        return selectedNodes.get(0) instanceof RunConfigurationNode;
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        if (e == null) {
            RemoveExternalSystemRunConfigurationAction.$$$reportNull$$$0(1);
        }
        Project project2 = this.getProject(e);
        assert (project2 != null);
        List selectedNodes = (List)ExternalSystemDataKeys.SELECTED_NODES.getData(e.getDataContext());
        if (selectedNodes == null || selectedNodes.size() != 1 || !(selectedNodes.get(0) instanceof RunConfigurationNode)) {
            return;
        }
        RunnerAndConfigurationSettings settings = ((RunConfigurationNode)selectedNodes.get(0)).getSettings();
        assert (settings != null);
        ExternalSystemActionsCollector.trigger(project2, this.getSystemId(e), this, e, new String[0]);
        int res = Messages.showYesNoDialog((Project)project2, (String)("Delete \"" + settings.getName() + "\"?"), (String)"Confirmation", (Icon)Messages.getQuestionIcon());
        if (res == 0) {
            RunManager.getInstance((Project)project2).removeConfiguration(settings);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "e";
        objectArray2[1] = "com/intellij/openapi/externalSystem/action/RemoveExternalSystemRunConfigurationAction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "isEnabled";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "actionPerformed";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

