/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.service.project.manage;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.externalSystem.ExternalSystemManager;
import com.intellij.openapi.externalSystem.ExternalSystemModulePropertyManager;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.service.project.manage.ExternalProjectsManagerImpl;
import com.intellij.openapi.externalSystem.settings.AbstractExternalSystemSettings;
import com.intellij.openapi.externalSystem.settings.ExternalProjectSettings;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ui.configuration.ModulesConfigurator;
import com.intellij.openapi.roots.ui.configuration.ProjectStructureConfigurable;
import com.intellij.openapi.roots.ui.configuration.projectRoot.ModuleStructureExtension;
import com.intellij.openapi.roots.ui.configuration.projectRoot.StructureConfigurableContext;
import com.intellij.openapi.ui.MasterDetailsComponent;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ExternalModuleStructureExtension
extends ModuleStructureExtension {
    private static final Logger LOG = Logger.getInstance(ExternalModuleStructureExtension.class);
    @Nullable
    private Project myProject;
    private boolean isExternalSystemsInvolved;
    @Nullable
    private Map<String, Pair<ProjectSystemId, ExternalProjectSettings>> myExternalProjectsToRestore;
    @Nullable
    private Map<String, ProjectSystemId> myOrphanProjectsCandidates;

    @Override
    public void reset(Project project2) {
        if (project2 == null) {
            return;
        }
        this.myProject = project2;
        this.isExternalSystemsInvolved = false;
        this.myExternalProjectsToRestore = ExternalModuleStructureExtension.getLinkedProjects(project2);
        this.myOrphanProjectsCandidates = new HashMap<String, ProjectSystemId>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void disposeUIResources() {
        try {
            if (this.isExternalSystemsInvolved) {
                ModulesConfigurator modulesConfigurator;
                String rootProjectPath;
                assert (this.myOrphanProjectsCandidates != null);
                assert (this.myProject != null);
                if (this.myExternalProjectsToRestore != null) {
                    for (Pair<ProjectSystemId, ExternalProjectSettings> settingsPair : this.myExternalProjectsToRestore.values()) {
                        AbstractExternalSystemSettings settings = ExternalSystemApiUtil.getSettings((Project)this.myProject, (ProjectSystemId)((ProjectSystemId)settingsPair.first));
                        if (settings.getLinkedProjectSettings(rootProjectPath = ((ExternalProjectSettings)settingsPair.second).getExternalProjectPath()) == null) {
                            settings.linkProject((ExternalProjectSettings)settingsPair.second);
                        }
                        this.myOrphanProjectsCandidates.remove(rootProjectPath);
                    }
                }
                if ((modulesConfigurator = ExternalModuleStructureExtension.getModulesConfigurator(this.myProject)) != null) {
                    for (Map.Entry<String, ProjectSystemId> entry : this.myOrphanProjectsCandidates.entrySet()) {
                        rootProjectPath = entry.getKey();
                        if (!StringUtil.isNotEmpty((String)rootProjectPath)) continue;
                        ExternalModuleStructureExtension.unlinkProject(this.myProject, entry.getValue(), rootProjectPath);
                    }
                }
            }
        }
        catch (Throwable e) {
            LOG.warn(e);
        }
        finally {
            this.myProject = null;
            this.myExternalProjectsToRestore = null;
            this.myOrphanProjectsCandidates = null;
        }
    }

    @Override
    public boolean addModuleNodeChildren(Module module2, MasterDetailsComponent.MyNode moduleNode, Runnable treeNodeNameUpdater) {
        String systemIdString = ExternalSystemModulePropertyManager.getInstance((Module)module2).getExternalSystemId();
        if (StringUtil.isNotEmpty((String)systemIdString)) {
            this.isExternalSystemsInvolved = true;
            String rootProjectPath = ExternalSystemApiUtil.getExternalRootProjectPath((Module)module2);
            if (this.myOrphanProjectsCandidates != null && StringUtil.isNotEmpty((String)rootProjectPath)) {
                this.myOrphanProjectsCandidates.put(rootProjectPath, new ProjectSystemId(systemIdString));
            }
        }
        return false;
    }

    @Override
    public void moduleRemoved(Module module2) {
        String systemIdString = ExternalSystemModulePropertyManager.getInstance((Module)module2).getExternalSystemId();
        if (StringUtil.isEmpty((String)systemIdString)) {
            return;
        }
        String rootProjectPath = ExternalSystemApiUtil.getExternalRootProjectPath((Module)module2);
        if (StringUtil.isEmpty((String)rootProjectPath)) {
            return;
        }
        Project project2 = module2.getProject();
        ModulesConfigurator modulesConfigurator = ExternalModuleStructureExtension.getModulesConfigurator(project2);
        if (modulesConfigurator == null) {
            return;
        }
        for (Module m : modulesConfigurator.getModules()) {
            if (m == module2 || !rootProjectPath.equals(ExternalSystemApiUtil.getExternalRootProjectPath((Module)m))) continue;
            return;
        }
        ProjectSystemId systemId = new ProjectSystemId(systemIdString);
        ExternalSystemApiUtil.getSettings((Project)project2, (ProjectSystemId)systemId).unlinkExternalProject(rootProjectPath);
        assert (this.myOrphanProjectsCandidates != null);
        this.myOrphanProjectsCandidates.put(rootProjectPath, systemId);
        this.isExternalSystemsInvolved = true;
    }

    @Override
    public void afterModelCommit() {
        if (this.myProject == null) {
            return;
        }
        this.myExternalProjectsToRestore = ExternalModuleStructureExtension.getLinkedProjects(this.myProject);
    }

    @Nullable
    private static ModulesConfigurator getModulesConfigurator(Project project2) {
        if (ApplicationManager.getApplication().isHeadlessEnvironment()) {
            return null;
        }
        ProjectStructureConfigurable structureConfigurable = ProjectStructureConfigurable.getInstance(project2);
        StructureConfigurableContext context = structureConfigurable.isUiInitialized() ? structureConfigurable.getContext() : null;
        return context != null ? context.getModulesConfigurator() : null;
    }

    private static Map<String, Pair<ProjectSystemId, ExternalProjectSettings>> getLinkedProjects(Project project2) {
        HashMap<String, Pair<ProjectSystemId, ExternalProjectSettings>> result = new HashMap<String, Pair<ProjectSystemId, ExternalProjectSettings>>();
        for (ExternalSystemManager manager : ExternalSystemApiUtil.getAllManagers()) {
            ProjectSystemId systemId = manager.getSystemId();
            AbstractExternalSystemSettings systemSettings = ExternalSystemApiUtil.getSettings((Project)project2, (ProjectSystemId)systemId);
            Collection projectsSettings = systemSettings.getLinkedProjectsSettings();
            for (Object settings : projectsSettings) {
                if (!(settings instanceof ExternalProjectSettings)) continue;
                ExternalProjectSettings projectSettings = (ExternalProjectSettings)settings;
                result.put(projectSettings.getExternalProjectPath(), (Pair<ProjectSystemId, ExternalProjectSettings>)Pair.create((Object)systemId, (Object)projectSettings));
            }
        }
        return result;
    }

    private static void unlinkProject(@NotNull Project project2, ProjectSystemId systemId, String rootProjectPath) {
        if (project2 == null) {
            ExternalModuleStructureExtension.$$$reportNull$$$0(0);
        }
        ExternalSystemApiUtil.getLocalSettings((Project)project2, (ProjectSystemId)systemId).forgetExternalProjects(Collections.singleton(rootProjectPath));
        ExternalSystemApiUtil.getSettings((Project)project2, (ProjectSystemId)systemId).unlinkExternalProject(rootProjectPath);
        ExternalProjectsManagerImpl.getInstance(project2).forgetExternalProjectData(systemId, rootProjectPath);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/externalSystem/service/project/manage/ExternalModuleStructureExtension", "unlinkProject"));
    }
}

