/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.ui.configuration.projectRoot;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.impl.libraries.LibraryEx;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.ui.configuration.LibraryTableModifiableModelProvider;
import com.intellij.openapi.roots.ui.configuration.ProjectStructureConfigurable;
import com.intellij.openapi.roots.ui.configuration.classpath.ChangeLibraryLevelActionBase;
import com.intellij.openapi.roots.ui.configuration.projectRoot.BaseLibrariesConfigurable;
import com.intellij.openapi.roots.ui.configuration.projectRoot.GlobalLibrariesConfigurable;
import com.intellij.openapi.roots.ui.configuration.projectRoot.StructureConfigurableContext;
import com.intellij.openapi.roots.ui.configuration.projectRoot.daemon.LibraryProjectStructureElement;
import com.intellij.openapi.roots.ui.configuration.projectRoot.daemon.ProjectStructureElement;
import com.intellij.openapi.roots.ui.configuration.projectRoot.daemon.ProjectStructureElementUsage;
import java.util.Collection;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;

public class ChangeLibraryLevelAction
extends ChangeLibraryLevelActionBase {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.roots.ui.configuration.projectRoot.ChangeLibraryLevelAction");
    private final JComponent myParentComponent;
    private final BaseLibrariesConfigurable mySourceConfigurable;
    private final BaseLibrariesConfigurable myTargetConfigurable;

    public ChangeLibraryLevelAction(@NotNull Project project2, @NotNull JComponent parentComponent, @NotNull BaseLibrariesConfigurable sourceConfigurable, @NotNull BaseLibrariesConfigurable targetConfigurable) {
        if (project2 == null) {
            ChangeLibraryLevelAction.$$$reportNull$$$0(0);
        }
        if (parentComponent == null) {
            ChangeLibraryLevelAction.$$$reportNull$$$0(1);
        }
        if (sourceConfigurable == null) {
            ChangeLibraryLevelAction.$$$reportNull$$$0(2);
        }
        if (targetConfigurable == null) {
            ChangeLibraryLevelAction.$$$reportNull$$$0(3);
        }
        super(project2, targetConfigurable.getLibraryTablePresentation().getDisplayName(true), targetConfigurable.getLevel(), sourceConfigurable instanceof GlobalLibrariesConfigurable);
        this.myParentComponent = parentComponent;
        this.mySourceConfigurable = sourceConfigurable;
        this.myTargetConfigurable = targetConfigurable;
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        ProjectStructureElement selectedElement;
        if (e == null) {
            ChangeLibraryLevelAction.$$$reportNull$$$0(4);
        }
        if (!((selectedElement = this.mySourceConfigurable.getSelectedElement()) instanceof LibraryProjectStructureElement)) {
            return;
        }
        StructureConfigurableContext context = this.mySourceConfigurable.myContext;
        LibraryProjectStructureElement libraryElement = (LibraryProjectStructureElement)selectedElement;
        LibraryEx oldLibrary = (LibraryEx)context.getLibrary(libraryElement.getLibrary().getName(), this.mySourceConfigurable.getLevel());
        LOG.assertTrue(oldLibrary != null);
        Library newLibrary = this.doCopy(oldLibrary);
        if (newLibrary == null) {
            return;
        }
        Collection<ProjectStructureElementUsage> usages = context.getDaemonAnalyzer().getUsages(libraryElement);
        for (ProjectStructureElementUsage usage : usages) {
            usage.replaceElement(new LibraryProjectStructureElement(context, newLibrary));
        }
        if (!this.myCopy) {
            this.mySourceConfigurable.removeLibrary(libraryElement);
        }
        ProjectStructureConfigurable.getInstance(this.myProject).selectProjectOrGlobalLibrary(newLibrary, true);
    }

    @Override
    protected boolean isEnabled() {
        return this.mySourceConfigurable.getSelectedElement() instanceof LibraryProjectStructureElement;
    }

    @Override
    protected LibraryTableModifiableModelProvider getModifiableTableModelProvider() {
        return this.myTargetConfigurable.getModelProvider();
    }

    @Override
    protected JComponent getParentComponent() {
        return this.myParentComponent;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentComponent";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourceConfigurable";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetConfigurable";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
        }
        objectArray2[1] = "com/intellij/openapi/roots/ui/configuration/projectRoot/ChangeLibraryLevelAction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "actionPerformed";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

