/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.ui.configuration.projectRoot;

import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectBundle;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkModel;
import com.intellij.openapi.projectRoots.SimpleJavaSdkType;
import com.intellij.openapi.projectRoots.impl.ProjectJdkImpl;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.roots.ui.configuration.ProjectStructureConfigurable;
import com.intellij.openapi.roots.ui.configuration.projectRoot.BaseStructureConfigurable;
import com.intellij.openapi.roots.ui.configuration.projectRoot.JdkConfigurable;
import com.intellij.openapi.roots.ui.configuration.projectRoot.ProjectSdksModel;
import com.intellij.openapi.roots.ui.configuration.projectRoot.RemoveConfigurableHandler;
import com.intellij.openapi.roots.ui.configuration.projectRoot.daemon.ProjectStructureElement;
import com.intellij.openapi.roots.ui.configuration.projectRoot.daemon.SdkProjectStructureElement;
import com.intellij.openapi.ui.MasterDetailsComponent;
import com.intellij.openapi.ui.NamedConfigurable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JdkListConfigurable
extends BaseStructureConfigurable {
    @NotNull
    private final ProjectSdksModel myJdksTreeModel;
    private final SdkModel.Listener myListener = new SdkModel.Listener(){

        public void sdkChanged(@NotNull Sdk sdk, String previousName) {
            if (sdk == null) {
                1.$$$reportNull$$$0(0);
            }
            this.updateName();
        }

        public void sdkHomeSelected(@NotNull Sdk sdk, @NotNull String newSdkHome) {
            if (sdk == null) {
                1.$$$reportNull$$$0(1);
            }
            if (newSdkHome == null) {
                1.$$$reportNull$$$0(2);
            }
            this.updateName();
        }

        private void updateName() {
            NamedConfigurable configurable;
            TreePath path = JdkListConfigurable.this.myTree.getSelectionPath();
            if (path != null && (configurable = ((MasterDetailsComponent.MyNode)path.getLastPathComponent()).getConfigurable()) instanceof JdkConfigurable) {
                configurable.updateName();
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "sdk";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "newSdkHome";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/openapi/roots/ui/configuration/projectRoot/JdkListConfigurable$1";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "sdkChanged";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "sdkHomeSelected";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    };

    public JdkListConfigurable(Project project2, ProjectStructureConfigurable root) {
        super(project2);
        this.myJdksTreeModel = root.getProjectJdksModel();
        this.myJdksTreeModel.addListener(this.myListener);
    }

    protected String getComponentStateKey() {
        return "JdkListConfigurable.UI";
    }

    @Nls
    public String getDisplayName() {
        return "SDKs";
    }

    @Nullable
    @NonNls
    public String getHelpTopic() {
        return this.myCurrentConfigurable != null ? this.myCurrentConfigurable.getHelpTopic() : "reference.settingsdialog.project.structure.jdk";
    }

    @NotNull
    @NonNls
    public String getId() {
        if ("jdk.list" == null) {
            JdkListConfigurable.$$$reportNull$$$0(0);
        }
        return "jdk.list";
    }

    @Override
    protected void loadTree() {
        HashMap sdks = this.myJdksTreeModel.getProjectSdks();
        for (Sdk sdk : sdks.keySet()) {
            JdkConfigurable configurable = new JdkConfigurable((ProjectJdkImpl)sdks.get(sdk), this.myJdksTreeModel, this.TREE_UPDATER, this.myHistory, this.myProject);
            this.addNode(new MasterDetailsComponent.MyNode((NamedConfigurable)configurable), this.myRoot);
        }
    }

    @Override
    @NotNull
    protected Collection<? extends ProjectStructureElement> getProjectStructureElements() {
        ArrayList<SdkProjectStructureElement> result = new ArrayList<SdkProjectStructureElement>();
        for (Sdk sdk : this.myJdksTreeModel.getProjectSdks().values()) {
            result.add(new SdkProjectStructureElement(this.myContext, sdk));
        }
        ArrayList<SdkProjectStructureElement> arrayList = result;
        if (arrayList == null) {
            JdkListConfigurable.$$$reportNull$$$0(1);
        }
        return arrayList;
    }

    public boolean addJdkNode(Sdk jdk, boolean selectInTree) {
        if (!this.myUiDisposed) {
            this.myContext.getDaemonAnalyzer().queueUpdate(new SdkProjectStructureElement(this.myContext, jdk));
            this.addNode(new MasterDetailsComponent.MyNode((NamedConfigurable)new JdkConfigurable((ProjectJdkImpl)jdk, this.myJdksTreeModel, this.TREE_UPDATER, this.myHistory, this.myProject)), this.myRoot);
            if (selectInTree) {
                this.selectNodeInTree((DefaultMutableTreeNode)MasterDetailsComponent.findNodeByObject((TreeNode)this.myRoot, (Object)jdk));
            }
            return true;
        }
        return false;
    }

    public void dispose() {
        this.myJdksTreeModel.removeListener(this.myListener);
        this.myJdksTreeModel.disposeUIResources();
    }

    @NotNull
    public ProjectSdksModel getJdksTreeModel() {
        ProjectSdksModel projectSdksModel = this.myJdksTreeModel;
        if (projectSdksModel == null) {
            JdkListConfigurable.$$$reportNull$$$0(2);
        }
        return projectSdksModel;
    }

    @Override
    public void reset() {
        super.reset();
        this.myTree.setRootVisible(false);
    }

    public void apply() throws ConfigurationException {
        boolean modifiedJdks = false;
        for (int i = 0; i < this.myRoot.getChildCount(); ++i) {
            NamedConfigurable configurable = ((MasterDetailsComponent.MyNode)this.myRoot.getChildAt(i)).getConfigurable();
            if (!configurable.isModified()) continue;
            configurable.apply();
            modifiedJdks = true;
        }
        if (this.myJdksTreeModel.isModified() || modifiedJdks) {
            this.myJdksTreeModel.apply((MasterDetailsComponent)this);
        }
        this.myJdksTreeModel.setProjectSdk(ProjectRootManager.getInstance((Project)this.myProject).getProjectSdk());
    }

    public boolean isModified() {
        return super.isModified() || this.myJdksTreeModel.isModified();
    }

    public static JdkListConfigurable getInstance(Project project2) {
        return (JdkListConfigurable)((Object)ServiceManager.getService((Project)project2, JdkListConfigurable.class));
    }

    @Override
    public BaseStructureConfigurable.AbstractAddGroup createAddAction() {
        return new BaseStructureConfigurable.AbstractAddGroup(ProjectBundle.message((String)"add.new.jdk.text", (Object[])new Object[0])){

            @NotNull
            public AnAction[] getChildren(@Nullable AnActionEvent e) {
                DefaultActionGroup group = new DefaultActionGroup(ProjectBundle.message((String)"add.new.jdk.text", (Object[])new Object[0]), true);
                JdkListConfigurable.this.myJdksTreeModel.createAddActions(group, (JComponent)JdkListConfigurable.this.myTree, projectJdk -> JdkListConfigurable.this.addJdkNode((Sdk)projectJdk, true), SimpleJavaSdkType.notSimpleJavaSdkType());
                AnAction[] anActionArray = group.getChildren(null);
                if (anActionArray == null) {
                    2.$$$reportNull$$$0(0);
                }
                return anActionArray;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/roots/ui/configuration/projectRoot/JdkListConfigurable$2", "getChildren"));
            }
        };
    }

    @Override
    protected List<? extends RemoveConfigurableHandler<?>> getRemoveHandlers() {
        return Collections.singletonList(new SdkRemoveHandler());
    }

    @Nullable
    protected String getEmptySelectionString() {
        return "Select an SDK to view or edit its details here";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/intellij/openapi/roots/ui/configuration/projectRoot/JdkListConfigurable";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getId";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getProjectStructureElements";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getJdksTreeModel";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private class SdkRemoveHandler
    extends RemoveConfigurableHandler<Sdk> {
        SdkRemoveHandler() {
            super(JdkConfigurable.class);
        }

        @Override
        public boolean remove(@NotNull Collection<? extends Sdk> sdks) {
            if (sdks == null) {
                SdkRemoveHandler.$$$reportNull$$$0(0);
            }
            for (Sdk sdk : sdks) {
                JdkListConfigurable.this.myJdksTreeModel.removeSdk(sdk);
                JdkListConfigurable.this.myContext.getDaemonAnalyzer().removeElement(new SdkProjectStructureElement(JdkListConfigurable.this.myContext, sdk));
            }
            return true;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sdks", "com/intellij/openapi/roots/ui/configuration/projectRoot/JdkListConfigurable$SdkRemoveHandler", "remove"));
        }
    }
}

