/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.packaging.impl.artifacts;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectModelExternalSource;
import com.intellij.packaging.artifacts.Artifact;
import com.intellij.packaging.artifacts.ArtifactAdapter;
import com.intellij.packaging.artifacts.ArtifactListener;
import com.intellij.packaging.artifacts.ArtifactPointerManager;
import com.intellij.packaging.artifacts.ArtifactType;
import com.intellij.packaging.artifacts.ModifiableArtifact;
import com.intellij.packaging.artifacts.ModifiableArtifactModel;
import com.intellij.packaging.elements.CompositePackagingElement;
import com.intellij.packaging.impl.artifacts.ArtifactImpl;
import com.intellij.packaging.impl.artifacts.ArtifactManagerImpl;
import com.intellij.packaging.impl.artifacts.ArtifactModelBase;
import com.intellij.packaging.impl.artifacts.ArtifactPointerManagerImpl;
import com.intellij.packaging.impl.artifacts.ArtifactUtil;
import com.intellij.util.EventDispatcher;
import java.util.ArrayList;
import java.util.EventListener;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ArtifactModelImpl
extends ArtifactModelBase
implements ModifiableArtifactModel {
    private final List<ArtifactImpl> myOriginalArtifacts;
    private final ArtifactManagerImpl myArtifactManager;
    private final Map<ArtifactImpl, ArtifactImpl> myArtifact2ModifiableCopy = new HashMap<ArtifactImpl, ArtifactImpl>();
    private final Map<ArtifactImpl, ArtifactImpl> myModifiable2Original = new HashMap<ArtifactImpl, ArtifactImpl>();
    private final EventDispatcher<ArtifactListener> myDispatcher = EventDispatcher.create(ArtifactListener.class);

    public ArtifactModelImpl(ArtifactManagerImpl artifactManager, List<? extends ArtifactImpl> originalArtifacts) {
        this.myArtifactManager = artifactManager;
        this.myOriginalArtifacts = new ArrayList<ArtifactImpl>(originalArtifacts);
        this.addListener((ArtifactListener)new ArtifactAdapter(){

            public void artifactChanged(@NotNull Artifact artifact, @NotNull String oldName) {
                if (artifact == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (oldName == null) {
                    1.$$$reportNull$$$0(1);
                }
                ArtifactModelImpl.this.artifactsChanged();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "artifact";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "oldName";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/packaging/impl/artifacts/ArtifactModelImpl$1";
                objectArray[2] = "artifactChanged";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
    }

    @Override
    protected List<? extends Artifact> getArtifactsList() {
        ArrayList<ArtifactImpl> list = new ArrayList<ArtifactImpl>();
        for (ArtifactImpl artifact : this.myOriginalArtifacts) {
            ArtifactImpl copy = this.myArtifact2ModifiableCopy.get((Object)artifact);
            if (copy != null) {
                list.add(copy);
                continue;
            }
            list.add(artifact);
        }
        return list;
    }

    @NotNull
    public ModifiableArtifact addArtifact(@NotNull String name2, @NotNull ArtifactType artifactType) {
        if (name2 == null) {
            ArtifactModelImpl.$$$reportNull$$$0(0);
        }
        if (artifactType == null) {
            ArtifactModelImpl.$$$reportNull$$$0(1);
        }
        ModifiableArtifact modifiableArtifact = this.addArtifact(name2, artifactType, artifactType.createRootElement(name2));
        if (modifiableArtifact == null) {
            ArtifactModelImpl.$$$reportNull$$$0(2);
        }
        return modifiableArtifact;
    }

    @NotNull
    public ModifiableArtifact addArtifact(@NotNull String name2, @NotNull ArtifactType artifactType, CompositePackagingElement<?> rootElement) {
        if (name2 == null) {
            ArtifactModelImpl.$$$reportNull$$$0(3);
        }
        if (artifactType == null) {
            ArtifactModelImpl.$$$reportNull$$$0(4);
        }
        ModifiableArtifact modifiableArtifact = this.addArtifact(name2, artifactType, rootElement, null);
        if (modifiableArtifact == null) {
            ArtifactModelImpl.$$$reportNull$$$0(5);
        }
        return modifiableArtifact;
    }

    @NotNull
    public ModifiableArtifact addArtifact(@NotNull String name2, @NotNull ArtifactType artifactType, CompositePackagingElement<?> rootElement, @Nullable ProjectModelExternalSource externalSource) {
        if (name2 == null) {
            ArtifactModelImpl.$$$reportNull$$$0(6);
        }
        if (artifactType == null) {
            ArtifactModelImpl.$$$reportNull$$$0(7);
        }
        String uniqueName = this.generateUniqueName(name2);
        String outputPath = ArtifactUtil.getDefaultArtifactOutputPath(uniqueName, this.myArtifactManager.getProject());
        ArtifactImpl artifact = new ArtifactImpl(uniqueName, artifactType, false, rootElement, outputPath, externalSource, this.myDispatcher);
        this.myOriginalArtifacts.add(artifact);
        this.myArtifact2ModifiableCopy.put(artifact, artifact);
        this.myModifiable2Original.put(artifact, artifact);
        this.artifactsChanged();
        ((ArtifactListener)this.myDispatcher.getMulticaster()).artifactAdded((Artifact)artifact);
        ArtifactImpl artifactImpl = artifact;
        if (artifactImpl == null) {
            ArtifactModelImpl.$$$reportNull$$$0(8);
        }
        return artifactImpl;
    }

    private String generateUniqueName(String baseName) {
        String name2 = baseName;
        int i = 2;
        while (this.findArtifact(name2) != null) {
            name2 = baseName + i++;
        }
        return name2;
    }

    public void addListener(@NotNull ArtifactListener listener) {
        if (listener == null) {
            ArtifactModelImpl.$$$reportNull$$$0(9);
        }
        this.myDispatcher.addListener((EventListener)listener);
    }

    public void removeListener(@NotNull ArtifactListener listener) {
        if (listener == null) {
            ArtifactModelImpl.$$$reportNull$$$0(10);
        }
        this.myDispatcher.addListener((EventListener)listener);
    }

    public void removeArtifact(@NotNull Artifact artifact) {
        ArtifactImpl artifactImpl;
        ArtifactImpl original;
        if (artifact == null) {
            ArtifactModelImpl.$$$reportNull$$$0(11);
        }
        if ((original = this.myModifiable2Original.remove((Object)(artifactImpl = (ArtifactImpl)artifact))) != null) {
            this.myOriginalArtifacts.remove((Object)original);
        } else {
            original = artifactImpl;
        }
        this.myArtifact2ModifiableCopy.remove((Object)original);
        this.myOriginalArtifacts.remove((Object)original);
        this.artifactsChanged();
        ((ArtifactListener)this.myDispatcher.getMulticaster()).artifactRemoved((Artifact)original);
    }

    @NotNull
    public ModifiableArtifact getOrCreateModifiableArtifact(@NotNull Artifact artifact) {
        ArtifactImpl artifactImpl;
        if (artifact == null) {
            ArtifactModelImpl.$$$reportNull$$$0(12);
        }
        if (this.myModifiable2Original.containsKey((Object)(artifactImpl = (ArtifactImpl)artifact))) {
            ArtifactImpl artifactImpl2 = artifactImpl;
            if (artifactImpl2 == null) {
                ArtifactModelImpl.$$$reportNull$$$0(13);
            }
            return artifactImpl2;
        }
        ArtifactImpl modifiableCopy = this.myArtifact2ModifiableCopy.get((Object)artifactImpl);
        if (modifiableCopy == null) {
            modifiableCopy = artifactImpl.createCopy(this.myDispatcher);
            ((ArtifactListener)this.myDispatcher.getMulticaster()).artifactChanged((Artifact)modifiableCopy, artifact.getName());
            this.myArtifact2ModifiableCopy.put(artifactImpl, modifiableCopy);
            this.myModifiable2Original.put(modifiableCopy, artifactImpl);
            this.artifactsChanged();
        }
        ArtifactImpl artifactImpl3 = modifiableCopy;
        if (artifactImpl3 == null) {
            ArtifactModelImpl.$$$reportNull$$$0(14);
        }
        return artifactImpl3;
    }

    @Override
    @NotNull
    public Artifact getOriginalArtifact(@NotNull Artifact artifact) {
        ArtifactImpl original;
        if (artifact == null) {
            ArtifactModelImpl.$$$reportNull$$$0(15);
        }
        ArtifactImpl artifactImpl = (original = this.myModifiable2Original.get(artifact)) != null ? original : artifact;
        if (artifactImpl == null) {
            ArtifactModelImpl.$$$reportNull$$$0(16);
        }
        return artifactImpl;
    }

    @NotNull
    public ArtifactImpl getArtifactByOriginal(@NotNull Artifact artifact) {
        ArtifactImpl artifactImpl;
        ArtifactImpl copy;
        if (artifact == null) {
            ArtifactModelImpl.$$$reportNull$$$0(17);
        }
        ArtifactImpl artifactImpl2 = (copy = this.myArtifact2ModifiableCopy.get((Object)(artifactImpl = (ArtifactImpl)artifact))) != null ? copy : artifactImpl;
        if (artifactImpl2 == null) {
            ArtifactModelImpl.$$$reportNull$$$0(18);
        }
        return artifactImpl2;
    }

    public boolean isModified() {
        return !this.myOriginalArtifacts.equals(this.myArtifactManager.getArtifactsList()) || !this.myArtifact2ModifiableCopy.isEmpty();
    }

    public void commit() {
        this.myArtifactManager.commit(this);
    }

    public void dispose() {
        ArrayList<ArtifactImpl> artifacts = new ArrayList<ArtifactImpl>();
        for (ArtifactImpl artifact : this.myModifiable2Original.keySet()) {
            if (!((Object)((Object)this.myModifiable2Original.get((Object)artifact))).equals((Object)artifact)) continue;
            artifacts.add(artifact);
        }
        ((ArtifactPointerManagerImpl)ArtifactPointerManager.getInstance((Project)this.myArtifactManager.getProject())).disposePointers(artifacts);
    }

    @Nullable
    public ArtifactImpl getModifiableCopy(Artifact artifact) {
        return this.myArtifact2ModifiableCopy.get(artifact);
    }

    public List<ArtifactImpl> getOriginalArtifacts() {
        return this.myOriginalArtifacts;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 5: 
            case 8: 
            case 13: 
            case 14: 
            case 16: 
            case 18: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 5: 
            case 8: 
            case 13: 
            case 14: 
            case 16: 
            case 18: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 1: 
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "artifactType";
                break;
            }
            case 2: 
            case 5: 
            case 8: 
            case 13: 
            case 14: 
            case 16: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/packaging/impl/artifacts/ArtifactModelImpl";
                break;
            }
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 11: 
            case 12: 
            case 15: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "artifact";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/packaging/impl/artifacts/ArtifactModelImpl";
                break;
            }
            case 2: 
            case 5: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "addArtifact";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getOrCreateModifiableArtifact";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getOriginalArtifact";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getArtifactByOriginal";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "addArtifact";
                break;
            }
            case 2: 
            case 5: 
            case 8: 
            case 13: 
            case 14: 
            case 16: 
            case 18: {
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "addListener";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "removeListener";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "removeArtifact";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getOrCreateModifiableArtifact";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getOriginalArtifact";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getArtifactByOriginal";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 5: 
            case 8: 
            case 13: 
            case 14: 
            case 16: 
            case 18: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

