/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.structuralsearch.plugin.ui;

import com.intellij.find.FindBundle;
import com.intellij.find.impl.FindPopupPanel;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CustomShortcutSet;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.fileChooser.FileChooserFactory;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.ui.ComponentWithBrowseButton;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.ui.TextComponentAccessor;
import com.intellij.openapi.ui.popup.Balloon;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.awt.RelativePoint;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Point;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DirectoryComboBoxWithButtons
extends JPanel {
    @NotNull
    private final ComponentWithBrowseButton<ComboBox<String>> myDirectoryComboBox;
    boolean myRecursive;
    Runnable myCallback;
    private final ActionListener myListener;

    public DirectoryComboBoxWithButtons(@NotNull Project project2) {
        if (project2 == null) {
            DirectoryComboBoxWithButtons.$$$reportNull$$$0(0);
        }
        super(new BorderLayout());
        this.myDirectoryComboBox = new ComponentWithBrowseButton((JComponent)new ComboBox(200), null);
        this.myRecursive = true;
        this.myListener = e -> {
            VirtualFile directory = this.getDirectory();
            ComboBox comboBox = (ComboBox)this.myDirectoryComboBox.getChildComponent();
            if (directory == null) {
                comboBox.putClientProperty((Object)"JComponent.outline", (Object)"error");
                Balloon balloon = JBPopupFactory.getInstance().createHtmlTextBalloonBuilder("Not a directory", AllIcons.General.BalloonError, MessageType.ERROR.getPopupBackground(), null).createBalloon();
                balloon.show(new RelativePoint((Component)comboBox, new Point(comboBox.getWidth() / 2, 0)), Balloon.Position.above);
            } else {
                comboBox.putClientProperty((Object)"JComponent.outline", null);
            }
            if (this.myCallback != null) {
                this.myCallback.run();
            }
        };
        final ComboBox comboBox = (ComboBox)this.myDirectoryComboBox.getChildComponent();
        comboBox.addActionListener(this.myListener);
        comboBox.setEditable(true);
        FileChooserDescriptor descriptor2 = FileChooserDescriptorFactory.createSingleFolderDescriptor();
        descriptor2.setForcedToUseIdeaFileChooser(true);
        Component editorComponent = comboBox.getEditor().getEditorComponent();
        if (editorComponent instanceof JTextField) {
            FileChooserFactory.getInstance().installFileCompletion((JTextField)editorComponent, descriptor2, true, null);
        }
        comboBox.setMaximumRowCount(8);
        this.myDirectoryComboBox.addBrowseFolderListener(null, null, project2, descriptor2, (TextComponentAccessor)new TextComponentAccessor<ComboBox<String>>(){

            public String getText(ComboBox comboBox2) {
                return comboBox2.getEditor().getItem().toString();
            }

            public void setText(ComboBox component, @NotNull String text) {
                if (text == null) {
                    1.$$$reportNull$$$0(0);
                }
                comboBox.getEditor().setItem(text);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/structuralsearch/plugin/ui/DirectoryComboBoxWithButtons$1", "setText"));
            }
        });
        RecursiveAction recursiveDirectoryAction = new RecursiveAction();
        int mnemonicModifiers = SystemInfo.isMac ? 640 : 512;
        recursiveDirectoryAction.registerCustomShortcutSet((ShortcutSet)new CustomShortcutSet(KeyStroke.getKeyStroke(89, mnemonicModifiers)), (JComponent)this.myDirectoryComboBox);
        this.add((Component)this.myDirectoryComboBox, "Center");
        this.add((Component)FindPopupPanel.createToolbar((AnAction[])new AnAction[]{recursiveDirectoryAction}), "East");
    }

    public ComboBox<String> getComboBox() {
        return (ComboBox)this.myDirectoryComboBox.getChildComponent();
    }

    public void setCallback(Runnable callback) {
        this.myCallback = callback;
    }

    public void setRecentDirectories(@NotNull List<String> recentDirectories) {
        if (recentDirectories == null) {
            DirectoryComboBoxWithButtons.$$$reportNull$$$0(1);
        }
        ComboBox comboBox = (ComboBox)this.myDirectoryComboBox.getChildComponent();
        comboBox.removeActionListener(this.myListener);
        comboBox.removeAllItems();
        for (int i = recentDirectories.size() - 1; i >= 0; --i) {
            comboBox.addItem((Object)recentDirectories.get(i));
        }
        comboBox.addActionListener(this.myListener);
    }

    public void setDirectory(@NotNull VirtualFile directory) {
        if (directory == null) {
            DirectoryComboBoxWithButtons.$$$reportNull$$$0(2);
        }
        this.setDirectory(directory.getPresentableUrl());
    }

    private void setDirectory(String path) {
        ((ComboBox)this.myDirectoryComboBox.getChildComponent()).setSelectedItem((Object)path);
    }

    @Nullable
    public VirtualFile getDirectory() {
        ComboBox comboBox = (ComboBox)this.myDirectoryComboBox.getChildComponent();
        String directoryName = (String)comboBox.getSelectedItem();
        if (StringUtil.isEmptyOrSpaces((String)directoryName)) {
            return null;
        }
        String path = FileUtil.toSystemIndependentName((String)directoryName);
        VirtualFile virtualFile = LocalFileSystem.getInstance().findFileByPath(path);
        return virtualFile == null || !virtualFile.isDirectory() ? null : virtualFile;
    }

    public boolean isRecursive() {
        return this.myRecursive;
    }

    public void setRecursive(boolean recursive) {
        this.myRecursive = recursive;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "recentDirectories";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "directory";
                break;
            }
        }
        objectArray2[1] = "com/intellij/structuralsearch/plugin/ui/DirectoryComboBoxWithButtons";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "setRecentDirectories";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "setDirectory";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private class RecursiveAction
    extends ToggleAction {
        RecursiveAction() {
            super(FindBundle.message((String)"find.scope.directory.recursive.checkbox", (Object[])new Object[0]), "Recursively", AllIcons.Actions.ShowAsTree);
        }

        public boolean isSelected(@NotNull AnActionEvent e) {
            if (e == null) {
                RecursiveAction.$$$reportNull$$$0(0);
            }
            return DirectoryComboBoxWithButtons.this.myRecursive;
        }

        public void setSelected(@NotNull AnActionEvent e, boolean state) {
            if (e == null) {
                RecursiveAction.$$$reportNull$$$0(1);
            }
            DirectoryComboBoxWithButtons.this.myRecursive = state;
            DirectoryComboBoxWithButtons.this.myCallback.run();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "e";
            objectArray2[1] = "com/intellij/structuralsearch/plugin/ui/DirectoryComboBoxWithButtons$RecursiveAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isSelected";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "setSelected";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

