/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testIntegration;

import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.TestStateStorage;
import com.intellij.execution.impl.RunManagerImpl;
import com.intellij.openapi.project.Project;
import com.intellij.testIntegration.ConfigurationByRecordProvider;
import gnu.trove.TIntObjectHashMap;

class RunConfigurationByRecordProvider
implements ConfigurationByRecordProvider {
    private final Project myProject;
    private final TIntObjectHashMap<RunnerAndConfigurationSettings> myConfigurationsMap = new TIntObjectHashMap();

    RunConfigurationByRecordProvider(Project project2) {
        this.myProject = project2;
        this.initRunConfigurationsMap();
    }

    @Override
    public RunnerAndConfigurationSettings getConfiguration(TestStateStorage.Record record) {
        return (RunnerAndConfigurationSettings)this.myConfigurationsMap.get((int)record.configurationHash);
    }

    private void initRunConfigurationsMap() {
        for (RunnerAndConfigurationSettings settings : RunManagerImpl.getInstanceImpl((Project)this.myProject).getAllSettings()) {
            this.myConfigurationsMap.put(settings.getName().hashCode(), (Object)settings);
        }
    }
}

