/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.lang.manifest.highlighting;

import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.lang.annotation.Annotator;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.psi.PsiElement;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.lang.manifest.ManifestBundle;
import org.jetbrains.lang.manifest.header.HeaderParser;
import org.jetbrains.lang.manifest.header.HeaderParserRepository;
import org.jetbrains.lang.manifest.psi.Header;

public class HeaderAnnotator
implements Annotator {
    private final HeaderParserRepository myRepository;

    public HeaderAnnotator(@NotNull HeaderParserRepository repository) {
        if (repository == null) {
            HeaderAnnotator.$$$reportNull$$$0(0);
        }
        this.myRepository = repository;
    }

    public void annotate(@NotNull PsiElement psiElement, @NotNull AnnotationHolder holder) {
        if (psiElement == null) {
            HeaderAnnotator.$$$reportNull$$$0(1);
        }
        if (holder == null) {
            HeaderAnnotator.$$$reportNull$$$0(2);
        }
        if (psiElement instanceof Header) {
            Header header = (Header)psiElement;
            String name2 = header.getName();
            if (!HeaderAnnotator.isValidName(name2)) {
                holder.createAnnotation(HighlightSeverity.ERROR, header.getNameElement().getTextRange(), ManifestBundle.message("header.name.invalid", new Object[0]));
            } else {
                HeaderParser headerParser = this.myRepository.getHeaderParser(name2);
                if (headerParser != null) {
                    headerParser.annotate(header, holder);
                }
            }
        }
    }

    private static boolean isValidName(String name2) {
        for (int i = 0; i < name2.length(); ++i) {
            char c = name2.charAt(i);
            if (c == '-' || c == '_' || Character.isLetterOrDigit(c)) continue;
            return false;
        }
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "repository";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiElement";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/lang/manifest/highlighting/HeaderAnnotator";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "annotate";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

