/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.dom.converters;

import com.intellij.codeInsight.completion.CodeCompletionHandlerBase;
import com.intellij.codeInsight.completion.CompletionType;
import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomUtil;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.maven.dom.MavenDomProjectProcessorUtils;
import org.jetbrains.idea.maven.dom.model.MavenDomArtifactCoordinates;
import org.jetbrains.idea.maven.dom.model.MavenDomDependencies;
import org.jetbrains.idea.maven.dom.model.MavenDomDependency;
import org.jetbrains.idea.maven.dom.model.MavenDomDependencyManagement;
import org.jetbrains.idea.maven.dom.model.MavenDomProjectModel;
import org.jetbrains.idea.maven.indices.MavenProjectIndicesManager;

public class MavenDependencyCompletionUtil {
    public static MavenDomDependency findManagedDependency(MavenDomProjectModel domModel, Project project, @NotNull String groupId, @NotNull String artifactId) {
        if (groupId == null) {
            MavenDependencyCompletionUtil.$$$reportNull$$$0(0);
        }
        if (artifactId == null) {
            MavenDependencyCompletionUtil.$$$reportNull$$$0(1);
        }
        Ref ref = new Ref();
        MavenDomProjectProcessorUtils.processDependenciesInDependencyManagement(domModel, (Processor<? super MavenDomDependency>)((Processor)dependency -> {
            if (groupId == null) {
                MavenDependencyCompletionUtil.$$$reportNull$$$0(8);
            }
            if (artifactId == null) {
                MavenDependencyCompletionUtil.$$$reportNull$$$0(9);
            }
            if (groupId.equals(dependency.getGroupId().getStringValue()) && artifactId.equals(dependency.getArtifactId().getStringValue())) {
                ref.set(dependency);
                return true;
            }
            return false;
        }), project);
        return (MavenDomDependency)ref.get();
    }

    private static boolean isInsideManagedDependency(MavenDomArtifactCoordinates dependency) {
        DomElement parent = dependency.getParent();
        if (!(parent instanceof MavenDomDependencies)) {
            return false;
        }
        return parent.getParent() instanceof MavenDomDependencyManagement;
    }

    public static void addTypeAndClassifierAndVersion(@NotNull InsertionContext context, @NotNull MavenDomDependency dependency, @NotNull String groupId, @NotNull String artifactId) {
        MavenDomProjectModel model;
        MavenDomDependency managedDependency;
        if (context == null) {
            MavenDependencyCompletionUtil.$$$reportNull$$$0(2);
        }
        if (dependency == null) {
            MavenDependencyCompletionUtil.$$$reportNull$$$0(3);
        }
        if (groupId == null) {
            MavenDependencyCompletionUtil.$$$reportNull$$$0(4);
        }
        if (artifactId == null) {
            MavenDependencyCompletionUtil.$$$reportNull$$$0(5);
        }
        if (!StringUtil.isEmpty((String)dependency.getVersion().getStringValue())) {
            return;
        }
        Project project = context.getProject();
        if (!MavenDependencyCompletionUtil.isInsideManagedDependency(dependency) && (managedDependency = MavenDependencyCompletionUtil.findManagedDependency(model = (MavenDomProjectModel)DomUtil.getFileElement((DomElement)dependency).getRootElement(), project, groupId, artifactId)) != null) {
            if (dependency.getClassifier().getXmlTag() == null && dependency.getType().getXmlTag() == null) {
                String type;
                String classifier = managedDependency.getClassifier().getRawText();
                if (StringUtil.isNotEmpty((String)classifier)) {
                    dependency.getClassifier().setStringValue(classifier);
                }
                if (StringUtil.isNotEmpty((String)(type = managedDependency.getType().getRawText()))) {
                    dependency.getType().setStringValue(type);
                }
            }
            return;
        }
        MavenProjectIndicesManager manager = MavenProjectIndicesManager.getInstance(project);
        Set<String> versions = manager.getVersions(groupId, artifactId);
        if (versions.size() == 1) {
            dependency.getVersion().setStringValue((String)ContainerUtil.getFirstItem(versions));
            return;
        }
        dependency.getVersion().setStringValue("");
        int versionPosition = dependency.getVersion().getXmlTag().getValue().getTextRange().getStartOffset();
        context.getEditor().getCaretModel().moveToOffset(versionPosition);
        if (versions.size() > 0) {
            MavenDependencyCompletionUtil.invokeCompletion(context, CompletionType.BASIC);
        }
    }

    public static void invokeCompletion(@NotNull InsertionContext context, CompletionType completionType) {
        if (context == null) {
            MavenDependencyCompletionUtil.$$$reportNull$$$0(6);
        }
        context.setLaterRunnable(() -> {
            if (context == null) {
                MavenDependencyCompletionUtil.$$$reportNull$$$0(7);
            }
            new CodeCompletionHandlerBase(completionType).invokeCompletion(context.getProject(), context.getEditor());
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "groupId";
                break;
            }
            case 1: 
            case 5: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "artifactId";
                break;
            }
            case 2: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dependency";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/idea/maven/dom/converters/MavenDependencyCompletionUtil";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "findManagedDependency";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "addTypeAndClassifierAndVersion";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "invokeCompletion";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$invokeCompletion$1";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$findManagedDependency$0";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

