/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.importing;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.externalSystem.service.project.IdeModifiableModelsProvider;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.util.Consumer;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.maven.importing.MavenAnnotationProcessorsModuleService;
import org.jetbrains.idea.maven.importing.MavenImporter;
import org.jetbrains.idea.maven.importing.MavenRootModelAdapter;
import org.jetbrains.idea.maven.model.MavenArtifact;
import org.jetbrains.idea.maven.model.MavenArtifactInfo;
import org.jetbrains.idea.maven.model.MavenId;
import org.jetbrains.idea.maven.project.MavenProject;
import org.jetbrains.idea.maven.project.MavenProjectChanges;
import org.jetbrains.idea.maven.project.MavenProjectsManager;
import org.jetbrains.idea.maven.project.MavenProjectsProcessorTask;
import org.jetbrains.idea.maven.project.MavenProjectsTree;
import org.jetbrains.idea.maven.project.ResolveContext;
import org.jetbrains.idea.maven.server.MavenEmbedderWrapper;
import org.jetbrains.idea.maven.server.NativeMavenProjectHolder;
import org.jetbrains.idea.maven.utils.MavenProcessCanceledException;
import org.jetbrains.jps.model.java.JavaSourceRootType;

public class MavenCompilerAnnotationProcessorPathsImporter
extends MavenImporter {
    private Logger LOG = Logger.getInstance((String)"#org.jetbrains.idea.maven.importing.MavenCompilerAnnotationProcessorPathsImporter");

    public MavenCompilerAnnotationProcessorPathsImporter() {
        super("org.apache.maven.plugins", "maven-compiler-plugin");
    }

    @Override
    public boolean isApplicable(MavenProject mavenProject) {
        return this.getConfig(mavenProject, "annotationProcessorPaths") != null;
    }

    @Override
    public void preProcess(Module module, MavenProject mavenProject, MavenProjectChanges changes, IdeModifiableModelsProvider modifiableModelsProvider) {
    }

    @Override
    public void process(IdeModifiableModelsProvider modifiableModelsProvider, Module module, MavenRootModelAdapter rootModel, MavenProjectsTree mavenModel, MavenProject mavenProject, MavenProjectChanges changes, Map<MavenProject, String> mavenProjectToModuleName, List<MavenProjectsProcessorTask> postTasks) {
        String annotationTargetDir = mavenProject.getAnnotationProcessorDirectory(false);
        new File(rootModel.toPath(annotationTargetDir).getPath()).mkdirs();
        rootModel.addGeneratedJavaSourceFolder(annotationTargetDir, JavaSourceRootType.SOURCE, false);
        Element config = this.getConfig(mavenProject, "annotationProcessorPaths");
        this.LOG.assertTrue(config != null);
        List<MavenArtifactInfo> artifactsInfo = MavenCompilerAnnotationProcessorPathsImporter.getArtifactsInfo(config);
        if (artifactsInfo.isEmpty()) {
            return;
        }
        ArrayList<String> moduleNames = new ArrayList<String>();
        for (MavenArtifactInfo info : artifactsInfo) {
            MavenProject mavenArtifact = mavenModel.findProject(new MavenId(info.getGroupId(), info.getArtifactId(), info.getVersion()));
            if (mavenArtifact == null) continue;
            ContainerUtil.addIfNotNull(moduleNames, (Object)mavenProjectToModuleName.get(mavenArtifact));
        }
        moduleNames.trimToSize();
        MavenAnnotationProcessorsModuleService.getInstance(module).setAnnotationProcessorModules(moduleNames);
    }

    @Override
    public void resolve(Project project, MavenProject mavenProject, NativeMavenProjectHolder nativeMavenProject, MavenEmbedderWrapper embedder, ResolveContext context) throws MavenProcessCanceledException {
        Element config = this.getConfig(mavenProject, "annotationProcessorPaths");
        this.LOG.assertTrue(config != null);
        List<MavenArtifactInfo> artifactsInfo = MavenCompilerAnnotationProcessorPathsImporter.getArtifactsInfo(config);
        if (artifactsInfo.isEmpty()) {
            return;
        }
        MavenProjectsManager projectsManager = MavenProjectsManager.getInstance(project);
        ArrayList<MavenArtifactInfo> externalArtifacts = new ArrayList<MavenArtifactInfo>();
        for (MavenArtifactInfo info : artifactsInfo) {
            MavenProject mavenArtifact = projectsManager.findProject(new MavenId(info.getGroupId(), info.getArtifactId(), info.getVersion()));
            if (mavenArtifact != null) continue;
            externalArtifacts.add(info);
        }
        List<MavenArtifact> annotationProcessors = embedder.resolveTransitively(externalArtifacts, mavenProject.getRemoteRepositories());
        mavenProject.addAnnotationProcessors(annotationProcessors);
    }

    @NotNull
    private static List<MavenArtifactInfo> getArtifactsInfo(Element config) {
        ArrayList<MavenArtifactInfo> artifacts = new ArrayList<MavenArtifactInfo>();
        Consumer addToArtifacts = path -> {
            String groupId = path.getChildTextTrim("groupId");
            String artifactId = path.getChildTextTrim("artifactId");
            String version = path.getChildTextTrim("version");
            String classifier = path.getChildTextTrim("classifier");
            artifacts.add(new MavenArtifactInfo(groupId, artifactId, version, "jar", classifier));
        };
        for (Element path2 : config.getChildren("path")) {
            addToArtifacts.consume((Object)path2);
        }
        for (Element annotationProcessorPath : config.getChildren("annotationProcessorPath")) {
            addToArtifacts.consume((Object)annotationProcessorPath);
        }
        ArrayList<MavenArtifactInfo> arrayList = artifacts;
        if (arrayList == null) {
            MavenCompilerAnnotationProcessorPathsImporter.$$$reportNull$$$0(0);
        }
        return arrayList;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/maven/importing/MavenCompilerAnnotationProcessorPathsImporter", "getArtifactsInfo"));
    }
}

