/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.indices;

import com.intellij.jarRepository.services.bintray.BintrayModel;
import com.intellij.jarRepository.services.bintray.BintrayRepositoryService;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.util.CachedValueImpl;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.io.DataExternalizer;
import com.intellij.util.io.EnumeratorStringDescriptor;
import com.intellij.util.io.KeyDescriptor;
import com.intellij.util.io.PersistentEnumeratorBase;
import com.intellij.util.io.PersistentHashMap;
import gnu.trove.THashMap;
import gnu.trove.THashSet;
import java.io.Closeable;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.lucene.search.Query;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.indices.BintrayIndexer;
import org.jetbrains.idea.maven.indices.MavenIndexException;
import org.jetbrains.idea.maven.indices.MavenIndices;
import org.jetbrains.idea.maven.indices.NotNexusIndexer;
import org.jetbrains.idea.maven.model.MavenArchetype;
import org.jetbrains.idea.maven.model.MavenArtifactInfo;
import org.jetbrains.idea.maven.project.MavenGeneralSettings;
import org.jetbrains.idea.maven.server.IndexedMavenId;
import org.jetbrains.idea.maven.server.MavenIndexerWrapper;
import org.jetbrains.idea.maven.server.MavenIndicesProcessor;
import org.jetbrains.idea.maven.server.MavenServerIndexerException;
import org.jetbrains.idea.maven.utils.MavenLog;
import org.jetbrains.idea.maven.utils.MavenProcessCanceledException;
import org.jetbrains.idea.maven.utils.MavenProgressIndicator;

public class MavenIndex {
    private static final String CURRENT_VERSION = "5";
    protected static final String INDEX_INFO_FILE = "index.properties";
    private static final String INDEX_VERSION_KEY = "version";
    private static final String KIND_KEY = "kind";
    private static final String ID_KEY = "id";
    private static final String PATH_OR_URL_KEY = "pathOrUrl";
    private static final String TIMESTAMP_KEY = "lastUpdate";
    private static final String DATA_DIR_NAME_KEY = "dataDirName";
    private static final String FAILURE_MESSAGE_KEY = "failureMessage";
    private static final String DATA_DIR_PREFIX = "data";
    private static final String ARTIFACT_IDS_MAP_FILE = "artifactIds-map.dat";
    private static final String VERSIONS_MAP_FILE = "versions-map.dat";
    private static final String ARCHETYPES_MAP_FILE = "archetypes-map.dat";
    private final MavenIndexerWrapper myNexusIndexer;
    private final NotNexusIndexer myNotNexusIndexer;
    private final File myDir;
    private final Set<String> myRegisteredRepositoryIds = ContainerUtil.newHashSet();
    private final CachedValue<String> myId = new CachedValueImpl((CachedValueProvider)new MyIndexRepositoryIdsProvider());
    private final String myRepositoryPathOrUrl;
    private final Kind myKind;
    private Long myUpdateTimestamp;
    private String myDataDirName;
    private IndexData myData;
    private String myFailureMessage;
    private boolean isBroken;
    private final IndexListener myListener;

    public MavenIndex(MavenIndexerWrapper indexer, File dir, String repositoryId, String repositoryPathOrUrl, Kind kind, IndexListener listener) throws MavenIndexException {
        this.myNexusIndexer = indexer;
        this.myDir = dir;
        this.myRegisteredRepositoryIds.add(repositoryId);
        this.myRepositoryPathOrUrl = MavenIndex.normalizePathOrUrl(repositoryPathOrUrl);
        this.myKind = kind;
        this.myListener = listener;
        this.myNotNexusIndexer = MavenIndex.initNotNexusIndexer(kind, repositoryPathOrUrl);
        this.open();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MavenIndex(MavenIndexerWrapper indexer, File dir, IndexListener listener) throws MavenIndexException {
        this.myNexusIndexer = indexer;
        this.myDir = dir;
        this.myListener = listener;
        Properties props = new Properties();
        try (FileInputStream s = new FileInputStream(new File(dir, INDEX_INFO_FILE));){
            props.load(s);
        }
        catch (IOException e) {
            throw new MavenIndexException("Cannot read index.properties file", e);
        }
        if (!CURRENT_VERSION.equals(props.getProperty(INDEX_VERSION_KEY))) {
            throw new MavenIndexException("Incompatible index version, needs to be updated: " + dir);
        }
        this.myKind = Kind.valueOf(props.getProperty(KIND_KEY));
        String myRepositoryIdsStr = props.getProperty(ID_KEY);
        if (myRepositoryIdsStr != null) {
            this.myRegisteredRepositoryIds.addAll(StringUtil.split((String)myRepositoryIdsStr, (String)","));
        }
        this.myRepositoryPathOrUrl = MavenIndex.normalizePathOrUrl(props.getProperty(PATH_OR_URL_KEY));
        try {
            String timestamp = props.getProperty(TIMESTAMP_KEY);
            if (timestamp != null) {
                this.myUpdateTimestamp = Long.parseLong(timestamp);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.myDataDirName = props.getProperty(DATA_DIR_NAME_KEY);
        this.myFailureMessage = props.getProperty(FAILURE_MESSAGE_KEY);
        this.myNotNexusIndexer = MavenIndex.initNotNexusIndexer(this.myKind, this.myRepositoryPathOrUrl);
        this.open();
    }

    private static NotNexusIndexer initNotNexusIndexer(Kind kind, String repositoryPathOrUrl) {
        BintrayModel.Repository info;
        if (kind == Kind.REMOTE && (info = BintrayRepositoryService.parseInfo((String)repositoryPathOrUrl)) != null && info.repo != null) {
            return new BintrayIndexer(info.subject, info.repo);
        }
        return null;
    }

    public void registerId(String repositoryId) throws MavenIndexException {
        if (this.myRegisteredRepositoryIds.add(repositoryId)) {
            this.save();
            this.close(true);
            this.open();
        }
    }

    @NotNull
    public static String normalizePathOrUrl(@NotNull String pathOrUrl) {
        if (pathOrUrl == null) {
            MavenIndex.$$$reportNull$$$0(0);
        }
        pathOrUrl = pathOrUrl.trim();
        pathOrUrl = FileUtil.toSystemIndependentName((String)pathOrUrl);
        while (pathOrUrl.endsWith("/")) {
            pathOrUrl = pathOrUrl.substring(0, pathOrUrl.length() - 1);
        }
        String string = pathOrUrl;
        if (string == null) {
            MavenIndex.$$$reportNull$$$0(1);
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void open() throws MavenIndexException {
        try {
            try {
                this.doOpen();
            }
            catch (Exception e1) {
                boolean versionUpdated = e1.getCause() instanceof PersistentEnumeratorBase.VersionUpdatedException;
                if (!versionUpdated) {
                    MavenLog.LOG.warn((Throwable)e1);
                }
                try {
                    this.doOpen();
                }
                catch (Exception e2) {
                    throw new MavenIndexException("Cannot open index " + this.myDir.getPath(), e2);
                }
                this.markAsBroken();
            }
        }
        finally {
            this.save();
        }
    }

    private void doOpen() throws Exception {
        try {
            File dataDir;
            if (this.myDataDirName == null) {
                dataDir = this.createNewDataDir();
                this.myDataDirName = dataDir.getName();
            } else {
                dataDir = new File(this.myDir, this.myDataDirName);
                dataDir.mkdirs();
            }
            if (this.myData != null) {
                this.myData.close(true);
            }
            this.myData = new IndexData(dataDir);
        }
        catch (Exception e) {
            this.cleanupBrokenData();
            throw e;
        }
    }

    private void cleanupBrokenData() {
        this.close(true);
        File currentDataDir = this.getCurrentDataDir();
        File currentDataContextDir = this.getCurrentDataContextDir();
        File[] files = currentDataDir.listFiles();
        if (files != null) {
            for (File file : files) {
                if (FileUtil.filesEqual((File)file, (File)currentDataContextDir)) continue;
                FileUtil.delete((File)file);
            }
        } else {
            FileUtil.delete((File)currentDataDir);
        }
    }

    public synchronized void close(boolean releaseIndexContext) {
        try {
            if (this.myData != null) {
                this.myData.close(releaseIndexContext);
            }
        }
        catch (MavenIndexException e) {
            MavenLog.LOG.warn((Throwable)e);
        }
        this.myData = null;
    }

    private synchronized void save() {
        this.myDir.mkdirs();
        Properties props = new Properties();
        props.setProperty(KIND_KEY, this.myKind.toString());
        props.setProperty(ID_KEY, (String)this.myId.getValue());
        props.setProperty(PATH_OR_URL_KEY, this.myRepositoryPathOrUrl);
        props.setProperty(INDEX_VERSION_KEY, CURRENT_VERSION);
        if (this.myUpdateTimestamp != null) {
            props.setProperty(TIMESTAMP_KEY, String.valueOf(this.myUpdateTimestamp));
        }
        if (this.myDataDirName != null) {
            props.setProperty(DATA_DIR_NAME_KEY, this.myDataDirName);
        }
        if (this.myFailureMessage != null) {
            props.setProperty(FAILURE_MESSAGE_KEY, this.myFailureMessage);
        }
        try (FileOutputStream s = new FileOutputStream(new File(this.myDir, INDEX_INFO_FILE));){
            props.store(s, null);
        }
        catch (IOException e) {
            MavenLog.LOG.warn((Throwable)e);
        }
    }

    public String getRepositoryId() {
        return (String)this.myId.getValue();
    }

    public File getRepositoryFile() {
        return this.myKind == Kind.LOCAL ? new File(this.myRepositoryPathOrUrl) : null;
    }

    public String getRepositoryUrl() {
        return this.myKind == Kind.REMOTE ? this.myRepositoryPathOrUrl : null;
    }

    public String getRepositoryPathOrUrl() {
        return this.myRepositoryPathOrUrl;
    }

    public Kind getKind() {
        return this.myKind;
    }

    public boolean isFor(Kind kind, String pathOrUrl) {
        if (this.myKind != kind) {
            return false;
        }
        if (kind == Kind.LOCAL) {
            return FileUtil.pathsEqual((String)this.myRepositoryPathOrUrl, (String)MavenIndex.normalizePathOrUrl(pathOrUrl));
        }
        return this.myRepositoryPathOrUrl.equalsIgnoreCase(MavenIndex.normalizePathOrUrl(pathOrUrl));
    }

    public synchronized long getUpdateTimestamp() {
        return this.myUpdateTimestamp == null ? -1L : this.myUpdateTimestamp;
    }

    public synchronized String getFailureMessage() {
        return this.myFailureMessage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateOrRepair(boolean fullUpdate, MavenGeneralSettings settings, MavenProgressIndicator progress) throws MavenProcessCanceledException {
        try {
            File newDataDir = this.createNewDataDir();
            File newDataContextDir = MavenIndex.getDataContextDir(newDataDir);
            File currentDataContextDir = this.getCurrentDataContextDir();
            if (this.myNotNexusIndexer == null) {
                boolean reuseExistingContext = fullUpdate ? this.myKind != Kind.LOCAL && this.hasValidContext(currentDataContextDir) : this.hasValidContext(currentDataContextDir);
                boolean bl = fullUpdate = fullUpdate || !reuseExistingContext && this.myKind == Kind.LOCAL;
                if (reuseExistingContext) {
                    try {
                        FileUtil.copyDir((File)currentDataContextDir, (File)newDataContextDir);
                    }
                    catch (IOException e) {
                        throw new MavenIndexException(e);
                    }
                }
                if (fullUpdate) {
                    int context = this.createContext(newDataContextDir, "update");
                    try {
                        this.updateContext(context, settings, progress);
                    }
                    finally {
                        this.myNexusIndexer.releaseIndex(context);
                    }
                }
            }
            this.updateData(progress, newDataDir, fullUpdate);
            this.isBroken = false;
            this.myFailureMessage = null;
        }
        catch (MavenProcessCanceledException e) {
            throw e;
        }
        catch (Exception e) {
            this.handleUpdateException(e);
        }
        this.save();
    }

    private boolean hasValidContext(@NotNull File contextDir) {
        if (contextDir == null) {
            MavenIndex.$$$reportNull$$$0(2);
        }
        return contextDir.isDirectory() && this.myNexusIndexer.indexExists(contextDir);
    }

    private void handleUpdateException(Exception e) {
        this.myFailureMessage = e.getMessage();
        MavenLog.LOG.warn("Failed to update Maven indices for: [" + (String)this.myId.getValue() + "] " + this.myRepositoryPathOrUrl, (Throwable)e);
    }

    private int createContext(File contextDir, String suffix) throws MavenServerIndexerException {
        if (this.myNotNexusIndexer != null) {
            return 0;
        }
        String indexId = this.myDir.getName() + "-" + suffix;
        return this.myNexusIndexer.createIndex(indexId, (String)this.myId.getValue(), this.getRepositoryFile(), this.getRepositoryUrl(), contextDir);
    }

    private void updateContext(int indexId, MavenGeneralSettings settings, MavenProgressIndicator progress) throws MavenServerIndexerException, MavenProcessCanceledException {
        this.myNexusIndexer.updateIndex(indexId, settings, progress);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateData(MavenProgressIndicator progress, File newDataDir, boolean fullUpdate) throws MavenIndexException {
        MavenIndex mavenIndex = this;
        synchronized (mavenIndex) {
            IndexData oldData = this.myData;
            if (oldData != null) {
                oldData.close(true);
            }
        }
        IndexData newData = new IndexData(newDataDir);
        try {
            this.doUpdateIndexData(newData, progress);
            newData.flush();
        }
        catch (Throwable e) {
            newData.close(true);
            FileUtil.delete((File)newDataDir);
            if (e instanceof MavenServerIndexerException) {
                throw new MavenIndexException(e);
            }
            if (e instanceof IOException) {
                throw new MavenIndexException(e);
            }
            throw new RuntimeException(e);
        }
        MavenIndex mavenIndex2 = this;
        synchronized (mavenIndex2) {
            this.myData = newData;
            this.myDataDirName = newDataDir.getName();
            if (fullUpdate) {
                this.myUpdateTimestamp = System.currentTimeMillis();
            }
            for (File each : FileUtil.notNullize((File[])this.myDir.listFiles())) {
                if (!each.getName().startsWith(DATA_DIR_PREFIX) || each.getName().equals(this.myDataDirName)) continue;
                FileUtil.delete((File)each);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doUpdateIndexData(IndexData data, MavenProgressIndicator progress) throws IOException, MavenServerIndexerException {
        THashMap groupToArtifactMap = new THashMap();
        THashMap groupWithArtifactToVersionMap = new THashMap();
        THashMap archetypeIdToDescriptionMap = new THashMap();
        progress.pushState();
        progress.setIndeterminate(true);
        try {
            StringBuilder builder = new StringBuilder();
            MavenIndicesProcessor mavenIndicesProcessor = arg_0 -> MavenIndex.lambda$doUpdateIndexData$0(builder, (Map)groupToArtifactMap, (Map)groupWithArtifactToVersionMap, (Map)archetypeIdToDescriptionMap, arg_0);
            if (this.myNotNexusIndexer != null) {
                this.myNotNexusIndexer.processArtifacts(progress, mavenIndicesProcessor);
            } else {
                this.myNexusIndexer.processArtifacts(data.indexId, mavenIndicesProcessor);
            }
            MavenIndex.persist(groupToArtifactMap, data.groupToArtifactMap);
            MavenIndex.persist(groupWithArtifactToVersionMap, data.groupWithArtifactToVersionMap);
            MavenIndex.persist(archetypeIdToDescriptionMap, data.archetypeIdToDescriptionMap);
        }
        finally {
            progress.popState();
        }
    }

    private static <T> Set<T> getOrCreate(Map<String, Set<T>> map, String key) {
        return map.computeIfAbsent(key, k -> new THashSet());
    }

    private static <T> void persist(Map<String, T> map, PersistentHashMap<String, T> persistentMap) throws IOException {
        for (Map.Entry<String, T> each : map.entrySet()) {
            persistentMap.put((Object)each.getKey(), each.getValue());
        }
    }

    public File getDir() {
        return this.myDir;
    }

    protected synchronized File getCurrentDataDir() {
        return new File(this.myDir, this.myDataDirName);
    }

    private File getCurrentDataContextDir() {
        return new File(this.getCurrentDataDir(), "context");
    }

    private static File getDataContextDir(File dataDir) {
        return new File(dataDir, "context");
    }

    @NotNull
    private File createNewDataDir() {
        File file = MavenIndices.createNewDir(this.myDir, DATA_DIR_PREFIX, 100);
        if (file == null) {
            MavenIndex.$$$reportNull$$$0(3);
        }
        return file;
    }

    public synchronized void addArtifact(File artifactFile) {
        this.doIndexTask(() -> {
            IndexedMavenId id = this.myData.addArtifact(artifactFile);
            if (id == null) {
                return null;
            }
            this.myData.hasGroupCache.put(id.groupId, true);
            String groupWithArtifact = id.groupId + ":" + id.artifactId;
            this.myData.hasArtifactCache.put(groupWithArtifact, true);
            this.myData.hasVersionCache.put(groupWithArtifact + ':' + id.version, true);
            MavenIndex.addToCache(this.myData.groupToArtifactMap, id.groupId, id.artifactId);
            MavenIndex.addToCache(this.myData.groupWithArtifactToVersionMap, groupWithArtifact, id.version);
            if ("maven-archetype".equals(id.packaging)) {
                MavenIndex.addToCache(this.myData.archetypeIdToDescriptionMap, groupWithArtifact, id.version + ":" + StringUtil.notNullize((String)id.description));
            }
            this.myData.flush();
            return null;
        }, null);
    }

    private static void addToCache(PersistentHashMap<String, Set<String>> cache, String key, String value) throws IOException {
        Set values = (Set)cache.get((Object)key);
        if (values == null) {
            values = new THashSet();
        }
        values.add(value);
        cache.put((Object)key, (Object)values);
    }

    public synchronized Collection<String> getGroupIds() {
        return this.doIndexTask(() -> this.myData.groupToArtifactMap.getAllDataObjects(null), Collections.emptySet());
    }

    public synchronized Set<String> getArtifactIds(String groupId) {
        return this.doIndexTask(() -> ContainerUtil.notNullize((Set)((Set)this.myData.groupToArtifactMap.get((Object)groupId))), Collections.emptySet());
    }

    public synchronized void printInfo() {
        this.doIndexTask(() -> {
            System.out.println("BaseFile: " + this.myData.groupToArtifactMap.getBaseFile());
            System.out.println("All data objects: " + this.myData.groupToArtifactMap.getAllDataObjects(null));
            return null;
        }, null);
    }

    public synchronized Set<String> getVersions(String groupId, String artifactId) {
        String ga = groupId + ":" + artifactId;
        return this.doIndexTask(() -> ContainerUtil.notNullize((Set)((Set)this.myData.groupWithArtifactToVersionMap.get((Object)ga))), Collections.emptySet());
    }

    public synchronized boolean hasGroupId(String groupId) {
        if (this.isBroken) {
            return false;
        }
        return this.hasValue(this.myData.groupToArtifactMap, this.myData.hasGroupCache, groupId);
    }

    public synchronized boolean hasArtifactId(String groupId, String artifactId) {
        if (this.isBroken) {
            return false;
        }
        return this.hasValue(this.myData.groupWithArtifactToVersionMap, this.myData.hasArtifactCache, groupId + ":" + artifactId);
    }

    public synchronized boolean hasVersion(String groupId, String artifactId, String version) {
        if (this.isBroken) {
            return false;
        }
        String groupWithArtifactWithVersion = groupId + ":" + artifactId + ':' + version;
        String groupWithArtifact = groupWithArtifactWithVersion.substring(0, groupWithArtifactWithVersion.length() - version.length() - 1);
        return this.myData.hasVersionCache.computeIfAbsent(groupWithArtifactWithVersion, gav -> this.doIndexTask(() -> ContainerUtil.notNullize((Set)((Set)this.myData.groupWithArtifactToVersionMap.get((Object)groupWithArtifact))).contains(version), false));
    }

    private boolean hasValue(PersistentHashMap<String, ?> map, Map<String, Boolean> cache, String value) {
        return cache.computeIfAbsent(value, v -> this.doIndexTask(() -> map.tryEnumerate(v) != 0, false));
    }

    public synchronized Set<MavenArtifactInfo> search(Query query, int maxResult) {
        if (this.myNotNexusIndexer != null) {
            return Collections.emptySet();
        }
        return this.doIndexTask(() -> this.myData.search(query, maxResult), Collections.emptySet());
    }

    public synchronized Set<MavenArchetype> getArchetypes() {
        return this.doIndexTask(() -> {
            THashSet archetypes = new THashSet();
            for (String ga : this.myData.archetypeIdToDescriptionMap.getAllKeysWithExistingMapping()) {
                List gaParts = StringUtil.split((String)ga, (String)":");
                String groupId = (String)gaParts.get(0);
                String artifactId = (String)gaParts.get(1);
                for (String vd : (Set)this.myData.archetypeIdToDescriptionMap.get((Object)ga)) {
                    int index = vd.indexOf(58);
                    if (index == -1) continue;
                    String version = vd.substring(0, index);
                    String description = vd.substring(index + 1);
                    archetypes.add(new MavenArchetype(groupId, artifactId, version, this.myRepositoryPathOrUrl, description));
                }
            }
            return archetypes;
        }, Collections.emptySet());
    }

    private <T> T doIndexTask(IndexTask<T> task, T defaultValue) {
        assert (Thread.holdsLock(this));
        if (!this.isBroken) {
            try {
                return task.doTask();
            }
            catch (Exception e1) {
                MavenLog.LOG.warn((Throwable)e1);
                this.cleanupBrokenData();
                try {
                    this.open();
                }
                catch (MavenIndexException e2) {
                    MavenLog.LOG.warn((Throwable)e2);
                }
            }
        }
        this.markAsBroken();
        return defaultValue;
    }

    private void markAsBroken() {
        if (!this.isBroken) {
            this.myListener.indexIsBroken(this);
        }
        this.isBroken = true;
    }

    private static /* synthetic */ void lambda$doUpdateIndexData$0(StringBuilder builder, Map groupToArtifactMap, Map groupWithArtifactToVersionMap, Map archetypeIdToDescriptionMap, Collection artifacts) {
        for (IndexedMavenId id : artifacts) {
            builder.setLength(0);
            builder.append(id.groupId).append(":").append(id.artifactId);
            String ga = builder.toString();
            MavenIndex.getOrCreate(groupToArtifactMap, id.groupId).add(id.artifactId);
            MavenIndex.getOrCreate(groupWithArtifactToVersionMap, ga).add(id.version);
            if (!"maven-archetype".equals(id.packaging)) continue;
            builder.setLength(0);
            builder.append(id.version).append(":").append(StringUtil.notNullize((String)id.description));
            MavenIndex.getOrCreate(archetypeIdToDescriptionMap, ga).add(builder.toString());
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = PATH_OR_URL_KEY;
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/idea/maven/indices/MavenIndex";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contextDir";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/idea/maven/indices/MavenIndex";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "normalizePathOrUrl";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createNewDataDir";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "normalizePathOrUrl";
                break;
            }
            case 1: 
            case 3: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "hasValidContext";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class MyIndexRepositoryIdsProvider
    implements CachedValueProvider<String> {
        private MyIndexRepositoryIdsProvider() {
        }

        @Nullable
        public CachedValueProvider.Result<String> compute() {
            Object[] objectArray = new Object[1];
            objectArray[0] = MavenIndex.this.myRegisteredRepositoryIds::hashCode;
            return CachedValueProvider.Result.create((Object)StringUtil.join((Collection)MavenIndex.this.myRegisteredRepositoryIds, (String)","), (Object[])objectArray);
        }
    }

    public static interface IndexListener {
        public void indexIsBroken(@NotNull MavenIndex var1);
    }

    private static class SetDescriptor
    implements DataExternalizer<Set<String>> {
        private SetDescriptor() {
        }

        public void save(@NotNull DataOutput s, Set<String> set) throws IOException {
            if (s == null) {
                SetDescriptor.$$$reportNull$$$0(0);
            }
            s.writeInt(set.size());
            for (String each : set) {
                s.writeUTF(each);
            }
        }

        public Set<String> read(@NotNull DataInput s) throws IOException {
            if (s == null) {
                SetDescriptor.$$$reportNull$$$0(1);
            }
            int count = s.readInt();
            THashSet result = new THashSet(count);
            while (count-- > 0) {
                result.add(s.readUTF());
            }
            return result;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "s";
            objectArray2[1] = "org/jetbrains/idea/maven/indices/MavenIndex$SetDescriptor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "save";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "read";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private class IndexData {
        final PersistentHashMap<String, Set<String>> groupToArtifactMap;
        final PersistentHashMap<String, Set<String>> groupWithArtifactToVersionMap;
        final PersistentHashMap<String, Set<String>> archetypeIdToDescriptionMap;
        final Map<String, Boolean> hasGroupCache = new THashMap();
        final Map<String, Boolean> hasArtifactCache = new THashMap();
        final Map<String, Boolean> hasVersionCache = new THashMap();
        private final int indexId;

        IndexData(File dir) throws MavenIndexException {
            try {
                this.groupToArtifactMap = this.createPersistentMap(new File(dir, MavenIndex.ARTIFACT_IDS_MAP_FILE));
                this.groupWithArtifactToVersionMap = this.createPersistentMap(new File(dir, MavenIndex.VERSIONS_MAP_FILE));
                this.archetypeIdToDescriptionMap = this.createPersistentMap(new File(dir, MavenIndex.ARCHETYPES_MAP_FILE));
                this.indexId = MavenIndex.this.createContext(MavenIndex.getDataContextDir(dir), dir.getName());
            }
            catch (IOException | MavenServerIndexerException e) {
                this.close(true);
                throw new MavenIndexException(e);
            }
        }

        private PersistentHashMap<String, Set<String>> createPersistentMap(File f) throws IOException {
            return new PersistentHashMap(f, (KeyDescriptor)EnumeratorStringDescriptor.INSTANCE, (DataExternalizer)new SetDescriptor());
        }

        public void close(boolean releaseIndexContext) throws MavenIndexException {
            MavenIndexException[] exceptions;
            block4: {
                exceptions = new MavenIndexException[1];
                try {
                    if (this.indexId != 0 && releaseIndexContext) {
                        MavenIndex.this.myNexusIndexer.releaseIndex(this.indexId);
                    }
                }
                catch (MavenServerIndexerException e) {
                    MavenLog.LOG.warn((Throwable)e);
                    if (exceptions[0] != null) break block4;
                    exceptions[0] = new MavenIndexException(e);
                }
            }
            this.safeClose((Closeable)this.groupToArtifactMap, exceptions);
            this.safeClose((Closeable)this.groupWithArtifactToVersionMap, exceptions);
            this.safeClose((Closeable)this.archetypeIdToDescriptionMap, exceptions);
            if (exceptions[0] != null) {
                throw exceptions[0];
            }
        }

        private void safeClose(@Nullable Closeable enumerator, MavenIndexException[] exceptions) {
            block3: {
                try {
                    if (enumerator != null) {
                        enumerator.close();
                    }
                }
                catch (IOException e) {
                    MavenLog.LOG.warn((Throwable)e);
                    if (exceptions[0] != null) break block3;
                    exceptions[0] = new MavenIndexException(e);
                }
            }
        }

        public void flush() throws IOException {
            this.groupToArtifactMap.force();
            this.groupWithArtifactToVersionMap.force();
            this.archetypeIdToDescriptionMap.force();
        }

        public IndexedMavenId addArtifact(File artifactFile) throws MavenServerIndexerException {
            return MavenIndex.this.myNexusIndexer.addArtifact(this.indexId, artifactFile);
        }

        public Set<MavenArtifactInfo> search(Query query, int maxResult) throws MavenServerIndexerException {
            return MavenIndex.this.myNexusIndexer.search(this.indexId, query, maxResult);
        }
    }

    @FunctionalInterface
    private static interface IndexTask<T> {
        public T doTask() throws Exception;
    }

    public static enum Kind {
        LOCAL,
        REMOTE;

    }
}

