/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.javaFX.fxml.refs;

import com.intellij.openapi.util.Condition;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileSystem;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceProvider;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReferenceSet;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.ProcessingContext;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class JavaFxFileReferenceProvider
extends PsiReferenceProvider {
    private final String myAcceptedExtension;

    public JavaFxFileReferenceProvider(String acceptedExtension) {
        this.myAcceptedExtension = acceptedExtension;
    }

    @NotNull
    public PsiReference[] getReferencesByElement(@NotNull PsiElement element, @NotNull ProcessingContext context) {
        Object value;
        if (element == null) {
            JavaFxFileReferenceProvider.$$$reportNull$$$0(0);
        }
        if (context == null) {
            JavaFxFileReferenceProvider.$$$reportNull$$$0(1);
        }
        if (!((value = ((PsiLiteralExpression)element).getValue()) instanceof String)) {
            if (PsiReference.EMPTY_ARRAY == null) {
                JavaFxFileReferenceProvider.$$$reportNull$$$0(2);
            }
            return PsiReference.EMPTY_ARRAY;
        }
        PsiReference[] psiReferenceArray = JavaFxFileReferenceProvider.getReferences(element, this.preprocessValue((String)value), this.myAcceptedExtension);
        if (psiReferenceArray == null) {
            JavaFxFileReferenceProvider.$$$reportNull$$$0(3);
        }
        return psiReferenceArray;
    }

    protected String preprocessValue(String value) {
        return value;
    }

    public static PsiReference[] getReferences(@NotNull PsiElement element, String value, final String acceptedExtension) {
        PsiDirectory directory;
        if (element == null) {
            JavaFxFileReferenceProvider.$$$reportNull$$$0(4);
        }
        if ((directory = element.getContainingFile().getOriginalFile().getParent()) == null) {
            return PsiReference.EMPTY_ARRAY;
        }
        final boolean startsWithSlash = value.startsWith("/");
        VirtualFileSystem fs = directory.getVirtualFile().getFileSystem();
        FileReferenceSet fileReferenceSet = new FileReferenceSet(value, element, 1, null, fs.isCaseSensitive()){

            @NotNull
            public Collection<PsiFileSystemItem> getDefaultContexts() {
                if (startsWithSlash || !directory.isValid()) {
                    Collection collection = super.getDefaultContexts();
                    if (collection == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    return collection;
                }
                List<PsiDirectory> list = Collections.singletonList(directory);
                if (list == null) {
                    1.$$$reportNull$$$0(1);
                }
                return list;
            }

            protected Condition<PsiFileSystemItem> getReferenceCompletionFilter() {
                return item -> {
                    if (item instanceof PsiDirectory) {
                        return true;
                    }
                    VirtualFile virtualFile = PsiUtilCore.getVirtualFile((PsiElement)item);
                    return virtualFile != null && acceptedExtension.equals(virtualFile.getExtension());
                };
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/javaFX/fxml/refs/JavaFxFileReferenceProvider$1", "getDefaultContexts"));
            }
        };
        if (startsWithSlash) {
            fileReferenceSet.addCustomization(FileReferenceSet.DEFAULT_PATH_EVALUATOR_OPTION, (Object)FileReferenceSet.ABSOLUTE_TOP_LEVEL);
        }
        return fileReferenceSet.getAllReferences();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/javaFX/fxml/refs/JavaFxFileReferenceProvider";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/javaFX/fxml/refs/JavaFxFileReferenceProvider";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getReferencesByElement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getReferencesByElement";
                break;
            }
            case 2: 
            case 3: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getReferences";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

