/*
 * Decompiled with CFR 0.152.
 */
package org.jf.baksmali;

import com.beust.jcommander.JCommander;
import com.beust.jcommander.Parameter;
import com.beust.jcommander.Parameters;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.List;
import javax.annotation.Nonnull;
import org.jf.baksmali.DexInputCommand;
import org.jf.dexlib2.dexbacked.BaseDexBuffer;
import org.jf.dexlib2.dexbacked.DexBackedDexFile;
import org.jf.dexlib2.dexbacked.raw.RawDexFile;
import org.jf.dexlib2.dexbacked.raw.util.DexAnnotator;
import org.jf.util.ConsoleUtil;
import org.jf.util.jcommander.ExtendedParameters;

@Parameters(commandDescription="Prints an annotated hex dump for the given dex file")
@ExtendedParameters(commandName="dump", commandAliases={"du"})
public class DumpCommand
extends DexInputCommand {
    @Parameter(names={"-h", "-?", "--help"}, help=true, description="Show usage information for this command.")
    private boolean help;

    public DumpCommand(@Nonnull List<JCommander> commandAncestors) {
        super(commandAncestors);
    }

    public void run() {
        if (this.help || this.inputList == null || this.inputList.isEmpty()) {
            this.usage();
            return;
        }
        if (this.inputList.size() > 1) {
            System.err.println("Too many files specified");
            this.usage();
            return;
        }
        String input = (String)this.inputList.get(0);
        this.loadDexFile(input);
        try {
            DumpCommand.dump(this.dexFile, System.out);
        }
        catch (IOException ex) {
            System.err.println("There was an error while dumping the dex file");
            ex.printStackTrace(System.err);
        }
    }

    public static void dump(@Nonnull DexBackedDexFile dexFile, @Nonnull OutputStream output) throws IOException {
        BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(output));
        int consoleWidth = ConsoleUtil.getConsoleWidth();
        if (consoleWidth <= 0) {
            consoleWidth = 120;
        }
        RawDexFile rawDexFile = new RawDexFile(dexFile.getOpcodes(), (BaseDexBuffer)dexFile);
        DexAnnotator annotator = new DexAnnotator(rawDexFile, consoleWidth);
        annotator.writeAnnotations((Writer)writer);
    }
}

