/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.completion;

import com.intellij.injected.editor.EditorWindow;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.ex.AnActionListener;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandEvent;
import com.intellij.openapi.command.CommandListener;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.event.CaretEvent;
import com.intellij.openapi.editor.event.CaretListener;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import org.jetbrains.annotations.NotNull;

class ActionTracker {
    private boolean myActionsHappened;
    private final Editor myEditor;
    private final Project myProject;
    private boolean myIgnoreDocumentChanges;

    ActionTracker(Editor editor, Disposable parentDisposable) {
        this.myEditor = editor;
        this.myProject = editor.getProject();
        ApplicationManager.getApplication().getMessageBus().connect(parentDisposable).subscribe(AnActionListener.TOPIC, (Object)new AnActionListener(){

            public void beforeEditorTyping(char c, @NotNull DataContext dataContext) {
                if (dataContext == null) {
                    1.$$$reportNull$$$0(0);
                }
                ActionTracker.this.myActionsHappened = true;
            }

            public void beforeActionPerformed(@NotNull AnAction action, @NotNull DataContext dataContext, AnActionEvent event) {
                if (action == null) {
                    1.$$$reportNull$$$0(1);
                }
                if (dataContext == null) {
                    1.$$$reportNull$$$0(2);
                }
                ActionTracker.this.myActionsHappened = true;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "dataContext";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "action";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/codeInsight/completion/ActionTracker$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "beforeEditorTyping";
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "beforeActionPerformed";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        this.myEditor.getDocument().addDocumentListener(new DocumentListener(){

            public void documentChanged(@NotNull DocumentEvent e) {
                if (e == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (!ActionTracker.this.myIgnoreDocumentChanges) {
                    ActionTracker.this.myActionsHappened = true;
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/codeInsight/completion/ActionTracker$2", "documentChanged"));
            }
        }, parentDisposable);
        this.myEditor.getCaretModel().addCaretListener(new CaretListener(){

            public void caretAdded(@NotNull CaretEvent event) {
                if (event == null) {
                    3.$$$reportNull$$$0(0);
                }
                ActionTracker.this.myActionsHappened = true;
            }

            public void caretRemoved(@NotNull CaretEvent event) {
                if (event == null) {
                    3.$$$reportNull$$$0(1);
                }
                ActionTracker.this.myActionsHappened = true;
            }

            public void caretPositionChanged(@NotNull CaretEvent event) {
                if (event == null) {
                    3.$$$reportNull$$$0(2);
                }
                if (!ActionTracker.this.myIgnoreDocumentChanges) {
                    ActionTracker.this.myActionsHappened = true;
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "event";
                objectArray2[1] = "com/intellij/codeInsight/completion/ActionTracker$3";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "caretAdded";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "caretRemoved";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "caretPositionChanged";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }, parentDisposable);
    }

    void ignoreCurrentDocumentChange() {
        if (CommandProcessor.getInstance().getCurrentCommand() == null) {
            return;
        }
        this.myIgnoreDocumentChanges = true;
        final Disposable disposable = Disposer.newDisposable();
        Disposer.register((Disposable)this.myProject, (Disposable)disposable);
        this.myProject.getMessageBus().connect(disposable).subscribe(CommandListener.TOPIC, (Object)new CommandListener(){

            public void commandFinished(@NotNull CommandEvent event) {
                if (event == null) {
                    4.$$$reportNull$$$0(0);
                }
                Disposer.dispose((Disposable)disposable);
                ActionTracker.this.myIgnoreDocumentChanges = false;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/codeInsight/completion/ActionTracker$4", "commandFinished"));
            }
        });
    }

    boolean hasAnythingHappened() {
        return this.myActionsHappened || DumbService.getInstance((Project)this.myProject).isDumb() || this.myEditor.isDisposed() || this.myEditor instanceof EditorWindow && !((EditorWindow)this.myEditor).isValid();
    }
}

