/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.facet.impl;

import com.intellij.facet.Facet;
import com.intellij.facet.FacetManagerImpl;
import com.intellij.facet.ModifiableFacetModel;
import com.intellij.facet.impl.FacetModelBase;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.roots.ProjectModelExternalSource;
import com.intellij.openapi.util.Disposer;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FacetModelImpl
extends FacetModelBase
implements ModifiableFacetModel {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.facet.impl.FacetModelImpl");
    private final List<Facet> myFacets = new ArrayList<Facet>();
    private final Map<Facet, String> myFacet2NewName = new HashMap<Facet, String>();
    private final FacetManagerImpl myManager;
    private final List<ModifiableFacetModel.Listener> myListeners = ContainerUtil.createLockFreeCopyOnWriteList();

    public FacetModelImpl(FacetManagerImpl manager) {
        this.myManager = manager;
    }

    public void addFacetsFromManager() {
        for (Facet facet : this.myManager.getAllFacets()) {
            this.addFacet(facet);
        }
    }

    public void addFacet(Facet facet) {
        if (this.myFacets.contains(facet)) {
            LOG.error("Facet " + facet + " [" + facet.getTypeId() + "] is already added");
        }
        this.myFacets.add(facet);
        this.facetsChanged();
    }

    public void addFacet(Facet facet, @Nullable ProjectModelExternalSource externalSource) {
        this.addFacet(facet);
        this.myManager.setExternalSource(facet, externalSource);
    }

    public void removeFacet(Facet facet) {
        if (!this.myFacets.remove(facet)) {
            LOG.error("Facet " + facet + " [" + facet.getTypeId() + "] not found");
        }
        this.myFacet2NewName.remove(facet);
        this.facetsChanged();
    }

    public void rename(Facet facet, String newName) {
        if (!newName.equals(facet.getName())) {
            this.myFacet2NewName.put(facet, newName);
        } else {
            this.myFacet2NewName.remove(facet);
        }
        this.facetsChanged();
    }

    @Nullable
    public String getNewName(Facet facet) {
        return this.myFacet2NewName.get(facet);
    }

    public void commit() {
        this.myManager.commit(this);
    }

    public boolean isModified() {
        return !new HashSet<Facet>(this.myFacets).equals(new HashSet<Facet>(Arrays.asList(this.myManager.getAllFacets()))) || !this.myFacet2NewName.isEmpty();
    }

    public boolean isNewFacet(Facet facet) {
        return this.myFacets.contains(facet) && ArrayUtil.find((Object[])this.myManager.getAllFacets(), (Object)facet) == -1;
    }

    @NotNull
    public Facet[] getAllFacets() {
        Facet[] facetArray = this.myFacets.toArray(Facet.EMPTY_ARRAY);
        if (facetArray == null) {
            FacetModelImpl.$$$reportNull$$$0(0);
        }
        return facetArray;
    }

    @Override
    @NotNull
    public String getFacetName(@NotNull Facet facet) {
        if (facet == null) {
            FacetModelImpl.$$$reportNull$$$0(1);
        }
        String string = this.myFacet2NewName.containsKey(facet) ? this.myFacet2NewName.get(facet) : facet.getName();
        if (string == null) {
            FacetModelImpl.$$$reportNull$$$0(2);
        }
        return string;
    }

    public void addListener(@NotNull ModifiableFacetModel.Listener listener2, @NotNull Disposable parentDisposable) {
        if (listener2 == null) {
            FacetModelImpl.$$$reportNull$$$0(3);
        }
        if (parentDisposable == null) {
            FacetModelImpl.$$$reportNull$$$0(4);
        }
        this.myListeners.add(listener2);
        Disposer.register((Disposable)parentDisposable, () -> {
            if (listener2 == null) {
                FacetModelImpl.$$$reportNull$$$0(5);
            }
            this.myListeners.remove(listener2);
        });
    }

    @Override
    protected void facetsChanged() {
        super.facetsChanged();
        for (ModifiableFacetModel.Listener each : this.myListeners) {
            each.onChanged();
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/facet/impl/FacetModelImpl";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "facet";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentDisposable";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllFacets";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/facet/impl/FacetModelImpl";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getFacetName";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getFacetName";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "addListener";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "lambda$addListener$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

