/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.bookmarks.actions;

import com.intellij.ide.bookmarks.Bookmark;
import com.intellij.ide.bookmarks.BookmarkManager;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.editor.actionSystem.EditorAction;
import com.intellij.openapi.editor.actionSystem.EditorActionHandler;
import com.intellij.openapi.project.Project;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

abstract class GotoBookmarkActionBase
extends EditorAction {
    protected GotoBookmarkActionBase(final boolean next) {
        super(new EditorActionHandler(){

            public void execute(@NotNull Editor editor, DataContext dataContext) {
                if (editor == null) {
                    1.$$$reportNull$$$0(0);
                }
                this.navigateToBookmark(dataContext, editor);
            }

            public boolean isEnabled(Editor editor, DataContext dataContext) {
                return this.getBookmarkToGo(dataContext, editor) != null;
            }

            private void navigateToBookmark(DataContext dataContext, @NotNull Editor editor) {
                Bookmark bookmark;
                if (editor == null) {
                    1.$$$reportNull$$$0(1);
                }
                if ((bookmark = this.getBookmarkToGo(dataContext, editor)) == null) {
                    return;
                }
                int line = bookmark.getLine();
                if (line >= editor.getDocument().getLineCount()) {
                    return;
                }
                if (line < 0) {
                    line = 0;
                }
                LogicalPosition pos = new LogicalPosition(line, 0);
                editor.getSelectionModel().removeSelection();
                editor.getCaretModel().removeSecondaryCarets();
                editor.getCaretModel().moveToLogicalPosition(pos);
                editor.getScrollingModel().scrollTo(new LogicalPosition(line, 0), ScrollType.CENTER);
            }

            @Nullable
            private Bookmark getBookmarkToGo(DataContext dataContext, @NotNull Editor editor) {
                Project project;
                if (editor == null) {
                    1.$$$reportNull$$$0(2);
                }
                if ((project = (Project)CommonDataKeys.PROJECT.getData(dataContext)) == null) {
                    return null;
                }
                return BookmarkManager.getInstance(project).findLineBookmark(editor, true, next);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "editor";
                objectArray2[1] = "com/intellij/ide/bookmarks/actions/GotoBookmarkActionBase$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "execute";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "navigateToBookmark";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "getBookmarkToGo";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
    }
}

