/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.ui.laf.darcula.ui;

import com.intellij.ide.ui.laf.VisualPaddingsProvider;
import com.intellij.ide.ui.laf.darcula.DarculaUIUtil;
import com.intellij.ide.ui.laf.darcula.ui.DarculaTextBorder;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.ex.FocusChangeListener;
import com.intellij.ui.EditorTextField;
import com.intellij.util.ui.JBInsets;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.MacUIUtil;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.Path2D;
import java.awt.geom.Rectangle2D;
import javax.swing.JComboBox;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DarculaEditorTextFieldBorder
extends DarculaTextBorder
implements VisualPaddingsProvider {
    public DarculaEditorTextFieldBorder() {
        this(null, null);
    }

    public DarculaEditorTextFieldBorder(final EditorTextField editorTextField, EditorEx editor) {
        if (editorTextField != null && editor != null) {
            editor.addFocusListener(new FocusChangeListener(){

                @Override
                public void focusGained(@NotNull Editor editor) {
                    if (editor == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    editorTextField.repaint();
                }

                @Override
                public void focusLost(@NotNull Editor editor) {
                    if (editor == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    editorTextField.repaint();
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2 = new Object[3];
                    objectArray2[0] = "editor";
                    objectArray2[1] = "com/intellij/ide/ui/laf/darcula/ui/DarculaEditorTextFieldBorder$1";
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[2] = "focusGained";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[2] = "focusLost";
                            break;
                        }
                    }
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
        if (DarculaEditorTextFieldBorder.isComboBoxEditor(c)) {
            g.setColor(c.getBackground());
            g.fillRect(x, y, width, height);
            return;
        }
        EditorTextField editorTextField = (EditorTextField)UIUtil.getParentOfType(EditorTextField.class, (Component)c);
        if (editorTextField == null) {
            return;
        }
        boolean hasFocus = editorTextField.getFocusTarget().hasFocus();
        Rectangle r = new Rectangle(x, y, width, height);
        if (DarculaUIUtil.isTableCellEditor(c)) {
            DarculaUIUtil.paintCellEditorBorder((Graphics2D)g, c, r, hasFocus);
        } else {
            Graphics2D g2 = (Graphics2D)g.create();
            try {
                g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                g2.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, MacUIUtil.USE_QUARTZ ? RenderingHints.VALUE_STROKE_PURE : RenderingHints.VALUE_STROKE_NORMALIZE);
                if (c.isOpaque()) {
                    g2.setColor(UIUtil.getPanelBackground());
                    g2.fill(r);
                }
                JBInsets.removeFrom((Rectangle)r, (Insets)JBUI.insets((int)1));
                g2.translate(r.x, r.y);
                float lw = this.lw(g2);
                float bw = this.bw();
                Rectangle2D.Float outer = new Rectangle2D.Float(bw, bw, (float)r.width - bw * 2.0f, (float)r.height - bw * 2.0f);
                g2.setColor(c.getBackground());
                g2.fill(outer);
                Object op = editorTextField.getClientProperty("JComponent.outline");
                if (editorTextField.isEnabled() && op != null) {
                    DarculaUIUtil.paintOutlineBorder(g2, r.width, r.height, 0.0f, true, hasFocus, DarculaUIUtil.Outline.valueOf(op.toString()));
                } else if (editorTextField.isEnabled() && editorTextField.isVisible() && hasFocus) {
                    DarculaUIUtil.paintOutlineBorder(g2, r.width, r.height, 0.0f, true, true, DarculaUIUtil.Outline.focus);
                }
                Path2D.Float border = new Path2D.Float(0);
                border.append(outer, false);
                border.append(new Rectangle2D.Float(bw + lw, bw + lw, (float)r.width - (bw + lw) * 2.0f, (float)r.height - (bw + lw) * 2.0f), false);
                g2.setColor(this.getOutlineColor(editorTextField.isEnabled(), hasFocus));
                g2.fill(border);
            }
            finally {
                g2.dispose();
            }
        }
    }

    @Override
    public Insets getBorderInsets(Component c) {
        return DarculaUIUtil.isTableCellEditor(c) || DarculaUIUtil.isCompact(c) ? JBUI.insets((int)2).asUIResource() : (DarculaEditorTextFieldBorder.isComboBoxEditor(c) ? JBUI.insets((int)2, (int)3).asUIResource() : JBUI.insets((int)6, (int)8).asUIResource());
    }

    @Override
    public boolean isBorderOpaque() {
        return true;
    }

    public static boolean isComboBoxEditor(Component c) {
        return UIUtil.getParentOfType(JComboBox.class, (Component)c) != null;
    }

    @Override
    @Nullable
    public Insets getVisualPaddings(@NotNull Component component) {
        if (component == null) {
            DarculaEditorTextFieldBorder.$$$reportNull$$$0(0);
        }
        return JBUI.insets((int)3);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/intellij/ide/ui/laf/darcula/ui/DarculaEditorTextFieldBorder", "getVisualPaddings"));
    }
}

