/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.ui.laf.darcula.ui;

import com.intellij.icons.AllIcons;
import com.intellij.ide.DataManager;
import com.intellij.ide.ui.laf.darcula.ui.DarculaRootPaneUI;
import com.intellij.ide.ui.laf.darcula.ui.customFrameDecorations.DarculaTitleButtons;
import com.intellij.ide.ui.laf.darcula.ui.customFrameDecorations.HelpAction;
import com.intellij.ide.ui.laf.darcula.ui.customFrameDecorations.ResizableDarculaTitleButtons;
import com.intellij.openapi.actionSystem.ex.ActionManagerEx;
import com.intellij.openapi.wm.impl.IdeMenuBar;
import com.intellij.openapi.wm.impl.IdeRootPane;
import com.intellij.ui.JBColor;
import com.intellij.ui.SideBorder;
import com.intellij.util.ui.JBUI;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.LayoutManager;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.JSeparator;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.plaf.UIResource;
import net.miginfocom.swing.MigLayout;

public class DarculaTitlePane
extends JPanel {
    private static final Icon mySystemIcon = AllIcons.Icon_small;
    private PropertyChangeListener myPropertyChangeListener;
    private JMenuBar myMenuBar;
    private JMenuBar myIdeMenu;
    private Action myCloseAction;
    private Action myIconifyAction;
    private Action myRestoreAction;
    private Action myMaximizeAction;
    private HelpAction myHelpAction;
    private WindowListener myWindowListener;
    private Window myWindow;
    private final JRootPane myRootPane;
    private int myState;
    private final DarculaRootPaneUI rootPaneUI;
    private DarculaTitleButtons buttonPanes;
    private final JLabel titleLabel = new JLabel();
    private final Color myInactiveBackground = UIManager.getColor("inactiveCaption");
    private final Color myInactiveForeground = UIManager.getColor("inactiveCaptionText");
    private final Color myInactiveShadow = UIManager.getColor("inactiveCaptionBorder");
    private Color myActiveBackground = null;
    private Color myActiveForeground = null;
    private Color myActiveShadow = null;

    public DarculaTitlePane(JRootPane root, DarculaRootPaneUI ui) {
        this.myRootPane = root;
        this.rootPaneUI = ui;
        this.myState = -1;
        this.installSubcomponents();
        this.determineColors();
        this.installDefaults();
        this.setOpaque(true);
        this.setBackground(JBUI.CurrentTheme.CustomFrameDecorations.titlePaneBackground());
        this.setBorder((Border)new SideBorder(JBUI.CurrentTheme.CustomFrameDecorations.separatorForeground(), 8, JBUI.scale((int)2)));
    }

    private void uninstall() {
        this.uninstallListeners();
        this.myWindow = null;
        this.removeAll();
    }

    private void installListeners() {
        if (this.myWindow != null) {
            this.myWindowListener = this.createWindowListener();
            this.myWindow.addWindowListener(this.myWindowListener);
            this.myPropertyChangeListener = this.createWindowPropertyChangeListener();
            this.myWindow.addPropertyChangeListener(this.myPropertyChangeListener);
        }
    }

    private void uninstallListeners() {
        if (this.myWindow != null) {
            this.myWindow.removeWindowListener(this.myWindowListener);
            this.myWindow.removePropertyChangeListener(this.myPropertyChangeListener);
        }
    }

    private WindowListener createWindowListener() {
        return new WindowHandler();
    }

    private PropertyChangeListener createWindowPropertyChangeListener() {
        return new PropertyChangeHandler();
    }

    @Override
    public JRootPane getRootPane() {
        return this.myRootPane;
    }

    private int getWindowDecorationStyle() {
        return this.getRootPane().getWindowDecorationStyle();
    }

    @Override
    public void addNotify() {
        super.addNotify();
        this.uninstallListeners();
        this.myWindow = SwingUtilities.getWindowAncestor(this);
        if (this.myWindow != null) {
            if (this.myWindow instanceof Frame) {
                this.setState(((Frame)this.myWindow).getExtendedState());
            } else {
                this.setState(0);
            }
            this.installListeners();
        }
    }

    @Override
    public void removeNotify() {
        super.removeNotify();
        this.uninstallListeners();
        this.myWindow = null;
    }

    private void installSubcomponents() {
        int decorationStyle = this.getWindowDecorationStyle();
        if (decorationStyle == 1) {
            this.setLayout((LayoutManager)new MigLayout("fill, ins 0, gap 0", JBUI.scale((int)7) + "[pref!]" + JBUI.scale((int)9) + "[pref!]push[pref!]"));
            this.createActions();
            this.buttonPanes = ResizableDarculaTitleButtons.Companion.create(this.myCloseAction, this.myRestoreAction, this.myIconifyAction, this.myMaximizeAction, this.myHelpAction);
            this.myMenuBar = this.createMenuBar();
            this.add(this.myMenuBar);
            if (this.myRootPane instanceof IdeRootPane) {
                this.myIdeMenu = new IdeMenuBar(ActionManagerEx.getInstanceEx(), DataManager.getInstance());
                this.add(this.myIdeMenu);
            } else {
                this.add((Component)this.titleLabel, "growx");
            }
            this.add(this.buttonPanes.getView());
        } else if (decorationStyle == 2 || decorationStyle == 3 || decorationStyle == 4 || decorationStyle == 5 || decorationStyle == 6 || decorationStyle == 7 || decorationStyle == 8) {
            this.setLayout((LayoutManager)new MigLayout("fill, ins 0, gap 0", JBUI.scale((int)7) + "[pref!]push[pref!]"));
            this.createActions();
            this.add((Component)this.titleLabel, "growx");
            this.buttonPanes = DarculaTitleButtons.Companion.create(this.myCloseAction, this.myHelpAction);
            this.add(this.buttonPanes.getView());
        }
    }

    private void determineColors() {
        switch (this.getWindowDecorationStyle()) {
            case 1: {
                this.myActiveBackground = UIManager.getColor("activeCaption");
                this.myActiveForeground = UIManager.getColor("activeCaptionText");
                this.myActiveShadow = UIManager.getColor("activeCaptionBorder");
                break;
            }
            case 4: {
                this.myActiveBackground = new Color(43, 43, 43);
                this.myActiveForeground = UIManager.getColor("OptionPane.errorDialog.titlePane.foreground");
                this.myActiveShadow = UIManager.getColor("OptionPane.errorDialog.titlePane.shadow");
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                this.myActiveBackground = new Color(43, 43, 43);
                this.myActiveForeground = UIManager.getColor("OptionPane.questionDialog.titlePane.foreground");
                this.myActiveShadow = UIManager.getColor("OptionPane.questionDialog.titlePane.shadow");
                break;
            }
            case 8: {
                this.myActiveBackground = new Color(43, 43, 43);
                this.myActiveForeground = UIManager.getColor("OptionPane.warningDialog.titlePane.foreground");
                this.myActiveShadow = UIManager.getColor("OptionPane.warningDialog.titlePane.shadow");
                break;
            }
            default: {
                this.myActiveBackground = new Color(43, 43, 43);
                this.myActiveForeground = UIManager.getColor("activeCaptionText");
                this.myActiveShadow = UIManager.getColor("activeCaptionBorder");
            }
        }
        this.myActiveBackground = new Color(43, 43, 43);
        this.myActiveForeground = JBColor.foreground();
        this.myActiveShadow = UIManager.getColor("activeCaptionBorder");
    }

    private void installDefaults() {
        this.setFont((Font)JBUI.Fonts.label().asBold());
    }

    protected JMenuBar createMenuBar() {
        this.myMenuBar = new JMenuBar(){

            @Override
            public Dimension getPreferredSize() {
                return new Dimension(mySystemIcon.getIconWidth(), mySystemIcon.getIconHeight());
            }

            @Override
            public void paint(Graphics g) {
                mySystemIcon.paintIcon(this, g, 0, 0);
            }
        };
        JMenu menu = new JMenu();
        this.myMenuBar.add(menu);
        this.myMenuBar.setOpaque(false);
        menu.setFocusable(false);
        menu.setBorderPainted(true);
        if (this.getWindowDecorationStyle() == 1) {
            this.addMenuItems(menu);
        }
        return this.myMenuBar;
    }

    private void close() {
        Window window = this.getWindow();
        if (window != null) {
            window.dispatchEvent(new WindowEvent(window, 201));
        }
    }

    private void iconify() {
        Frame frame = this.getFrame();
        if (frame != null) {
            frame.setExtendedState(this.myState | 1);
        }
    }

    private void maximize() {
        Frame frame = this.getFrame();
        if (frame != null) {
            frame.setExtendedState(this.myState | 6);
        }
    }

    private void restore() {
        Frame frame = this.getFrame();
        if (frame == null) {
            return;
        }
        if ((this.myState & 1) != 0) {
            frame.setExtendedState(this.myState & 0xFFFFFFFE);
        } else {
            frame.setExtendedState(this.myState & 0xFFFFFFF9);
        }
    }

    private void createActions() {
        this.myCloseAction = new CloseAction();
        this.myHelpAction = new HelpAction(this);
        if (this.getWindowDecorationStyle() == 1) {
            this.myIconifyAction = new IconifyAction();
            this.myRestoreAction = new RestoreAction();
            this.myMaximizeAction = new MaximizeAction();
        }
    }

    private JMenu createMenu() {
        JMenu menu = new JMenu("");
        if (this.getWindowDecorationStyle() == 1) {
            this.addMenuItems(menu);
        }
        return menu;
    }

    private void addMenuItems(JMenu menu) {
        menu.add(this.myRestoreAction);
        menu.add(this.myIconifyAction);
        if (Toolkit.getDefaultToolkit().isFrameStateSupported(6)) {
            menu.add(this.myMaximizeAction);
        }
        menu.add(new JSeparator());
        JMenuItem closeMenuItem = menu.add(this.myCloseAction);
        closeMenuItem.setFont(this.getFont().deriveFont(1));
    }

    @Override
    protected void paintComponent(Graphics g) {
        if (this.getFrame() != null) {
            this.setState(this.getFrame().getExtendedState());
        }
        super.paintComponent(g);
    }

    private void setState(int state) {
        this.setState(state, false);
    }

    private void setState(int state, boolean updateRegardless) {
        Window wnd = this.getWindow();
        this.titleLabel.setText(this.getTitle());
        if (wnd != null && this.getWindowDecorationStyle() == 1) {
            if (this.myState == state && !updateRegardless) {
                return;
            }
            Frame frame = this.getFrame();
            if (frame != null) {
                JRootPane rootPane = this.getRootPane();
                if ((state & 6) != 0 && (rootPane.getBorder() == null || rootPane.getBorder() instanceof UIResource) && frame.isShowing()) {
                    rootPane.setBorder(null);
                } else if ((state & 6) == 0) {
                    this.rootPaneUI.installBorder(rootPane);
                }
                if (frame.isResizable()) {
                    if ((state & 6) != 0) {
                        this.myMaximizeAction.setEnabled(false);
                        this.myRestoreAction.setEnabled(true);
                    } else {
                        this.myMaximizeAction.setEnabled(true);
                        this.myRestoreAction.setEnabled(false);
                    }
                } else {
                    this.myMaximizeAction.setEnabled(false);
                    this.myRestoreAction.setEnabled(false);
                }
            } else {
                this.myMaximizeAction.setEnabled(false);
                this.myRestoreAction.setEnabled(false);
                this.myIconifyAction.setEnabled(false);
            }
            this.myCloseAction.setEnabled(true);
            this.myState = state;
        }
        if (this.buttonPanes != null) {
            this.buttonPanes.updateVisibility();
        }
    }

    private void setActive(boolean isSelected) {
        this.buttonPanes.setSelected(isSelected);
        this.titleLabel.setForeground(isSelected ? this.myActiveForeground : this.myInactiveForeground);
    }

    private Frame getFrame() {
        Window window = this.getWindow();
        if (window instanceof Frame) {
            return (Frame)window;
        }
        return null;
    }

    private Window getWindow() {
        return this.myWindow;
    }

    private String getTitle() {
        Window w = this.getWindow();
        if (w instanceof Frame) {
            return ((Frame)w).getTitle();
        }
        if (w instanceof Dialog) {
            return ((Dialog)w).getTitle();
        }
        return null;
    }

    private class WindowHandler
    extends WindowAdapter {
        private WindowHandler() {
        }

        @Override
        public void windowActivated(WindowEvent ev) {
            DarculaTitlePane.this.setActive(true);
        }

        @Override
        public void windowDeactivated(WindowEvent ev) {
            DarculaTitlePane.this.setActive(false);
        }
    }

    private class PropertyChangeHandler
    implements PropertyChangeListener {
        private PropertyChangeHandler() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent pce) {
            String name = pce.getPropertyName();
            if ("resizable".equals(name) || "state".equals(name)) {
                Frame frame = DarculaTitlePane.this.getFrame();
                if (frame != null) {
                    DarculaTitlePane.this.setState(frame.getExtendedState(), true);
                }
                if ("resizable".equals(name)) {
                    DarculaTitlePane.this.getRootPane().repaint();
                }
            } else if ("title".equals(name)) {
                DarculaTitlePane.this.repaint();
            } else if ("componentOrientation" == name) {
                DarculaTitlePane.this.revalidate();
                DarculaTitlePane.this.repaint();
            }
        }
    }

    private class MaximizeAction
    extends AbstractAction {
        MaximizeAction() {
            super("Maximize", AllIcons.Windows.MaximizeSmall);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            DarculaTitlePane.this.maximize();
        }
    }

    private class RestoreAction
    extends AbstractAction {
        RestoreAction() {
            super("Restore", AllIcons.Windows.RestoreSmall);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            DarculaTitlePane.this.restore();
        }
    }

    private class IconifyAction
    extends AbstractAction {
        IconifyAction() {
            super("Minimize", AllIcons.Windows.MinimizeSmall);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            DarculaTitlePane.this.iconify();
        }
    }

    private class CloseAction
    extends AbstractAction {
        CloseAction() {
            super("Close", AllIcons.Windows.CloseSmall);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            DarculaTitlePane.this.close();
        }
    }
}

