/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.diff.impl.incrementalMerge;

import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.TextRange;
import com.intellij.util.containers.ContainerUtil;
import java.util.Iterator;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class DiffRangeMarker
implements RangeMarker {
    private final RangeMarker myRangeMarker;

    DiffRangeMarker(@NotNull Document document, @NotNull TextRange range2, RangeInvalidListener listener2) {
        if (document == null) {
            DiffRangeMarker.$$$reportNull$$$0(0);
        }
        if (range2 == null) {
            DiffRangeMarker.$$$reportNull$$$0(1);
        }
        this.myRangeMarker = document.createRangeMarker(range2.getStartOffset(), range2.getEndOffset());
        if (listener2 != null) {
            InvalidRangeDispatcher.addClient(document, this, listener2);
        }
    }

    public void removeListener(@NotNull RangeInvalidListener listener2) {
        if (listener2 == null) {
            DiffRangeMarker.$$$reportNull$$$0(2);
        }
        InvalidRangeDispatcher.removeClient(this.getDocument(), this, listener2);
    }

    @NotNull
    public Document getDocument() {
        Document document = this.myRangeMarker.getDocument();
        if (document == null) {
            DiffRangeMarker.$$$reportNull$$$0(3);
        }
        return document;
    }

    public int getStartOffset() {
        return this.myRangeMarker.getStartOffset();
    }

    public int getEndOffset() {
        return this.myRangeMarker.getEndOffset();
    }

    public boolean isValid() {
        return this.myRangeMarker.isValid();
    }

    public void setGreedyToLeft(boolean greedy) {
        this.myRangeMarker.setGreedyToLeft(greedy);
    }

    public void setGreedyToRight(boolean greedy) {
        this.myRangeMarker.setGreedyToRight(greedy);
    }

    public boolean isGreedyToRight() {
        return this.myRangeMarker.isGreedyToRight();
    }

    public boolean isGreedyToLeft() {
        return this.myRangeMarker.isGreedyToLeft();
    }

    public void dispose() {
        this.myRangeMarker.dispose();
    }

    @Nullable
    public <T> T getUserData(@NotNull Key<T> key) {
        if (key == null) {
            DiffRangeMarker.$$$reportNull$$$0(4);
        }
        return (T)this.myRangeMarker.getUserData(key);
    }

    public <T> void putUserData(@NotNull Key<T> key, @Nullable T value) {
        if (key == null) {
            DiffRangeMarker.$$$reportNull$$$0(5);
        }
        this.myRangeMarker.putUserData(key, value);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "range";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/diff/impl/incrementalMerge/DiffRangeMarker";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/diff/impl/incrementalMerge/DiffRangeMarker";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getDocument";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "removeListener";
                break;
            }
            case 3: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getUserData";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "putUserData";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class InvalidRangeDispatcher
    implements DocumentListener {
        private static final Key<InvalidRangeDispatcher> KEY = Key.create((String)"deferedNotifier");
        private final Map<DiffRangeMarker, RangeInvalidListener> myDiffRangeMarkers = ContainerUtil.newConcurrentMap();

        private InvalidRangeDispatcher() {
        }

        public void documentChanged(@NotNull DocumentEvent e) {
            if (e == null) {
                InvalidRangeDispatcher.$$$reportNull$$$0(0);
            }
            Iterator<Map.Entry<DiffRangeMarker, RangeInvalidListener>> iterator = this.myDiffRangeMarkers.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<DiffRangeMarker, RangeInvalidListener> entry = iterator.next();
                DiffRangeMarker diffRangeMarker = entry.getKey();
                RangeInvalidListener listener2 = entry.getValue();
                if (diffRangeMarker.isValid() || listener2 == null) continue;
                listener2.onRangeInvalidated();
                iterator.remove();
            }
        }

        private static void addClient(@NotNull Document document, @NotNull DiffRangeMarker marker, @NotNull RangeInvalidListener listener2) {
            InvalidRangeDispatcher notifier;
            if (document == null) {
                InvalidRangeDispatcher.$$$reportNull$$$0(1);
            }
            if (marker == null) {
                InvalidRangeDispatcher.$$$reportNull$$$0(2);
            }
            if (listener2 == null) {
                InvalidRangeDispatcher.$$$reportNull$$$0(3);
            }
            if ((notifier = (InvalidRangeDispatcher)document.getUserData(KEY)) == null) {
                notifier = new InvalidRangeDispatcher();
                document.putUserData(KEY, (Object)notifier);
                document.addDocumentListener((DocumentListener)notifier);
            }
            assert (!notifier.myDiffRangeMarkers.containsKey(marker));
            notifier.myDiffRangeMarkers.put(marker, listener2);
        }

        private static void removeClient(@NotNull Document document, @NotNull DiffRangeMarker marker, @NotNull RangeInvalidListener listener2) {
            if (document == null) {
                InvalidRangeDispatcher.$$$reportNull$$$0(4);
            }
            if (marker == null) {
                InvalidRangeDispatcher.$$$reportNull$$$0(5);
            }
            if (listener2 == null) {
                InvalidRangeDispatcher.$$$reportNull$$$0(6);
            }
            InvalidRangeDispatcher notifier = (InvalidRangeDispatcher)document.getUserData(KEY);
            assert (notifier != null);
            notifier.onClientRemoved(document, marker, listener2);
        }

        private void onClientRemoved(@NotNull Document document, @NotNull DiffRangeMarker marker, @NotNull RangeInvalidListener listener2) {
            if (document == null) {
                InvalidRangeDispatcher.$$$reportNull$$$0(7);
            }
            if (marker == null) {
                InvalidRangeDispatcher.$$$reportNull$$$0(8);
            }
            if (listener2 == null) {
                InvalidRangeDispatcher.$$$reportNull$$$0(9);
            }
            if (this.myDiffRangeMarkers.remove(marker) == listener2 && this.myDiffRangeMarkers.isEmpty()) {
                document.putUserData(KEY, null);
                document.removeDocumentListener((DocumentListener)this);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
                case 1: 
                case 4: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "document";
                    break;
                }
                case 2: 
                case 5: 
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "marker";
                    break;
                }
                case 3: 
                case 6: 
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "listener";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/openapi/diff/impl/incrementalMerge/DiffRangeMarker$InvalidRangeDispatcher";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "documentChanged";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "addClient";
                    break;
                }
                case 4: 
                case 5: 
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[2] = "removeClient";
                    break;
                }
                case 7: 
                case 8: 
                case 9: {
                    objectArray = objectArray2;
                    objectArray2[2] = "onClientRemoved";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    static interface RangeInvalidListener {
        public void onRangeInvalidated();
    }
}

