/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.impl.softwrap.mapping;

import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.FoldRegion;
import com.intellij.openapi.editor.LogicalPosition;
import org.jetbrains.annotations.NotNull;

class EditorPosition
implements Cloneable {
    int logicalLine;
    int offset;
    int x;
    private final Editor myEditor;

    private EditorPosition(@NotNull Editor editor) {
        if (editor == null) {
            EditorPosition.$$$reportNull$$$0(0);
        }
        this.myEditor = editor;
    }

    EditorPosition(@NotNull LogicalPosition logical, int offset, @NotNull Editor editor) {
        if (logical == null) {
            EditorPosition.$$$reportNull$$$0(1);
        }
        if (editor == null) {
            EditorPosition.$$$reportNull$$$0(2);
        }
        this.myEditor = editor;
        this.logicalLine = logical.line;
        this.offset = offset;
    }

    void onNewLine() {
        ++this.logicalLine;
        this.x = 0;
        ++this.offset;
    }

    public void advance(@NotNull FoldRegion foldRegion) {
        if (foldRegion == null) {
            EditorPosition.$$$reportNull$$$0(3);
        }
        this.offset = foldRegion.getEndOffset();
        Document document = this.myEditor.getDocument();
        int endOffsetLogicalLine = document.getLineNumber(foldRegion.getEndOffset());
        if (this.logicalLine != endOffsetLogicalLine) {
            int linesDiff = endOffsetLogicalLine - this.logicalLine;
            this.logicalLine += linesDiff;
        }
    }

    public void from(@NotNull EditorPosition position) {
        if (position == null) {
            EditorPosition.$$$reportNull$$$0(4);
        }
        this.logicalLine = position.logicalLine;
        this.offset = position.offset;
        this.x = position.x;
    }

    protected EditorPosition clone() {
        EditorPosition result2 = new EditorPosition(this.myEditor);
        result2.logicalLine = this.logicalLine;
        result2.offset = this.offset;
        result2.x = this.x;
        return result2;
    }

    public String toString() {
        return String.format("logical line: %d; offset: %d", this.logicalLine, this.offset);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "logical";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "foldRegion";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "position";
                break;
            }
        }
        objectArray2[1] = "com/intellij/openapi/editor/impl/softwrap/mapping/EditorPosition";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "advance";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "from";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

