/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.issueLinks;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.IssueNavigationConfiguration;
import com.intellij.util.containers.Convertor;
import com.intellij.util.ui.UIUtil;
import com.intellij.xml.util.XmlStringUtil;
import java.awt.Font;
import java.util.List;

public class IssueLinkHtmlRenderer {
    private IssueLinkHtmlRenderer() {
    }

    public static String formatTextIntoHtml(Project project, String c) {
        return "<html><head>" + UIUtil.getCssFontDeclaration((Font)UIUtil.getLabelFont()) + "</head><body>" + IssueLinkHtmlRenderer.formatTextWithLinks(project, c) + "</body></html>";
    }

    public static String formatTextWithLinks(Project project, String str, Convertor<? super String, String> convertor) {
        if (StringUtil.isEmpty((String)str)) {
            return "";
        }
        String comment = XmlStringUtil.escapeString((String)str, (boolean)false);
        StringBuilder commentBuilder = new StringBuilder();
        IssueNavigationConfiguration config2 = IssueNavigationConfiguration.getInstance((Project)project);
        List list2 = config2.findIssueLinks((CharSequence)comment);
        int pos = 0;
        for (IssueNavigationConfiguration.LinkMatch match : list2) {
            TextRange range2 = match.getRange();
            commentBuilder.append((String)convertor.convert((Object)comment.substring(pos, range2.getStartOffset()))).append("<a href=\"").append(match.getTargetUrl()).append("\">");
            commentBuilder.append(range2.substring(comment)).append("</a>");
            pos = range2.getEndOffset();
        }
        commentBuilder.append((String)convertor.convert((Object)comment.substring(pos)));
        comment = commentBuilder.toString();
        return comment.replace("\n", "<br>");
    }

    public static String formatTextWithLinks(Project project, String c) {
        return IssueLinkHtmlRenderer.formatTextWithLinks(project, c, (Convertor<? super String, String>)Convertor.SELF);
    }
}

