/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.wm.impl.status;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.ListPopup;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileListener;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.VirtualFilePropertyEvent;
import com.intellij.openapi.vfs.encoding.ChangeFileEncodingAction;
import com.intellij.openapi.vfs.encoding.EncodingManager;
import com.intellij.openapi.vfs.encoding.EncodingUtil;
import com.intellij.openapi.vfs.impl.BulkVirtualFileListenerAdapter;
import com.intellij.openapi.wm.StatusBarWidget;
import com.intellij.openapi.wm.impl.status.EditorBasedStatusBarPopup;
import com.intellij.util.ObjectUtils;
import java.nio.charset.Charset;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EncodingPanel
extends EditorBasedStatusBarPopup {
    public EncodingPanel(@NotNull Project project) {
        if (project == null) {
            EncodingPanel.$$$reportNull$$$0(0);
        }
        super(project);
    }

    @Override
    @NotNull
    protected EditorBasedStatusBarPopup.WidgetState getWidgetState(@Nullable VirtualFile file2) {
        if (file2 == null) {
            EditorBasedStatusBarPopup.WidgetState widgetState = EditorBasedStatusBarPopup.WidgetState.HIDDEN;
            if (widgetState == null) {
                EncodingPanel.$$$reportNull$$$0(1);
            }
            return widgetState;
        }
        Pair<Charset, String> check = EncodingUtil.getCharsetAndTheReasonTooltip(file2);
        String failReason = (String)Pair.getSecond(check);
        Charset charset = (Charset)ObjectUtils.notNull((Object)Pair.getFirst(check), (Object)file2.getCharset());
        String charsetName = (String)ObjectUtils.notNull((Object)charset.displayName(), (Object)"n/a");
        String toolTipText = failReason == null ? "File Encoding: " + charsetName : StringUtil.capitalize((String)failReason) + ".";
        EditorBasedStatusBarPopup.WidgetState widgetState = new EditorBasedStatusBarPopup.WidgetState(toolTipText, charsetName, failReason == null);
        if (widgetState == null) {
            EncodingPanel.$$$reportNull$$$0(2);
        }
        return widgetState;
    }

    @Override
    @Nullable
    protected ListPopup createPopup(DataContext context) {
        return new ChangeFileEncodingAction().createPopup(context);
    }

    @Override
    protected void registerCustomListeners() {
        EncodingManager.getInstance().addPropertyChangeListener(evt -> {
            if (evt.getPropertyName().equals("cachedEncoding")) {
                Document document = evt.getSource() instanceof Document ? (Document)evt.getSource() : null;
                this.updateForDocument(document);
            }
        }, (Disposable)this);
        ApplicationManager.getApplication().getMessageBus().connect((Disposable)this).subscribe(VirtualFileManager.VFS_CHANGES, (Object)new BulkVirtualFileListenerAdapter(new VirtualFileListener(){

            public void propertyChanged(@NotNull VirtualFilePropertyEvent event) {
                if (event == null) {
                    1.$$$reportNull$$$0(0);
                }
                if ("encoding".equals(event.getPropertyName())) {
                    EncodingPanel.this.updateForFile(event.getFile());
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/openapi/wm/impl/status/EncodingPanel$1", "propertyChanged"));
            }
        }));
    }

    @Override
    @NotNull
    protected StatusBarWidget createInstance(Project project) {
        EncodingPanel encodingPanel = new EncodingPanel(project);
        if (encodingPanel == null) {
            EncodingPanel.$$$reportNull$$$0(3);
        }
        return encodingPanel;
    }

    @NotNull
    public String ID() {
        if ("Encoding" == null) {
            EncodingPanel.$$$reportNull$$$0(4);
        }
        return "Encoding";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/wm/impl/status/EncodingPanel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/wm/impl/status/EncodingPanel";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getWidgetState";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createInstance";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "ID";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

