/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.wm.impl.status;

import com.intellij.ide.ui.UISettings;
import com.intellij.ide.ui.UISettingsListener;
import com.intellij.openapi.wm.CustomStatusBarWidget;
import com.intellij.openapi.wm.StatusBar;
import com.intellij.openapi.wm.StatusBarWidget;
import com.intellij.ui.Gray;
import com.intellij.ui.JBColor;
import com.intellij.ui.UIBundle;
import com.intellij.util.concurrency.EdtExecutorService;
import com.intellij.util.ui.JBSwingUtilities;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.update.Activatable;
import com.intellij.util.ui.update.UiNotifyConnector;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.image.BufferedImage;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import javax.swing.JButton;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MemoryUsagePanel
extends JButton
implements CustomStatusBarWidget,
UISettingsListener,
Activatable {
    public static final String WIDGET_ID = "Memory";
    private static final Color USED_COLOR = new JBColor((Color)Gray._185, (Color)Gray._110);
    private static final Color UNUSED_COLOR = new JBColor((Color)Gray._215, (Color)Gray._90);
    private final String mySample;
    private long myLastAllocated = -1L;
    private long myLastUsed = -1L;
    private BufferedImage myBufferedImage;
    private boolean myWasPressed;
    private ScheduledFuture<?> myFuture;

    public MemoryUsagePanel() {
        long max = Math.min(Runtime.getRuntime().maxMemory() / 0x100000L, 9999L);
        this.mySample = UIBundle.message((String)"memory.usage.panel.message.text", (Object[])new Object[]{max, max});
        this.setOpaque(false);
        this.setFocusable(false);
        this.addActionListener(e -> {
            System.gc();
            this.updateState();
        });
        this.setBorder(StatusBarWidget.WidgetBorder.INSTANCE);
        this.updateUI();
        new UiNotifyConnector((Component)this, (Activatable)this);
    }

    public void showNotify() {
        this.myFuture = EdtExecutorService.getScheduledExecutorInstance().scheduleWithFixedDelay(this::updateState, 1L, 5L, TimeUnit.SECONDS);
    }

    public void hideNotify() {
        if (this.myFuture != null) {
            this.myFuture.cancel(true);
            this.myFuture = null;
        }
    }

    public void dispose() {
    }

    public void install(@NotNull StatusBar statusBar) {
        if (statusBar == null) {
            MemoryUsagePanel.$$$reportNull$$$0(0);
        }
    }

    @Nullable
    public StatusBarWidget.WidgetPresentation getPresentation(@NotNull StatusBarWidget.PlatformType type) {
        if (type == null) {
            MemoryUsagePanel.$$$reportNull$$$0(1);
        }
        return null;
    }

    @NotNull
    public String ID() {
        if (WIDGET_ID == null) {
            MemoryUsagePanel.$$$reportNull$$$0(2);
        }
        return WIDGET_ID;
    }

    public void setShowing(boolean showing) {
        if (showing != this.isVisible()) {
            this.setVisible(showing);
            this.revalidate();
        }
    }

    @Override
    public void updateUI() {
        this.myBufferedImage = null;
        super.updateUI();
        this.setFont(MemoryUsagePanel.getWidgetFont());
    }

    public void uiSettingsChanged(UISettings uiSettings) {
        this.myBufferedImage = null;
    }

    private static Font getWidgetFont() {
        return JBUI.Fonts.label((float)11.0f);
    }

    public JComponent getComponent() {
        return this;
    }

    @Override
    public void paintComponent(Graphics g) {
        boolean pressed = this.getModel().isPressed();
        boolean stateChanged = this.myWasPressed != pressed;
        this.myWasPressed = pressed;
        if (this.myBufferedImage == null || stateChanged) {
            Dimension size = this.getSize();
            Insets insets = this.getInsets();
            this.myBufferedImage = UIUtil.createImage((Graphics)g, (int)size.width, (int)size.height, (int)2);
            Graphics2D g2 = JBSwingUtilities.runGlobalCGTransform((JComponent)this, (Graphics)this.myBufferedImage.createGraphics());
            UISettings.setupAntialiasing((Graphics)g2);
            g2.setFont(this.getFont());
            int textHeight = g2.getFontMetrics().getAscent();
            Runtime rt = Runtime.getRuntime();
            long maxMem = rt.maxMemory();
            long allocatedMem = rt.totalMemory();
            long unusedMem = rt.freeMemory();
            long usedMem = allocatedMem - unusedMem;
            int usedBarLength = (int)((long)size.width * usedMem / maxMem);
            int unusedBarLength = (int)((long)size.height * unusedMem / maxMem);
            g2.setColor(UIUtil.getPanelBackground());
            g2.fillRect(0, 0, size.width, size.height);
            g2.setColor(USED_COLOR);
            g2.fillRect(0, 0, usedBarLength, size.height);
            g2.setColor(UNUSED_COLOR);
            g2.fillRect(usedBarLength, 0, unusedBarLength, size.height);
            g2.setColor(pressed ? UIUtil.getLabelDisabledForeground() : JBColor.foreground());
            String text = UIBundle.message((String)"memory.usage.panel.message.text", (Object[])new Object[]{usedMem / 0x100000L, maxMem / 0x100000L});
            int textX = insets.left;
            int textY = insets.top + (size.height - insets.top - insets.bottom - textHeight) / 2 + textHeight - JBUI.scale((int)1);
            g2.drawString(text, textX, textY);
            g2.dispose();
        }
        UIUtil.drawImage((Graphics)g, (Image)this.myBufferedImage, (int)0, (int)0, null);
    }

    @Override
    public Dimension getPreferredSize() {
        FontMetrics metrics = this.getFontMetrics(MemoryUsagePanel.getWidgetFont());
        Insets insets = this.getInsets();
        int width = metrics.stringWidth(this.mySample) + insets.left + insets.right + JBUI.scale((int)2);
        int height = metrics.getHeight() + insets.top + insets.bottom + JBUI.scale((int)2);
        return new Dimension(width, height);
    }

    @Override
    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    @Override
    public Dimension getMaximumSize() {
        return this.getPreferredSize();
    }

    private void updateState() {
        if (!this.isShowing()) {
            return;
        }
        Runtime rt = Runtime.getRuntime();
        long maxMem = rt.maxMemory() / 0x100000L;
        long allocatedMem = rt.totalMemory() / 0x100000L;
        long usedMem = allocatedMem - rt.freeMemory() / 0x100000L;
        if (allocatedMem != this.myLastAllocated || usedMem != this.myLastUsed) {
            this.myLastAllocated = allocatedMem;
            this.myLastUsed = usedMem;
            UIUtil.invokeLaterIfNeeded(() -> {
                this.myBufferedImage = null;
                this.repaint();
            });
            this.setToolTipText(UIBundle.message((String)"memory.usage.panel.statistics.message", (Object[])new Object[]{maxMem, allocatedMem, usedMem}));
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "statusBar";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/wm/impl/status/MemoryUsagePanel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/wm/impl/status/MemoryUsagePanel";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "ID";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "install";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getPresentation";
                break;
            }
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

