/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util;

import com.intellij.util.containers.IntObjectLinkedMap;
import org.jetbrains.annotations.Nullable;

public class IntSLRUCache<Entry extends IntObjectLinkedMap.MapEntry> {
    private static final boolean ourPrintDebugStatistics = false;
    private final IntObjectLinkedMap<Entry> myProtectedQueue;
    private final IntObjectLinkedMap<Entry> myProbationalQueue;
    private int probationalHits = 0;
    private int protectedHits = 0;
    private int misses = 0;

    public IntSLRUCache(int protectedQueueSize, int probationalQueueSize) {
        this.myProtectedQueue = new IntObjectLinkedMap(protectedQueueSize);
        this.myProbationalQueue = new IntObjectLinkedMap(probationalQueueSize);
    }

    public Entry cacheEntry(Entry entry) {
        Entry cached = this.myProtectedQueue.getEntry(((IntObjectLinkedMap.MapEntry)entry).key);
        if (cached == null) {
            cached = this.myProbationalQueue.getEntry(((IntObjectLinkedMap.MapEntry)entry).key);
        }
        if (cached != null) {
            return cached;
        }
        this.myProbationalQueue.putEntry(entry);
        return entry;
    }

    @Nullable
    public Entry getCachedEntry(int id) {
        return this.getCachedEntry(id, true);
    }

    @Nullable
    public Entry getCachedEntry(int id, boolean allowMutation) {
        Entry entry = this.myProtectedQueue.getEntry(id);
        if (entry != null) {
            ++this.protectedHits;
            return entry;
        }
        entry = this.myProbationalQueue.getEntry(id);
        if (entry != null) {
            this.printStatistics(++this.probationalHits);
            if (allowMutation) {
                this.myProbationalQueue.removeEntry(((IntObjectLinkedMap.MapEntry)entry).key);
                Entry demoted = this.myProtectedQueue.putEntry(entry);
                if (demoted != null) {
                    this.myProbationalQueue.putEntry(demoted);
                }
            }
            return entry;
        }
        this.printStatistics(++this.misses);
        return null;
    }

    private void printStatistics(int hits) {
    }
}

