/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.ui.table;

import com.intellij.ide.IdeBundle;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.ui.AnActionButton;
import com.intellij.ui.AnActionButtonRunnable;
import com.intellij.ui.AnActionButtonUpdater;
import com.intellij.ui.TableSpeedSearch;
import com.intellij.ui.TableUtil;
import com.intellij.ui.ToolbarDecorator;
import com.intellij.ui.table.TableView;
import com.intellij.util.Function;
import com.intellij.util.FunctionUtil;
import com.intellij.util.PlatformIcons;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.CollectionItemEditor;
import com.intellij.util.ui.CollectionModelEditor;
import com.intellij.util.ui.ColumnInfo;
import com.intellij.util.ui.ElementProducer;
import com.intellij.util.ui.ItemRemovable;
import com.intellij.util.ui.ListTableModel;
import com.intellij.util.ui.table.ComboBoxTableCellEditor;
import com.intellij.util.xmlb.SerializationFilter;
import com.intellij.util.xmlb.SkipDefaultValuesSerializationFilters;
import com.intellij.util.xmlb.XmlSerializer;
import gnu.trove.TObjectObjectProcedure;
import java.awt.Component;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;

public class TableModelEditor<T>
extends CollectionModelEditor<T, CollectionItemEditor<T>> {
    private final TableView<T> table;
    private final ToolbarDecorator toolbarDecorator;
    private final MyListTableModel model;

    public TableModelEditor(@NotNull ColumnInfo[] columns, @NotNull CollectionItemEditor<T> itemEditor, @NotNull String emptyText) {
        if (columns == null) {
            TableModelEditor.$$$reportNull$$$0(0);
        }
        if (itemEditor == null) {
            TableModelEditor.$$$reportNull$$$0(1);
        }
        if (emptyText == null) {
            TableModelEditor.$$$reportNull$$$0(2);
        }
        this(Collections.emptyList(), columns, itemEditor, emptyText);
    }

    public TableModelEditor(@NotNull List<T> items, @NotNull ColumnInfo[] columns, @NotNull CollectionItemEditor<T> itemEditor, @NotNull String emptyText) {
        if (items == null) {
            TableModelEditor.$$$reportNull$$$0(3);
        }
        if (columns == null) {
            TableModelEditor.$$$reportNull$$$0(4);
        }
        if (itemEditor == null) {
            TableModelEditor.$$$reportNull$$$0(5);
        }
        if (emptyText == null) {
            TableModelEditor.$$$reportNull$$$0(6);
        }
        super(itemEditor);
        this.model = new MyListTableModel(columns, new ArrayList<T>(items));
        this.table = new TableView((ListTableModel)this.model);
        this.table.setDefaultEditor(Enum.class, (TableCellEditor)ComboBoxTableCellEditor.INSTANCE);
        this.table.setStriped(true);
        this.table.setEnableAntialiasing(true);
        this.preferredScrollableViewportHeightInRows(7);
        new TableSpeedSearch((JTable)this.table);
        ColumnInfo firstColumn = columns[0];
        if ((firstColumn.getColumnClass() == Boolean.TYPE || firstColumn.getColumnClass() == Boolean.class) && firstColumn.getName().isEmpty()) {
            TableUtil.setupCheckboxColumn((TableColumn)this.table.getColumnModel().getColumn(0));
        }
        boolean needTableHeader = false;
        for (ColumnInfo column : columns) {
            if (StringUtil.isEmpty((String)column.getName())) continue;
            needTableHeader = true;
            break;
        }
        if (!needTableHeader) {
            this.table.setTableHeader(null);
        }
        this.table.getEmptyText().setText(emptyText);
        MyRemoveAction removeAction = new MyRemoveAction();
        this.toolbarDecorator = ToolbarDecorator.createDecorator(this.table, (ElementProducer)this).setRemoveAction((AnActionButtonRunnable)removeAction).setRemoveActionUpdater((AnActionButtonUpdater)removeAction);
        if (itemEditor instanceof DialogItemEditor) {
            this.addDialogActions();
        }
    }

    @NotNull
    public TableModelEditor<T> preferredScrollableViewportHeightInRows(int rows) {
        this.table.setPreferredScrollableViewportSize(new Dimension(200, this.table.getRowHeight() * rows));
        TableModelEditor tableModelEditor = this;
        if (tableModelEditor == null) {
            TableModelEditor.$$$reportNull$$$0(7);
        }
        return tableModelEditor;
    }

    private void addDialogActions() {
        this.toolbarDecorator.setEditAction(new AnActionButtonRunnable(){

            public void run(AnActionButton button) {
                Object item = TableModelEditor.this.table.getSelectedObject();
                if (item != null) {
                    Function mutator;
                    if (TableModelEditor.this.helper.isMutable(item)) {
                        mutator = FunctionUtil.id();
                    } else {
                        int selectedRow = TableModelEditor.this.table.getSelectedRow();
                        mutator = item12 -> TableModelEditor.this.helper.getMutable(item12, selectedRow);
                    }
                    ((DialogItemEditor)TableModelEditor.this.itemEditor).edit(item, mutator, false);
                    IdeFocusManager.getGlobalInstance().doWhenFocusSettlesDown(() -> IdeFocusManager.getGlobalInstance().requestFocus((Component)TableModelEditor.this.table, true));
                }
            }
        }).setEditActionUpdater(new AnActionButtonUpdater(){

            public boolean isEnabled(@NotNull AnActionEvent e) {
                Object item;
                if (e == null) {
                    1.$$$reportNull$$$0(0);
                }
                return (item = TableModelEditor.this.table.getSelectedObject()) != null && ((DialogItemEditor)TableModelEditor.this.itemEditor).isEditable(item);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/util/ui/table/TableModelEditor$1", "isEnabled"));
            }
        });
        if (((DialogItemEditor)this.itemEditor).isUseDialogToAdd()) {
            this.toolbarDecorator.setAddAction(new AnActionButtonRunnable(){

                public void run(AnActionButton button) {
                    Object item = TableModelEditor.this.createElement();
                    ((DialogItemEditor)TableModelEditor.this.itemEditor).edit(item, item1 -> {
                        TableModelEditor.this.model.addRow(item1);
                        return item1;
                    }, true);
                }
            });
        }
    }

    @NotNull
    public TableModelEditor<T> disableUpDownActions() {
        this.toolbarDecorator.disableUpDownActions();
        TableModelEditor tableModelEditor = this;
        if (tableModelEditor == null) {
            TableModelEditor.$$$reportNull$$$0(8);
        }
        return tableModelEditor;
    }

    @NotNull
    public TableModelEditor<T> enabled(boolean value) {
        this.table.setEnabled(value);
        TableModelEditor tableModelEditor = this;
        if (tableModelEditor == null) {
            TableModelEditor.$$$reportNull$$$0(9);
        }
        return tableModelEditor;
    }

    public TableModelEditor<T> modelListener(@NotNull DataChangedListener<T> listener2) {
        if (listener2 == null) {
            TableModelEditor.$$$reportNull$$$0(10);
        }
        this.model.dataChangedListener = listener2;
        this.model.addTableModelListener(listener2);
        return this;
    }

    @NotNull
    public ListTableModel<T> getModel() {
        MyListTableModel myListTableModel = this.model;
        if (myListTableModel == null) {
            TableModelEditor.$$$reportNull$$$0(11);
        }
        return myListTableModel;
    }

    @NotNull
    public static <T> T cloneUsingXmlSerialization(@NotNull T oldItem, @NotNull T newItem) {
        Element serialized;
        if (oldItem == null) {
            TableModelEditor.$$$reportNull$$$0(12);
        }
        if (newItem == null) {
            TableModelEditor.$$$reportNull$$$0(13);
        }
        if (!JDOMUtil.isEmpty((Element)(serialized = XmlSerializer.serialize(oldItem, (SerializationFilter)new SkipDefaultValuesSerializationFilters())))) {
            XmlSerializer.deserializeInto(newItem, (Element)serialized);
        }
        T t = newItem;
        if (t == null) {
            TableModelEditor.$$$reportNull$$$0(14);
        }
        return t;
    }

    @NotNull
    public JComponent createComponent() {
        JPanel jPanel = this.toolbarDecorator.addExtraAction((AnActionButton)new ToolbarDecorator.ElementActionButton(IdeBundle.message((String)"button.copy", (Object[])new Object[0]), PlatformIcons.COPY_ICON){

            public void actionPerformed(@NotNull AnActionEvent e) {
                if (e == null) {
                    4.$$$reportNull$$$0(0);
                }
                TableUtil.stopEditing((JTable)TableModelEditor.this.table);
                List selectedItems = TableModelEditor.this.table.getSelectedObjects();
                if (selectedItems.isEmpty()) {
                    return;
                }
                for (Object item : selectedItems) {
                    TableModelEditor.this.model.addRow(TableModelEditor.this.itemEditor.clone(item, false));
                }
                IdeFocusManager.getGlobalInstance().doWhenFocusSettlesDown(() -> IdeFocusManager.getGlobalInstance().requestFocus((Component)TableModelEditor.this.table, true));
                TableUtil.updateScroller((JTable)TableModelEditor.this.table);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/util/ui/table/TableModelEditor$4", "actionPerformed"));
            }
        }).createPanel();
        if (jPanel == null) {
            TableModelEditor.$$$reportNull$$$0(15);
        }
        return jPanel;
    }

    @Override
    @NotNull
    protected List<T> getItems() {
        List list2 = this.model.items;
        if (list2 == null) {
            TableModelEditor.$$$reportNull$$$0(16);
        }
        return list2;
    }

    public void selectItem(final @NotNull T item) {
        Ref ref;
        if (item == null) {
            TableModelEditor.$$$reportNull$$$0(17);
        }
        this.table.clearSelection();
        if (this.helper.hasModifiedItems()) {
            ref = Ref.create();
            this.helper.process(new TObjectObjectProcedure<T, T>(){

                public boolean execute(T modified, T original) {
                    if (item == original) {
                        ref.set(modified);
                    }
                    return ref.isNull();
                }
            });
        } else {
            ref = null;
        }
        this.table.addSelection(ref == null || ref.isNull() ? item : ref.get());
    }

    @NotNull
    public List<T> apply() {
        if (this.helper.hasModifiedItems()) {
            final ColumnInfo[] columns = this.model.getColumnInfos();
            this.helper.process(new TObjectObjectProcedure<T, T>(){

                public boolean execute(T newItem, @NotNull T oldItem) {
                    if (oldItem == null) {
                        6.$$$reportNull$$$0(0);
                    }
                    for (ColumnInfo column : columns) {
                        if (!column.isCellEditable(newItem)) continue;
                        column.setValue(oldItem, column.valueOf(newItem));
                    }
                    if (TableModelEditor.this.itemEditor instanceof DialogItemEditor) {
                        ((DialogItemEditor)TableModelEditor.this.itemEditor).applyEdited(oldItem, newItem);
                    }
                    TableModelEditor.this.model.items.set(ContainerUtil.indexOfIdentity((List)TableModelEditor.this.model.items, newItem), oldItem);
                    return true;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "oldItem", "com/intellij/util/ui/table/TableModelEditor$6", "execute"));
                }
            });
        }
        this.helper.reset(this.model.items);
        List list2 = this.model.items;
        if (list2 == null) {
            TableModelEditor.$$$reportNull$$$0(18);
        }
        return list2;
    }

    @Override
    public void reset(@NotNull List<T> items) {
        if (items == null) {
            TableModelEditor.$$$reportNull$$$0(19);
        }
        super.reset(items);
        this.model.setItems(new ArrayList<T>(items));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 14: 
            case 15: 
            case 16: 
            case 18: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 14: 
            case 15: 
            case 16: 
            case 18: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "columns";
                break;
            }
            case 1: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "itemEditor";
                break;
            }
            case 2: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "emptyText";
                break;
            }
            case 3: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "items";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 14: 
            case 15: 
            case 16: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/ui/table/TableModelEditor";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "oldItem";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newItem";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "item";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/ui/table/TableModelEditor";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "preferredScrollableViewportHeightInRows";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "disableUpDownActions";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "enabled";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getModel";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "cloneUsingXmlSerialization";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "createComponent";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getItems";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "apply";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 14: 
            case 15: 
            case 16: 
            case 18: {
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "modelListener";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "cloneUsingXmlSerialization";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "selectItem";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "reset";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 14: 
            case 15: 
            case 16: 
            case 18: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class MyRemoveAction
    implements AnActionButtonRunnable,
    AnActionButtonUpdater,
    TableUtil.ItemChecker {
        private MyRemoveAction() {
        }

        public void run(AnActionButton button) {
            if (TableUtil.doRemoveSelectedItems((JTable)TableModelEditor.this.table, (ItemRemovable)TableModelEditor.this.model, (TableUtil.ItemChecker)this)) {
                IdeFocusManager.getGlobalInstance().doWhenFocusSettlesDown(() -> IdeFocusManager.getGlobalInstance().requestFocus((Component)TableModelEditor.this.table, true));
                TableUtil.updateScroller((JTable)TableModelEditor.this.table);
            }
        }

        public boolean isOperationApplyable(@NotNull TableModel ignored, int row2) {
            Object item;
            if (ignored == null) {
                MyRemoveAction.$$$reportNull$$$0(0);
            }
            return (item = TableModelEditor.this.model.getItem(row2)) != null && TableModelEditor.this.itemEditor.isRemovable(item);
        }

        public boolean isEnabled(@NotNull AnActionEvent e) {
            if (e == null) {
                MyRemoveAction.$$$reportNull$$$0(1);
            }
            return TableModelEditor.this.areSelectedItemsRemovable(TableModelEditor.this.table.getSelectionModel());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "ignored";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/util/ui/table/TableModelEditor$MyRemoveAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isOperationApplyable";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isEnabled";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static abstract class EditableColumnInfo<Item, Aspect>
    extends ColumnInfo<Item, Aspect> {
        public EditableColumnInfo(@NotNull String name) {
            if (name == null) {
                EditableColumnInfo.$$$reportNull$$$0(0);
            }
            super(name);
        }

        public EditableColumnInfo() {
            super("");
        }

        public boolean isCellEditable(Item item) {
            return true;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/util/ui/table/TableModelEditor$EditableColumnInfo", "<init>"));
        }
    }

    private final class MyListTableModel
    extends ListTableModel<T> {
        private List<T> items;
        private DataChangedListener<T> dataChangedListener;

        MyListTableModel(@NotNull ColumnInfo[] columns, List<T> items) {
            if (columns == null) {
                MyListTableModel.$$$reportNull$$$0(0);
            }
            if (items == null) {
                MyListTableModel.$$$reportNull$$$0(1);
            }
            super(columns, items);
            this.items = items;
        }

        public void setItems(@NotNull List<T> items) {
            if (items == null) {
                MyListTableModel.$$$reportNull$$$0(2);
            }
            this.items = items;
            super.setItems(items);
        }

        public void removeRow(int index) {
            TableModelEditor.this.helper.remove(this.getItem(index));
            super.removeRow(index);
        }

        public void setValueAt(Object newValue, int rowIndex, int columnIndex) {
            if (rowIndex < this.getRowCount()) {
                ColumnInfo column = this.getColumnInfos()[columnIndex];
                Object item = this.getItem(rowIndex);
                Object oldValue = column.valueOf(item);
                if (column.getColumnClass() == String.class ? !Comparing.strEqual((String)((String)oldValue), (String)((String)newValue)) : !Comparing.equal((Object)oldValue, (Object)newValue)) {
                    column.setValue(TableModelEditor.this.helper.getMutable(item, rowIndex), newValue);
                    if (this.dataChangedListener != null) {
                        this.dataChangedListener.dataChanged(column, rowIndex);
                    }
                }
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "columns";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "items";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/util/ui/table/TableModelEditor$MyListTableModel";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "setItems";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static interface DialogItemEditor<T>
    extends CollectionItemEditor<T> {
        public void edit(@NotNull T var1, @NotNull Function<T, T> var2, boolean var3);

        public void applyEdited(@NotNull T var1, @NotNull T var2);

        default public boolean isEditable(@NotNull T item) {
            if (item == null) {
                DialogItemEditor.$$$reportNull$$$0(0);
            }
            return true;
        }

        default public boolean isUseDialogToAdd() {
            return false;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "item", "com/intellij/util/ui/table/TableModelEditor$DialogItemEditor", "isEditable"));
        }
    }

    public static abstract class DataChangedListener<T>
    implements TableModelListener {
        public abstract void dataChanged(@NotNull ColumnInfo<T, ?> var1, int var2);

        @Override
        public void tableChanged(@NotNull TableModelEvent e) {
            if (e == null) {
                DataChangedListener.$$$reportNull$$$0(0);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/util/ui/table/TableModelEditor$DataChangedListener", "tableChanged"));
        }
    }
}

