/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.ui.render;

import com.intellij.openapi.ui.GraphicsConfig;
import com.intellij.ui.JBColor;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.util.ui.GraphicsUtil;
import com.intellij.util.ui.JBValue;
import com.intellij.util.ui.UIUtil;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.geom.RoundRectangle2D;
import org.jetbrains.annotations.NotNull;

public class RectanglePainter {
    private static final JBValue.JBValueGroup JBVG = new JBValue.JBValueGroup();
    protected static final JBValue TEXT_PADDING_X = JBVG.value(5.0f);
    public static final JBValue TOP_TEXT_PADDING = JBVG.value(2.0f);
    public static final JBValue BOTTOM_TEXT_PADDING = JBVG.value(1.0f);
    public static final JBValue LABEL_ARC = JBVG.value(6.0f);
    private final boolean mySquare;

    public RectanglePainter(boolean square) {
        this.mySquare = square;
    }

    public static Font getFont() {
        return UIUtil.getLabelFont();
    }

    protected Font getLabelFont() {
        return RectanglePainter.getFont();
    }

    public void paint(@NotNull Graphics2D g2, @NotNull String text, int paddingX, int paddingY, @NotNull Color color) {
        if (g2 == null) {
            RectanglePainter.$$$reportNull$$$0(0);
        }
        if (text == null) {
            RectanglePainter.$$$reportNull$$$0(1);
        }
        if (color == null) {
            RectanglePainter.$$$reportNull$$$0(2);
        }
        GraphicsConfig config2 = GraphicsUtil.setupAAPainting((Graphics)g2);
        g2.setFont(this.getLabelFont());
        g2.setStroke(new BasicStroke(1.5f));
        FontMetrics fontMetrics = g2.getFontMetrics();
        int width = fontMetrics.stringWidth(text) + 2 * TEXT_PADDING_X.get();
        int height = fontMetrics.getHeight() + TOP_TEXT_PADDING.get() + BOTTOM_TEXT_PADDING.get();
        g2.setColor(color);
        if (this.mySquare) {
            g2.fillRect(paddingX, paddingY, width, height);
        } else {
            g2.fill(new RoundRectangle2D.Double(paddingX, paddingY, width, height, LABEL_ARC.get(), LABEL_ARC.get()));
        }
        g2.setColor((Color)JBColor.BLACK);
        int x = paddingX + TEXT_PADDING_X.get();
        int y = paddingY + SimpleColoredComponent.getTextBaseLine((FontMetrics)fontMetrics, (int)height);
        g2.drawString(text, x, y);
        config2.restore();
    }

    public Dimension calculateSize(@NotNull String text, @NotNull FontMetrics metrics) {
        if (text == null) {
            RectanglePainter.$$$reportNull$$$0(3);
        }
        if (metrics == null) {
            RectanglePainter.$$$reportNull$$$0(4);
        }
        int width = metrics.stringWidth(text) + 2 * TEXT_PADDING_X.get();
        int height = metrics.getHeight() + TOP_TEXT_PADDING.get() + BOTTOM_TEXT_PADDING.get();
        return new Dimension(width, height);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "g2";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "color";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "metrics";
                break;
            }
        }
        objectArray2[1] = "com/intellij/vcs/log/ui/render/RectanglePainter";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "paint";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "calculateSize";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

