/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.model;

import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.text.StringUtilRt;
import java.util.List;
import java.util.ListIterator;
import org.jdom.Attribute;
import org.jdom.Content;
import org.jdom.Element;
import org.jdom.Text;
import org.jdom.filter.Filter;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class MavenJDOMUtil {
    private static final EmptyTextFilter CONTENT_FILTER = new EmptyTextFilter();

    MavenJDOMUtil() {
    }

    public static boolean areElementsEqual(@Nullable Element e1, @Nullable Element e2) {
        if (e1 == null && e2 == null) {
            return true;
        }
        if (e1 == null || e2 == null) {
            return false;
        }
        return Comparing.equal((String)e1.getName(), (String)e2.getName()) && MavenJDOMUtil.isAttributesEqual(e1.getAttributes(), e2.getAttributes()) && MavenJDOMUtil.contentListsEqual(e1.getContent((Filter)CONTENT_FILTER), e2.getContent((Filter)CONTENT_FILTER));
    }

    private static boolean contentListsEqual(List c1, List c2) {
        if (c1 == null && c2 == null) {
            return true;
        }
        if (c1 == null || c2 == null) {
            return false;
        }
        ListIterator l1 = c1.listIterator();
        ListIterator l2 = c2.listIterator();
        while (l1.hasNext() && l2.hasNext()) {
            if (MavenJDOMUtil.contentsEqual((Content)l1.next(), (Content)l2.next())) continue;
            return false;
        }
        return l1.hasNext() == l2.hasNext();
    }

    private static boolean contentsEqual(Content c1, Content c2) {
        if (!(c1 instanceof Element) && !(c2 instanceof Element)) {
            return c1.getValue().equals(c2.getValue());
        }
        return c1 instanceof Element && c2 instanceof Element && MavenJDOMUtil.areElementsEqual((Element)c1, (Element)c2);
    }

    private static boolean isAttributesEqual(@NotNull List<Attribute> l1, @NotNull List<Attribute> l2) {
        if (l1 == null) {
            MavenJDOMUtil.$$$reportNull$$$0(0);
        }
        if (l2 == null) {
            MavenJDOMUtil.$$$reportNull$$$0(1);
        }
        if (l1.size() != l2.size()) {
            return false;
        }
        for (int i = 0; i < l1.size(); ++i) {
            if (MavenJDOMUtil.attEqual(l1.get(i), l2.get(i))) continue;
            return false;
        }
        return true;
    }

    private static boolean attEqual(@NotNull Attribute a1, @NotNull Attribute a2) {
        if (a1 == null) {
            MavenJDOMUtil.$$$reportNull$$$0(2);
        }
        if (a2 == null) {
            MavenJDOMUtil.$$$reportNull$$$0(3);
        }
        return a1.getName().equals(a2.getName()) && a1.getValue().equals(a2.getValue());
    }

    public static int getTreeHash(@NotNull Element root) {
        if (root == null) {
            MavenJDOMUtil.$$$reportNull$$$0(4);
        }
        return MavenJDOMUtil.addToHash(0, root);
    }

    private static int addToHash(int i, @NotNull Element element) {
        if (element == null) {
            MavenJDOMUtil.$$$reportNull$$$0(5);
        }
        i = MavenJDOMUtil.addToHash(i, element.getName());
        for (Attribute attribute : element.getAttributes()) {
            i = MavenJDOMUtil.addToHash(i, attribute.getName());
            i = MavenJDOMUtil.addToHash(i, attribute.getValue());
        }
        for (Content child : element.getContent()) {
            String text;
            if (child instanceof Element) {
                i = MavenJDOMUtil.addToHash(i, (Element)child);
                continue;
            }
            if (!(child instanceof Text) || StringUtilRt.isEmptyOrSpaces((CharSequence)(text = ((Text)child).getText()))) continue;
            i = MavenJDOMUtil.addToHash(i, text);
        }
        return i;
    }

    private static int addToHash(int i, @NotNull String s) {
        if (s == null) {
            MavenJDOMUtil.$$$reportNull$$$0(6);
        }
        return i * 31 + s.hashCode();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "l1";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "l2";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "a1";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "a2";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "s";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/idea/maven/model/MavenJDOMUtil";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "isAttributesEqual";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "attEqual";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "getTreeHash";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "addToHash";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class EmptyTextFilter
    implements Filter {
        private EmptyTextFilter() {
        }

        public boolean matches(Object obj) {
            return !(obj instanceof Text) || !StringUtilRt.isEmptyOrSpaces((CharSequence)((Text)obj).getText());
        }
    }
}

