/*
 * Decompiled with CFR 0.152.
 */
package freemarker.core;

import freemarker.core.ArithmeticEngine;
import freemarker.core.CollectionAndSequence;
import freemarker.core.Environment;
import freemarker.core.EvaluationUtil;
import freemarker.core.Expression;
import freemarker.core.NonStringException;
import freemarker.template.SimpleNumber;
import freemarker.template.SimpleScalar;
import freemarker.template.SimpleSequence;
import freemarker.template.TemplateCollectionModel;
import freemarker.template.TemplateException;
import freemarker.template.TemplateHashModel;
import freemarker.template.TemplateHashModelEx;
import freemarker.template.TemplateModel;
import freemarker.template.TemplateModelException;
import freemarker.template.TemplateModelIterator;
import freemarker.template.TemplateNumberModel;
import freemarker.template.TemplateScalarModel;
import freemarker.template.TemplateSequenceModel;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

final class AddConcatExpression
extends Expression {
    private final Expression left;
    private final Expression right;

    AddConcatExpression(Expression left, Expression right) {
        this.left = left;
        this.right = right;
    }

    TemplateModel _getAsTemplateModel(Environment env) throws TemplateException {
        TemplateModel leftModel = this.left.getAsTemplateModel(env);
        TemplateModel rightModel = this.right.getAsTemplateModel(env);
        if (leftModel instanceof TemplateNumberModel && rightModel instanceof TemplateNumberModel) {
            Number first = EvaluationUtil.getNumber((TemplateNumberModel)leftModel, this.left, env);
            Number second = EvaluationUtil.getNumber((TemplateNumberModel)rightModel, this.right, env);
            ArithmeticEngine ae = env != null ? env.getArithmeticEngine() : this.getTemplate().getArithmeticEngine();
            return new SimpleNumber(ae.add(first, second));
        }
        if (leftModel instanceof TemplateSequenceModel && rightModel instanceof TemplateSequenceModel) {
            return new ConcatenatedSequence((TemplateSequenceModel)leftModel, (TemplateSequenceModel)rightModel);
        }
        try {
            String s2;
            String s1 = AddConcatExpression.getStringValue(leftModel, this.left, env);
            if (s1 == null) {
                s1 = "null";
            }
            if ((s2 = AddConcatExpression.getStringValue(rightModel, this.right, env)) == null) {
                s2 = "null";
            }
            return new SimpleScalar(s1.concat(s2));
        }
        catch (NonStringException e) {
            if (leftModel instanceof TemplateHashModel && rightModel instanceof TemplateHashModel) {
                if (leftModel instanceof TemplateHashModelEx && rightModel instanceof TemplateHashModelEx) {
                    TemplateHashModelEx leftModelEx = (TemplateHashModelEx)leftModel;
                    TemplateHashModelEx rightModelEx = (TemplateHashModelEx)rightModel;
                    if (leftModelEx.size() == 0) {
                        return rightModelEx;
                    }
                    if (rightModelEx.size() == 0) {
                        return leftModelEx;
                    }
                    return new ConcatenatedHashEx(leftModelEx, rightModelEx);
                }
                return new ConcatenatedHash((TemplateHashModel)leftModel, (TemplateHashModel)rightModel);
            }
            throw e;
        }
    }

    boolean isLiteral() {
        return this.constantValue != null || this.left.isLiteral() && this.right.isLiteral();
    }

    Expression _deepClone(String name, Expression subst) {
        return new AddConcatExpression(this.left.deepClone(name, subst), this.right.deepClone(name, subst));
    }

    public String getCanonicalForm() {
        return this.left.getCanonicalForm() + " + " + this.right.getCanonicalForm();
    }

    private static final class ConcatenatedHashEx
    extends ConcatenatedHash
    implements TemplateHashModelEx {
        private Set keySet;
        private TemplateCollectionModel keys;
        private TemplateCollectionModel values;
        private int size;

        ConcatenatedHashEx(TemplateHashModelEx left, TemplateHashModelEx right) {
            super(left, right);
        }

        public int size() throws TemplateModelException {
            this.initKeys();
            return this.size;
        }

        public TemplateCollectionModel keys() throws TemplateModelException {
            this.initKeys();
            return this.keys;
        }

        public TemplateCollectionModel values() throws TemplateModelException {
            this.initValues();
            return this.values;
        }

        private void initKeys() throws TemplateModelException {
            if (this.keys == null) {
                this.keySet = new HashSet();
                ConcatenatedHashEx.addKeys(this.keySet, (TemplateHashModelEx)this.left);
                ConcatenatedHashEx.addKeys(this.keySet, (TemplateHashModelEx)this.right);
                this.size = this.keySet.size();
                this.keys = new CollectionAndSequence(new SimpleSequence(this.keySet));
            }
        }

        private static void addKeys(Set set, TemplateHashModelEx hash) throws TemplateModelException {
            TemplateModelIterator it = hash.keys().iterator();
            while (it.hasNext()) {
                set.add(((TemplateScalarModel)it.next()).getAsString());
            }
        }

        private void initValues() throws TemplateModelException {
            if (this.values == null) {
                ArrayList<TemplateModel> list = new ArrayList<TemplateModel>(this.size());
                Iterator it = this.keySet.iterator();
                while (it.hasNext()) {
                    list.add(this.get((String)it.next()));
                }
                this.values = new CollectionAndSequence(new SimpleSequence(list));
            }
        }
    }

    private static class ConcatenatedHash
    implements TemplateHashModel {
        protected final TemplateHashModel left;
        protected final TemplateHashModel right;

        ConcatenatedHash(TemplateHashModel left, TemplateHashModel right) {
            this.left = left;
            this.right = right;
        }

        public TemplateModel get(String key) throws TemplateModelException {
            TemplateModel model = this.right.get(key);
            return model != null ? model : this.left.get(key);
        }

        public boolean isEmpty() throws TemplateModelException {
            return this.left.isEmpty() && this.right.isEmpty();
        }
    }

    private static final class ConcatenatedSequence
    implements TemplateSequenceModel {
        private final TemplateSequenceModel left;
        private final TemplateSequenceModel right;

        ConcatenatedSequence(TemplateSequenceModel left, TemplateSequenceModel right) {
            this.left = left;
            this.right = right;
        }

        public int size() throws TemplateModelException {
            return this.left.size() + this.right.size();
        }

        public TemplateModel get(int i) throws TemplateModelException {
            int ls = this.left.size();
            return i < ls ? this.left.get(i) : this.right.get(i - ls);
        }
    }
}

