/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.uiDesigner;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.uiDesigner.lw.ColorDescriptor;
import com.intellij.uiDesigner.lw.FontDescriptor;
import com.intellij.uiDesigner.lw.StringDescriptor;
import com.intellij.xml.util.XmlStringUtil;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Insets;
import java.util.Stack;
import org.jdom.Attribute;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;

public final class XmlWriter {
    private static final int INDENT = 2;
    private final Stack<String> myElementNames = new Stack();
    private final Stack<Boolean> myElementHasBody = new Stack();
    @NonNls
    private final StringBuffer myBuffer = new StringBuffer();

    public XmlWriter() {
        this.myBuffer.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
    }

    public String getText() {
        return this.myBuffer.toString();
    }

    public void writeDimension(Dimension dimension, @NonNls String elementName) {
        if (dimension.width == -1 && dimension.height == -1) {
            return;
        }
        this.startElement(elementName);
        try {
            this.addAttribute("width", dimension.width);
            this.addAttribute("height", dimension.height);
        }
        finally {
            this.endElement();
        }
    }

    public void startElement(@NonNls String elementName) {
        this.startElement(elementName, null);
    }

    public void startElement(@NonNls String elementName, String namespace) {
        if (this.myElementNames.size() > 0) {
            if (!this.myElementHasBody.peek().booleanValue()) {
                this.myBuffer.append(">\n");
            }
            this.myElementHasBody.set(this.myElementHasBody.size() - 1, Boolean.TRUE);
        }
        this.writeSpaces(this.myElementNames.size() * 2);
        this.myBuffer.append("<").append(elementName);
        if (namespace != null) {
            this.myBuffer.append(" xmlns=\"").append(namespace).append('\"');
        }
        this.myElementNames.push(elementName);
        this.myElementHasBody.push(Boolean.FALSE);
    }

    public void endElement() {
        String elementName = this.myElementNames.peek();
        boolean hasBody = this.myElementHasBody.peek();
        this.myElementNames.pop();
        this.myElementHasBody.pop();
        if (hasBody) {
            this.writeSpaces(this.myElementNames.size() * 2);
            this.myBuffer.append("</").append(elementName).append(">\n");
        } else {
            this.myBuffer.append("/>\n");
        }
    }

    private void addAttributeImpl(String name, String value) {
        this.myBuffer.append(' ').append(name).append("=\"").append(value).append('\"');
    }

    public void addAttribute(@NonNls String name, String value) {
        this.addAttributeImpl(name, StringUtil.convertLineSeparators((String)XmlStringUtil.escapeString((String)value, (boolean)true, (boolean)false)));
    }

    public void addAttribute(@NonNls String name, int value) {
        this.addAttributeImpl(name, Integer.toString(value));
    }

    public void addAttribute(@NonNls String name, boolean value) {
        this.addAttributeImpl(name, Boolean.toString(value));
    }

    public void addAttribute(@NonNls String name, Double value) {
        this.addAttributeImpl(name, Double.toString(value));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeElement(Element element) {
        this.startElement(element.getName());
        try {
            for (Object o1 : element.getAttributes()) {
                Attribute attribute = (Attribute)o1;
                this.addAttribute(attribute.getName(), attribute.getValue());
            }
            for (Object o : element.getChildren()) {
                Element child = (Element)o;
                this.writeElement(child);
            }
        }
        finally {
            this.endElement();
        }
    }

    private void writeSpaces(int count) {
        for (int i = 0; i < count; ++i) {
            this.myBuffer.append(' ');
        }
    }

    public void writeStringDescriptor(StringDescriptor descriptor, String valueAttr, String bundleAttr, String keyAttr) {
        if (descriptor.getValue() != null) {
            this.addAttribute(valueAttr, descriptor.getValue());
            if (descriptor.isNoI18n()) {
                this.addAttribute("noi18n", Boolean.TRUE.toString());
            }
        } else {
            this.addAttribute(bundleAttr, descriptor.getBundleName());
            this.addAttribute(keyAttr, descriptor.getKey());
        }
    }

    public void writeColorDescriptor(ColorDescriptor value) {
        Color color = value.getColor();
        if (color != null) {
            this.addAttribute("color", color.getRGB());
        } else if (value.getSwingColor() != null) {
            this.addAttribute("swing-color", value.getSwingColor());
        } else if (value.getSystemColor() != null) {
            this.addAttribute("system-color", value.getSystemColor());
        } else if (value.getAWTColor() != null) {
            this.addAttribute("awt-color", value.getAWTColor());
        }
    }

    public void writeFontDescriptor(FontDescriptor value) {
        if (value.getSwingFont() != null) {
            this.addAttribute("swing-font", value.getSwingFont());
        } else {
            if (value.getFontName() != null) {
                this.addAttribute("name", value.getFontName());
            }
            if (value.getFontSize() >= 0) {
                this.addAttribute("size", value.getFontSize());
            }
            if (value.getFontStyle() >= 0) {
                this.addAttribute("style", value.getFontStyle());
            }
        }
    }

    public void writeInsets(Insets value) {
        this.addAttribute("top", value.top);
        this.addAttribute("left", value.left);
        this.addAttribute("bottom", value.bottom);
        this.addAttribute("right", value.right);
    }
}

