/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.uiDesigner.palette;

import com.intellij.ide.palette.PaletteGroup;
import com.intellij.ide.palette.PaletteItemProvider;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.uiDesigner.palette.Palette;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class UIDesignerPaletteProvider
implements PaletteItemProvider {
    @NonNls
    private static final String PROPERTY_GROUPS = "groups";
    private final Project myProject;
    private final PropertyChangeSupport myPropertyChangeSupport = new PropertyChangeSupport(this);
    private Palette.Listener myListener;

    public UIDesignerPaletteProvider(Project project) {
        this.myProject = project;
    }

    void fireGroupsChanged() {
        this.myPropertyChangeSupport.firePropertyChange(PROPERTY_GROUPS, null, null);
    }

    @Override
    public PaletteGroup[] getActiveGroups(VirtualFile vFile) {
        if (vFile.getFileType().equals(StdFileTypes.GUI_DESIGNER_FORM)) {
            Palette palette = Palette.getInstance(this.myProject);
            if (this.myListener == null) {
                this.myListener = new Palette.Listener(){

                    @Override
                    public void groupsChanged(@NotNull Palette palette) {
                        if (palette == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        UIDesignerPaletteProvider.this.fireGroupsChanged();
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "palette", "com/intellij/uiDesigner/palette/UIDesignerPaletteProvider$1", "groupsChanged"));
                    }
                };
                palette.addListener(this.myListener);
            }
            return palette.getToolWindowGroups();
        }
        return PaletteGroup.EMPTY_ARRAY;
    }

    @Override
    public void addListener(PropertyChangeListener listener) {
        this.myPropertyChangeSupport.addPropertyChangeListener(listener);
    }

    @Override
    public void removeListener(PropertyChangeListener listener) {
        this.myPropertyChangeSupport.removePropertyChangeListener(listener);
    }
}

