/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.uiDesigner.propertyInspector;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.uiDesigner.XmlWriter;
import com.intellij.uiDesigner.propertyInspector.Property;
import com.intellij.uiDesigner.radComponents.RadComponent;
import com.intellij.uiDesigner.radComponents.RadContainer;
import com.intellij.uiDesigner.radComponents.RadGridLayoutManager;
import com.intellij.uiDesigner.snapShooter.SnapshotContext;
import com.intellij.util.ArrayUtil;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import javax.swing.JComponent;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public abstract class IntrospectedProperty<V>
extends Property<RadComponent, V> {
    protected static final Object[] EMPTY_OBJECT_ARRAY = new Object[0];
    @NotNull
    protected final Method myReadMethod;
    @NotNull
    private final Method myWriteMethod;
    private final boolean myStoreAsClient;
    @NonNls
    private static final String INTRO_PREFIX = "Intro:";

    public IntrospectedProperty(String name, @NotNull Method readMethod, @NotNull Method writeMethod, boolean storeAsClient) {
        if (readMethod == null) {
            IntrospectedProperty.$$$reportNull$$$0(0);
        }
        if (writeMethod == null) {
            IntrospectedProperty.$$$reportNull$$$0(1);
        }
        super(null, name);
        this.myReadMethod = readMethod;
        this.myWriteMethod = writeMethod;
        this.myStoreAsClient = storeAsClient;
    }

    @Override
    public V getValue(RadComponent component) {
        return (V)this.invokeGetter(component);
    }

    protected Object invokeGetter(RadComponent component) {
        if (this.myStoreAsClient) {
            return component.getClientProperty(INTRO_PREFIX + this.getName());
        }
        try {
            this.myReadMethod.setAccessible(true);
            return this.myReadMethod.invoke((Object)component.getDelegee(), EMPTY_OBJECT_ARRAY);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    protected void setValueImpl(RadComponent component, V value) throws Exception {
        this.invokeSetter(component, value);
    }

    protected void invokeSetter(RadComponent component, Object value) throws IllegalAccessException, InvocationTargetException {
        if (this.myStoreAsClient) {
            component.putClientProperty(INTRO_PREFIX + this.getName(), value);
        } else {
            this.myWriteMethod.setAccessible(true);
            this.myWriteMethod.invoke((Object)component.getDelegee(), value);
        }
    }

    public void write(@NotNull V value, XmlWriter writer) {
        if (value == null) {
            IntrospectedProperty.$$$reportNull$$$0(2);
        }
        writer.addAttribute("value", value.toString());
    }

    @Override
    public boolean isModified(RadComponent component) {
        return component.isMarkedAsModified(this);
    }

    @Override
    public void resetValue(RadComponent component) throws Exception {
        V defaultValue = this.getDefaultValue(component.getDelegee());
        this.invokeSetter(component, defaultValue);
        this.markTopmostModified(component, false);
    }

    public void importSnapshotValue(SnapshotContext context, JComponent component, RadComponent radComponent) {
        try {
            Object value = this.myReadMethod.invoke((Object)component, EMPTY_OBJECT_ARRAY);
            V defaultValue = this.getDefaultValue(radComponent.getDelegee());
            if (!Comparing.equal((Object)value, defaultValue)) {
                this.setValue(radComponent, value);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected V getDefaultValue(JComponent delegee) throws Exception {
        if (this.myStoreAsClient) {
            return null;
        }
        Constructor<?> constructor = delegee.getClass().getConstructor(ArrayUtil.EMPTY_CLASS_ARRAY);
        constructor.setAccessible(true);
        JComponent newComponent = (JComponent)constructor.newInstance(ArrayUtil.EMPTY_OBJECT_ARRAY);
        return (V)this.myReadMethod.invoke((Object)newComponent, EMPTY_OBJECT_ARRAY);
    }

    @Override
    public boolean appliesTo(RadComponent component) {
        PsiMethod[] psiMethods;
        String name = this.getName();
        if (name.equals("preferredSize") || name.equals("minimumSize") || name.equals("maximumSize")) {
            RadContainer parent = component.getParent();
            return parent != null && !(parent.getLayoutManager() instanceof RadGridLayoutManager);
        }
        PsiManager psiManager = PsiManager.getInstance((Project)component.getProject());
        GlobalSearchScope scope = component.getModule().getModuleWithDependenciesAndLibrariesScope(true);
        PsiClass componentClass = JavaPsiFacade.getInstance((Project)psiManager.getProject()).findClass(component.getComponentClassName(), scope);
        if (componentClass == null) {
            return true;
        }
        for (PsiMethod method : psiMethods = componentClass.findMethodsByName(this.myReadMethod.getName(), true)) {
            if (method.hasModifierProperty("static") || !method.getParameterList().isEmpty()) continue;
            return true;
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "readMethod";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "writeMethod";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
        }
        objectArray2[1] = "com/intellij/uiDesigner/propertyInspector/IntrospectedProperty";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "write";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

