/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.uiDesigner.radComponents;

import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.uiDesigner.FormEditingUtil;
import com.intellij.uiDesigner.GridChangeUtil;
import com.intellij.uiDesigner.XmlWriter;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.designSurface.ComponentDropLocation;
import com.intellij.uiDesigner.designSurface.FirstComponentInsertLocation;
import com.intellij.uiDesigner.designSurface.GridDropLocation;
import com.intellij.uiDesigner.designSurface.GridInsertLocation;
import com.intellij.uiDesigner.designSurface.GridInsertMode;
import com.intellij.uiDesigner.designSurface.GridReplaceDropLocation;
import com.intellij.uiDesigner.radComponents.CustomPropertiesPanel;
import com.intellij.uiDesigner.radComponents.RadComponent;
import com.intellij.uiDesigner.radComponents.RadContainer;
import com.intellij.uiDesigner.radComponents.RadHSpacer;
import com.intellij.uiDesigner.radComponents.RadLayoutManager;
import com.intellij.uiDesigner.radComponents.RadVSpacer;
import com.intellij.util.IncorrectOperationException;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class RadAbstractGridLayoutManager
extends RadLayoutManager {
    protected final Map<RadComponent, MyPropertyChangeListener> myListenerMap = new HashMap<RadComponent, MyPropertyChangeListener>();

    @Override
    public boolean isGrid() {
        return true;
    }

    public abstract int getGridRowCount(RadContainer var1);

    public abstract int getGridColumnCount(RadContainer var1);

    public int getGridCellCount(RadContainer container, boolean isRow) {
        return isRow ? this.getGridRowCount(container) : this.getGridColumnCount(container);
    }

    public int getGridRowAt(RadContainer container, int y) {
        return this.getGridCellAt(container, y, true);
    }

    public int getGridColumnAt(RadContainer container, int x) {
        return this.getGridCellAt(container, x, false);
    }

    private int getGridCellAt(RadContainer container, int coord, boolean isRow) {
        int[] coords = this.getGridCellCoords(container, isRow);
        int[] sizes = this.getGridCellSizes(container, isRow);
        for (int i = 0; i < coords.length; ++i) {
            if (coords[i] > coord || coord > coords[i] + sizes[i]) continue;
            return i;
        }
        return -1;
    }

    public abstract int[] getHorizontalGridLines(RadContainer var1);

    public abstract int[] getVerticalGridLines(RadContainer var1);

    public abstract int[] getGridCellCoords(RadContainer var1, boolean var2);

    public abstract int[] getGridCellSizes(RadContainer var1, boolean var2);

    @Nullable
    public CustomPropertiesPanel getRowColumnPropertiesPanel(RadContainer container, boolean isRow, int[] selectedIndices) {
        return null;
    }

    @Nullable
    public static RadComponent getComponentAtGrid(RadContainer container, int row, int column) {
        for (int i = 0; i < container.getComponentCount(); ++i) {
            GridConstraints constraints;
            RadComponent component = container.getComponent(i);
            if (component.isDragging() || (constraints = component.getConstraints()).getRow() > row || row >= constraints.getRow() + constraints.getRowSpan() || constraints.getColumn() > column || column >= constraints.getColumn() + constraints.getColSpan()) continue;
            return component;
        }
        return null;
    }

    public int getGridLineNear(RadContainer container, boolean isRow, Point pnt, int epsilon) {
        int coord = isRow ? pnt.y : pnt.x;
        int[] gridLines = isRow ? this.getHorizontalGridLines(container) : this.getVerticalGridLines(container);
        for (int col = 1; col < gridLines.length; ++col) {
            if (coord >= gridLines[col]) continue;
            if (coord - gridLines[col - 1] < epsilon) {
                return col - 1;
            }
            if (gridLines[col] - coord < epsilon) {
                return col;
            }
            return -1;
        }
        if (coord - gridLines[gridLines.length - 1] < epsilon) {
            return gridLines.length - 1;
        }
        return -1;
    }

    public Rectangle getGridCellRangeRect(RadContainer container, int startRow, int startCol, int endRow, int endCol) {
        int[] xs = this.getGridCellCoords(container, false);
        int[] ys = this.getGridCellCoords(container, true);
        int[] widths = this.getGridCellSizes(container, false);
        int[] heights = this.getGridCellSizes(container, true);
        return new Rectangle(xs[startCol], ys[startRow], xs[endCol] + widths[endCol] - xs[startCol], ys[endRow] + heights[endRow] - ys[startRow]);
    }

    public boolean canCellGrow(RadContainer container, boolean isRow, int i) {
        return false;
    }

    @Nullable
    public ActionGroup getCaptionActions() {
        return null;
    }

    public void paintCaptionDecoration(RadContainer container, boolean isRow, int i, Graphics2D g, Rectangle rc) {
        if (this.canCellGrow(container, isRow, i)) {
            RadAbstractGridLayoutManager.drawGrowMarker(isRow, g, rc);
        }
    }

    public int insertGridCells(RadContainer grid, int cellIndex, boolean isRow, boolean isBefore, boolean grow) {
        GridChangeUtil.insertRowOrColumn(grid, cellIndex, isRow, isBefore);
        return 1;
    }

    public void copyGridCells(RadContainer source, RadContainer destination, boolean isRow, int cellIndex, int cellCount, int targetIndex) {
        for (int i = 0; i < cellCount; ++i) {
            this.insertGridCells(destination, cellIndex, isRow, false, false);
        }
    }

    public int deleteGridCells(RadContainer grid, int cellIndex, boolean isRow) {
        GridChangeUtil.deleteCell(grid, cellIndex, isRow);
        return 1;
    }

    public void processCellsMoved(RadContainer container, boolean isRow, int[] cells, int targetCell) {
        GridChangeUtil.moveCells(container, isRow, cells, targetCell);
    }

    public int getGapCellCount() {
        return 0;
    }

    public int getGapCellSize(RadContainer container, boolean isRow) {
        return 0;
    }

    public boolean isGapCell(RadContainer grid, boolean isRow, int cellIndex) {
        return false;
    }

    public int getCellIndexBase() {
        return 0;
    }

    public boolean canSpanningAllowed() {
        return true;
    }

    public boolean canResizeCells() {
        return true;
    }

    @Nullable
    public String getCellResizeTooltip(RadContainer container, boolean isRow, int cell, int newSize) {
        return null;
    }

    public void processCellResized(RadContainer container, boolean isRow, int cell, int newSize) {
    }

    public abstract void copyGridSection(RadContainer var1, RadContainer var2, Rectangle var3);

    public LayoutManager copyLayout(LayoutManager layout, int rowDelta, int columnDelta) {
        return layout;
    }

    public boolean isGridDefinedByComponents() {
        return false;
    }

    protected static void writeGridConstraints(XmlWriter writer, RadComponent child) {
        writer.startElement("grid");
        try {
            GridConstraints constraints = child.getConstraints();
            writer.addAttribute("row", constraints.getRow());
            writer.addAttribute("column", constraints.getColumn());
            writer.addAttribute("row-span", constraints.getRowSpan());
            writer.addAttribute("col-span", constraints.getColSpan());
            writer.addAttribute("vsize-policy", constraints.getVSizePolicy());
            writer.addAttribute("hsize-policy", constraints.getHSizePolicy());
            writer.addAttribute("anchor", constraints.getAnchor());
            writer.addAttribute("fill", constraints.getFill());
            writer.addAttribute("indent", constraints.getIndent());
            writer.addAttribute("use-parent-layout", constraints.isUseParentLayout());
            writer.writeDimension(constraints.myMinimumSize, "minimum-size");
            writer.writeDimension(constraints.myPreferredSize, "preferred-size");
            writer.writeDimension(constraints.myMaximumSize, "maximum-size");
        }
        finally {
            writer.endElement();
        }
    }

    @Override
    @NotNull
    public ComponentDropLocation getDropLocation(RadContainer container, @Nullable Point location) {
        RadComponent component;
        int i;
        if (container.getGridRowCount() == 1 && container.getGridColumnCount() == 1 && RadAbstractGridLayoutManager.getComponentAtGrid(container, 0, 0) == null) {
            Rectangle rc = this.getGridCellRangeRect(container, 0, 0, 0, 0);
            if (location == null) {
                FirstComponentInsertLocation firstComponentInsertLocation = new FirstComponentInsertLocation(container, rc, 0, 0);
                if (firstComponentInsertLocation == null) {
                    RadAbstractGridLayoutManager.$$$reportNull$$$0(0);
                }
                return firstComponentInsertLocation;
            }
            FirstComponentInsertLocation firstComponentInsertLocation = new FirstComponentInsertLocation(container, location, rc);
            if (firstComponentInsertLocation == null) {
                RadAbstractGridLayoutManager.$$$reportNull$$$0(1);
            }
            return firstComponentInsertLocation;
        }
        if (location == null) {
            if (RadAbstractGridLayoutManager.getComponentAtGrid(container, 0, 0) == null) {
                GridDropLocation gridDropLocation = new GridDropLocation(container, 0, 0);
                if (gridDropLocation == null) {
                    RadAbstractGridLayoutManager.$$$reportNull$$$0(2);
                }
                return gridDropLocation;
            }
            GridInsertLocation gridInsertLocation = new GridInsertLocation(container, this.getLastNonSpacerRow(container), 0, GridInsertMode.RowAfter);
            if (gridInsertLocation == null) {
                RadAbstractGridLayoutManager.$$$reportNull$$$0(3);
            }
            return gridInsertLocation;
        }
        int[] xs = this.getGridCellCoords(container, false);
        int[] ys = this.getGridCellCoords(container, true);
        int[] widths = this.getGridCellSizes(container, false);
        int[] heights = this.getGridCellSizes(container, true);
        int[] horzGridLines = this.getHorizontalGridLines(container);
        int[] vertGridLines = this.getVerticalGridLines(container);
        int row = ys.length - 1;
        int col = xs.length - 1;
        for (i = 0; i < xs.length; ++i) {
            if (location.x >= xs[i] + widths[i]) continue;
            col = i;
            break;
        }
        for (i = 0; i < ys.length; ++i) {
            if (!(location.getY() < (double)(ys[i] + heights[i]))) continue;
            row = i;
            break;
        }
        GridInsertMode mode = null;
        int EPSILON = 4;
        int dy = (int)(location.getY() - (double)ys[row]);
        if (dy < EPSILON) {
            mode = GridInsertMode.RowBefore;
        } else if (heights[row] - dy < EPSILON) {
            mode = GridInsertMode.RowAfter;
        }
        int dx = location.x - xs[col];
        if (dx < EPSILON) {
            mode = GridInsertMode.ColumnBefore;
        } else if (widths[col] - dx < EPSILON) {
            mode = GridInsertMode.ColumnAfter;
        }
        boolean spanInsertMode = this.canSpanningAllowed() && mode == null;
        boolean normalize = true;
        int cellWidth = vertGridLines[col + 1] - vertGridLines[col];
        int cellHeight = horzGridLines[row + 1] - horzGridLines[row];
        if (mode == null && (component = RadAbstractGridLayoutManager.getComponentAtGrid(container, row, col)) != null) {
            Rectangle rc = component.getBounds();
            rc.translate(-xs[col], -ys[row]);
            int right = rc.x + rc.width + 15;
            int bottom = rc.y + rc.height + 15;
            if (dy < rc.y - 15) {
                mode = GridInsertMode.RowBefore;
            } else if (dy > bottom && dy < cellHeight) {
                mode = GridInsertMode.RowAfter;
            }
            if (dx < rc.x - 15) {
                mode = GridInsertMode.ColumnBefore;
            } else if (dx > right && dx < cellWidth) {
                mode = GridInsertMode.ColumnAfter;
            }
            normalize = false;
        }
        if (mode != null) {
            GridInsertLocation dropLocation = new GridInsertLocation(container, row, col, mode);
            dropLocation.setSpanInsertMode(spanInsertMode);
            GridInsertLocation gridInsertLocation = normalize ? dropLocation.normalize() : dropLocation;
            if (gridInsertLocation == null) {
                RadAbstractGridLayoutManager.$$$reportNull$$$0(4);
            }
            return gridInsertLocation;
        }
        if (RadAbstractGridLayoutManager.getComponentAtGrid(container, row, col) instanceof RadVSpacer || RadAbstractGridLayoutManager.getComponentAtGrid(container, row, col) instanceof RadHSpacer) {
            GridReplaceDropLocation gridReplaceDropLocation = new GridReplaceDropLocation(container, row, col);
            if (gridReplaceDropLocation == null) {
                RadAbstractGridLayoutManager.$$$reportNull$$$0(5);
            }
            return gridReplaceDropLocation;
        }
        GridDropLocation gridDropLocation = new GridDropLocation(container, row, col);
        if (gridDropLocation == null) {
            RadAbstractGridLayoutManager.$$$reportNull$$$0(6);
        }
        return gridDropLocation;
    }

    private int getLastNonSpacerRow(RadContainer container) {
        int lastRow = this.getGridRowCount(container) - 1;
        for (int col = 0; col < this.getGridColumnCount(container); ++col) {
            RadComponent c = RadAbstractGridLayoutManager.getComponentAtGrid(container, lastRow, col);
            if (c == null || c instanceof RadHSpacer || c instanceof RadVSpacer) continue;
            return lastRow;
        }
        return lastRow - 1;
    }

    protected static void drawGrowMarker(boolean isRow, Graphics2D g2d, Rectangle rc) {
        g2d.setColor(Color.BLACK);
        if (!isRow) {
            int maxX = (int)rc.getMaxX();
            int midY = (int)rc.getCenterY() + 3;
            int xStart = Math.max(maxX - 10, rc.x + 2);
            int xEnd = maxX - 2;
            g2d.drawLine(xStart, midY, xEnd, midY);
            g2d.drawLine(xStart, midY, xStart + 2, midY - 2);
            g2d.drawLine(xStart, midY, xStart + 2, midY + 2);
            g2d.drawLine(xEnd, midY, xEnd - 2, midY - 2);
            g2d.drawLine(xEnd, midY, xEnd - 2, midY + 2);
        } else {
            int maxY = (int)rc.getMaxY();
            int midX = (int)rc.getCenterX() + 3;
            int yStart = Math.max(maxY - 10, rc.y + 2);
            int yEnd = maxY - 2;
            g2d.drawLine(midX, yStart, midX, yEnd);
            g2d.drawLine(midX, yStart, midX - 2, yStart + 2);
            g2d.drawLine(midX, yStart, midX + 2, yStart + 2);
            g2d.drawLine(midX, yEnd, midX - 2, yEnd - 2);
            g2d.drawLine(midX, yEnd, midX + 2, yEnd - 2);
        }
    }

    @Override
    public void changeContainerLayout(RadContainer container) throws IncorrectOperationException {
        if (container.getLayoutManager().isGrid()) {
            RadAbstractGridLayoutManager grid = container.getGridLayoutManager();
            List<Boolean> canRowsGrow = RadAbstractGridLayoutManager.collectCanCellsGrow(grid, container, true);
            List<Boolean> canColumnsGrow = RadAbstractGridLayoutManager.collectCanCellsGrow(grid, container, false);
            List<RadComponent> contents = RadAbstractGridLayoutManager.collectComponents(container);
            this.changeLayoutFromGrid(container, contents, canRowsGrow, canColumnsGrow);
            int oldGapMultiplier = grid.getGapCellCount() + 1;
            int gapMultiplier = this.getGapCellCount() + 1;
            for (RadComponent c : contents) {
                GridConstraints gc = c.getConstraints();
                gc.setRow(gc.getRow() * gapMultiplier / oldGapMultiplier);
                gc.setColumn(gc.getColumn() * gapMultiplier / oldGapMultiplier);
                container.addComponent(c);
            }
        } else if (container.getLayoutManager().isIndexed()) {
            List<RadComponent> components = RadAbstractGridLayoutManager.collectComponents(container);
            this.changeLayoutFromIndexed(container, components);
            int gapMultiplier = this.getGapCellCount() + 1;
            for (int i = 0; i < components.size(); ++i) {
                GridConstraints gc = components.get(i).getConstraints();
                gc.setRow(0);
                gc.setColumn(i * gapMultiplier);
                gc.setRowSpan(1);
                gc.setColSpan(1);
                container.addComponent(components.get(i));
            }
        } else if (container.getComponentCount() == 0) {
            container.setLayoutManager(this);
        } else {
            throw new IncorrectOperationException("Cannot change from " + container.getLayout() + " to grid layout");
        }
    }

    protected void changeLayoutFromGrid(RadContainer container, List<RadComponent> contents, List<Boolean> canRowsGrow, List<Boolean> canColumnsGrow) {
        container.setLayoutManager(this);
    }

    protected void changeLayoutFromIndexed(RadContainer container, List<RadComponent> components) {
        container.setLayoutManager(this);
    }

    private static List<Boolean> collectCanCellsGrow(RadAbstractGridLayoutManager grid, RadContainer container, boolean isRow) {
        ArrayList<Boolean> result = new ArrayList<Boolean>();
        for (int i = 0; i < grid.getGridCellCount(container, isRow); ++i) {
            if (grid.isGapCell(container, isRow, i)) continue;
            result.add(grid.canCellGrow(container, isRow, i));
        }
        return result;
    }

    private static List<RadComponent> collectComponents(RadContainer container) {
        ArrayList<RadComponent> contents = new ArrayList<RadComponent>();
        for (int i = container.getComponentCount() - 1; i >= 0; --i) {
            RadComponent component = container.getComponent(i);
            if (!(component instanceof RadHSpacer) && !(component instanceof RadVSpacer)) {
                contents.add(0, component);
            }
            container.removeComponent(component);
        }
        return contents;
    }

    @Override
    public boolean canMoveComponent(RadComponent c, int rowDelta, int colDelta, int rowSpanDelta, int colSpanDelta) {
        int newRow = RadAbstractGridLayoutManager.getNewRow(c, rowDelta);
        int newCol = RadAbstractGridLayoutManager.getNewColumn(c, colDelta);
        int newRowSpan = RadAbstractGridLayoutManager.getNewRowSpan(c, rowSpanDelta);
        int newColSpan = RadAbstractGridLayoutManager.getNewColSpan(c, colSpanDelta);
        if (newRow < 0 || newCol < 0 || newRowSpan < 1 || newColSpan < 1 || newRow + newRowSpan > c.getParent().getGridRowCount() || newCol + newColSpan > c.getParent().getGridColumnCount()) {
            return false;
        }
        c.setDragging(true);
        RadComponent overlap = c.getParent().findComponentInRect(newRow, newCol, newRowSpan, newColSpan);
        c.setDragging(false);
        return overlap == null;
    }

    private static int getNewRow(RadComponent c, int rowDelta) {
        return FormEditingUtil.adjustForGap(c.getParent(), c.getConstraints().getRow() + rowDelta, true, rowDelta);
    }

    private static int getNewColumn(RadComponent c, int colDelta) {
        return FormEditingUtil.adjustForGap(c.getParent(), c.getConstraints().getColumn() + colDelta, false, colDelta);
    }

    private static int getNewRowSpan(RadComponent c, int rowSpanDelta) {
        int gapCount = c.getParent().getGridLayoutManager().getGapCellCount();
        return c.getConstraints().getRowSpan() + rowSpanDelta * (gapCount + 1);
    }

    private static int getNewColSpan(RadComponent c, int colSpanDelta) {
        int gapCount = c.getParent().getGridLayoutManager().getGapCellCount();
        return c.getConstraints().getColSpan() + colSpanDelta * (gapCount + 1);
    }

    @Override
    public void moveComponent(RadComponent c, int rowDelta, int colDelta, int rowSpanDelta, int colSpanDelta) {
        GridConstraints constraints = c.getConstraints();
        GridConstraints oldConstraints = (GridConstraints)constraints.clone();
        constraints.setRow(RadAbstractGridLayoutManager.getNewRow(c, rowDelta));
        constraints.setColumn(RadAbstractGridLayoutManager.getNewColumn(c, colDelta));
        constraints.setRowSpan(RadAbstractGridLayoutManager.getNewRowSpan(c, rowSpanDelta));
        constraints.setColSpan(RadAbstractGridLayoutManager.getNewColSpan(c, colSpanDelta));
        c.fireConstraintsChanged(oldConstraints);
    }

    public int getMinCellCount() {
        return 1;
    }

    @Override
    public void addComponentToContainer(RadContainer container, RadComponent component, int index) {
        MyPropertyChangeListener listener = new MyPropertyChangeListener(component);
        this.myListenerMap.put(component, listener);
        component.addPropertyChangeListener(listener);
    }

    @Override
    public void removeComponentFromContainer(RadContainer container, RadComponent component) {
        MyPropertyChangeListener listener = this.myListenerMap.get(component);
        if (listener != null) {
            component.removePropertyChangeListener(listener);
            this.myListenerMap.remove(component);
        }
        super.removeComponentFromContainer(container, component);
    }

    protected void updateConstraints(RadComponent component) {
        component.getParent().revalidate();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/uiDesigner/radComponents/RadAbstractGridLayoutManager", "getDropLocation"));
    }

    private class MyPropertyChangeListener
    implements PropertyChangeListener {
        private final RadComponent myComponent;

        MyPropertyChangeListener(RadComponent component) {
            this.myComponent = component;
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (evt.getPropertyName().equals("constraints")) {
                RadAbstractGridLayoutManager.this.updateConstraints(this.myComponent);
            }
        }
    }
}

