/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.uiDesigner.radComponents;

import com.intellij.openapi.project.Project;
import com.intellij.uiDesigner.XmlWriter;
import com.intellij.uiDesigner.designSurface.ComponentDropLocation;
import com.intellij.uiDesigner.designSurface.NoDropLocation;
import com.intellij.uiDesigner.inspections.FormInspectionUtil;
import com.intellij.uiDesigner.lw.IComponent;
import com.intellij.uiDesigner.lw.IProperty;
import com.intellij.uiDesigner.lw.LwContainer;
import com.intellij.uiDesigner.propertyInspector.Property;
import com.intellij.uiDesigner.radComponents.RadComponent;
import com.intellij.uiDesigner.radComponents.RadContainer;
import com.intellij.uiDesigner.snapShooter.SnapshotContext;
import com.intellij.util.IncorrectOperationException;
import java.awt.LayoutManager;
import java.awt.Point;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class RadLayoutManager {
    @Nullable
    public abstract String getName();

    @Nullable
    public LayoutManager createLayout() {
        return null;
    }

    public void readLayout(LwContainer lwContainer, RadContainer radContainer) throws Exception {
    }

    public void changeContainerLayout(RadContainer container) throws IncorrectOperationException {
        RadLayoutManager.ensureChildrenVisible(container);
        container.setLayoutManager(this);
    }

    public abstract void writeChildConstraints(XmlWriter var1, RadComponent var2);

    public void writeLayout(XmlWriter writer, RadContainer radContainer) {
    }

    public void refresh(RadContainer container) {
    }

    @NotNull
    public ComponentDropLocation getDropLocation(RadContainer container, @Nullable Point location) {
        NoDropLocation noDropLocation = NoDropLocation.INSTANCE;
        if (noDropLocation == null) {
            RadLayoutManager.$$$reportNull$$$0(0);
        }
        return noDropLocation;
    }

    public abstract void addComponentToContainer(RadContainer var1, RadComponent var2, int var3);

    public void removeComponentFromContainer(RadContainer container, RadComponent component) {
        container.getDelegee().remove(component.getDelegee());
    }

    public boolean isSwitchedToChild(RadContainer container, RadComponent child) {
        return true;
    }

    public boolean switchContainerToChild(RadContainer container, RadComponent child) {
        return false;
    }

    public Property[] getContainerProperties(Project project) {
        return Property.EMPTY_ARRAY;
    }

    public Property[] getComponentProperties(Project project, RadComponent component) {
        return Property.EMPTY_ARRAY;
    }

    public void addSnapshotComponent(JComponent parent, JComponent child, RadContainer container, RadComponent component) {
        throw new UnsupportedOperationException("Layout manager " + this + " does not support adding snapshot components");
    }

    public void createSnapshotLayout(SnapshotContext context, JComponent parent, RadContainer container, LayoutManager layout) {
    }

    public boolean isIndexed() {
        return false;
    }

    public boolean isGrid() {
        return false;
    }

    public boolean areChildrenExclusive() {
        return false;
    }

    public void setChildDragging(RadComponent child, boolean dragging) {
        child.getDelegee().setVisible(!dragging);
    }

    public boolean canMoveComponent(RadComponent c, int rowDelta, int colDelta, int rowSpanDelta, int colSpanDelta) {
        return false;
    }

    public void moveComponent(RadComponent c, int rowDelta, int colDelta, int rowSpanDelta, int colSpanDelta) {
    }

    protected static void ensureChildrenVisible(RadContainer container) {
        if (container.getLayoutManager().areChildrenExclusive()) {
            for (RadComponent child : container.getComponents()) {
                IProperty property = FormInspectionUtil.findProperty(child, "visible");
                if (property != null && property.getPropertyValue((IComponent)child) != Boolean.TRUE) continue;
                child.getDelegee().setVisible(true);
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/uiDesigner/radComponents/RadLayoutManager", "getDropLocation"));
    }
}

