/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiParameter;
import com.siyeh.ig.psiutils.MethodUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.uast.UAnnotated;
import org.jetbrains.uast.UBinaryExpression;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UCallableReferenceExpression;
import org.jetbrains.uast.UClass;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.UExpressionList;
import org.jetbrains.uast.UField;
import org.jetbrains.uast.ULiteralExpression;
import org.jetbrains.uast.ULocalVariable;
import org.jetbrains.uast.UMethod;
import org.jetbrains.uast.UParameter;
import org.jetbrains.uast.UQualifiedReferenceExpression;
import org.jetbrains.uast.UResolvable;
import org.jetbrains.uast.UReturnExpression;
import org.jetbrains.uast.USimpleNameReferenceExpression;
import org.jetbrains.uast.UVariable;
import org.jetbrains.uast.UastBinaryOperator;
import org.jetbrains.uast.UastContextKt;
import org.jetbrains.uast.UastLiteralUtils;
import org.jetbrains.uast.UastUtils;

public final class NonNlsUastUtil {
    public static boolean isNonNlsAnnotated(@Nullable UElement element) {
        return element instanceof UAnnotated && ((UAnnotated)element).findAnnotation("org.jetbrains.annotations.NonNls") != null;
    }

    public static boolean isCallableReferenceExpressionWithNonNlsQualifier(@Nullable UCallableReferenceExpression expression) {
        if (expression == null) {
            return false;
        }
        return false;
    }

    public static boolean isCallExpressionWithNonNlsReceiver(@Nullable UCallExpression expression) {
        if (expression == null) {
            return false;
        }
        UExpression receiver = expression.getReceiver();
        if (receiver == null) {
            return false;
        }
        if (receiver instanceof ULiteralExpression) {
            return NonNlsUastUtil.isNonNlsStringLiteral((ULiteralExpression)receiver);
        }
        if (receiver instanceof USimpleNameReferenceExpression) {
            return NonNlsUastUtil.isReferenceToNonNlsElement((USimpleNameReferenceExpression)receiver);
        }
        if (receiver instanceof UCallExpression || receiver instanceof UQualifiedReferenceExpression) {
            PsiElement resolved = ((UResolvable)((Object)receiver)).resolve();
            return resolved != null && NonNlsUastUtil.isNonNlsAnnotatedPsi(resolved);
        }
        UElement expressionParent = expression.getUastParent();
        return expressionParent instanceof UVariable && NonNlsUastUtil.isNonNlsAnnotated(expressionParent);
    }

    public static boolean isNonNlsStringLiteral(@Nullable ULiteralExpression expression) {
        if (expression == null) {
            return false;
        }
        if (!UastLiteralUtils.isStringLiteral(expression)) {
            return false;
        }
        if (NonNlsUastUtil.isPlacedInNonNlsClass(expression) || NonNlsUastUtil.isPlacedInNonNlsPackage(expression)) {
            return true;
        }
        UExpression parent = UastUtils.getParentOfType((UElement)expression, true, UExpressionList.class, UVariable.class, UReturnExpression.class, UCallExpression.class, UBinaryExpression.class);
        if (parent instanceof UField || parent instanceof ULocalVariable || parent instanceof UParameter) {
            return NonNlsUastUtil.isNonNlsAnnotated(parent);
        }
        if (parent instanceof UReturnExpression) {
            return NonNlsUastUtil.isReturnExpressionInNonNlsMethod((UReturnExpression)parent);
        }
        if (parent instanceof UCallExpression) {
            return NonNlsUastUtil.isNonNlsArgument(expression, (UCallExpression)parent) || NonNlsUastUtil.isCallExpressionWithNonNlsReceiver((UCallExpression)parent);
        }
        while (parent instanceof UBinaryExpression) {
            if (!NonNlsUastUtil.isAssignmentOrComparisonExpression((UBinaryExpression)parent)) {
                if (!((parent = UastUtils.getParentOfType((UElement)parent, true, UBinaryExpression.class, UVariable.class)) instanceof UVariable)) continue;
                return NonNlsUastUtil.isNonNlsAnnotated(parent);
            }
            UExpression leftOperand = ((UBinaryExpression)parent).getLeftOperand();
            return leftOperand instanceof USimpleNameReferenceExpression && NonNlsUastUtil.isReferenceToNonNlsElement((USimpleNameReferenceExpression)leftOperand);
        }
        return false;
    }

    private static boolean isPlacedInNonNlsClass(@NotNull UElement element) {
        UClass containingClass;
        if (element == null) {
            NonNlsUastUtil.$$$reportNull$$$0(0);
        }
        if ((containingClass = UastUtils.getContainingUClass(element)) == null) {
            return false;
        }
        if (NonNlsUastUtil.isNonNlsAnnotated(containingClass)) {
            return true;
        }
        UClass superClass = containingClass;
        while ((superClass = superClass.getSuperClass()) != null) {
            if (!NonNlsUastUtil.isNonNlsAnnotated(superClass)) continue;
            return true;
        }
        return false;
    }

    private static boolean isPlacedInNonNlsPackage(@NotNull UElement element) {
        if (element == null) {
            NonNlsUastUtil.$$$reportNull$$$0(1);
        }
        return false;
    }

    private static boolean isReferenceToNonNlsElement(@NotNull USimpleNameReferenceExpression expression) {
        PsiElement resolved;
        if (expression == null) {
            NonNlsUastUtil.$$$reportNull$$$0(2);
        }
        if ((resolved = expression.resolve()) == null) {
            return false;
        }
        UElement resolvedUElement = UastContextKt.toUElement(resolved);
        return NonNlsUastUtil.isNonNlsAnnotated(resolvedUElement);
    }

    private static boolean isReturnExpressionInNonNlsMethod(@NotNull UReturnExpression expression) {
        if (expression == null) {
            NonNlsUastUtil.$$$reportNull$$$0(3);
        }
        Object method = UastUtils.getParentOfType(expression, UMethod.class);
        return NonNlsUastUtil.isNonNlsAnnotated(method);
    }

    private static boolean isNonNlsArgument(@NotNull ULiteralExpression argument, @NotNull UCallExpression callExpression) {
        PsiParameter parameter;
        if (argument == null) {
            NonNlsUastUtil.$$$reportNull$$$0(4);
        }
        if (callExpression == null) {
            NonNlsUastUtil.$$$reportNull$$$0(5);
        }
        if ((parameter = UastUtils.getParameterForArgument(callExpression, argument)) == null) {
            return false;
        }
        if (NonNlsUastUtil.isNonNlsAnnotatedPsi(parameter)) {
            return true;
        }
        if (!"equals".equals(callExpression.getMethodName())) {
            return false;
        }
        PsiMethod method = callExpression.resolve();
        if (!MethodUtils.isEquals((PsiMethod)method)) {
            return false;
        }
        return NonNlsUastUtil.isCallExpressionWithNonNlsReceiver(callExpression);
    }

    private static boolean isAssignmentOrComparisonExpression(@NotNull UBinaryExpression expression) {
        UastBinaryOperator operator;
        if (expression == null) {
            NonNlsUastUtil.$$$reportNull$$$0(6);
        }
        return (operator = expression.getOperator()) instanceof UastBinaryOperator.AssignOperator || operator instanceof UastBinaryOperator.ComparisonOperator;
    }

    private static boolean isNonNlsAnnotatedPsi(@NotNull PsiElement element) {
        if (element == null) {
            NonNlsUastUtil.$$$reportNull$$$0(7);
        }
        return element instanceof PsiModifierListOwner && AnnotationUtil.findAnnotation((PsiModifierListOwner)element, "org.jetbrains.annotations.NonNls") != null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 2: 
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "argument";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callExpression";
                break;
            }
        }
        objectArray2[1] = "com/intellij/codeInspection/NonNlsUastUtil";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "isPlacedInNonNlsClass";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "isPlacedInNonNlsPackage";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "isReferenceToNonNlsElement";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "isReturnExpressionInNonNlsMethod";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "isNonNlsArgument";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "isAssignmentOrComparisonExpression";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "isNonNlsAnnotatedPsi";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

