/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.filters;

import com.intellij.execution.filters.ExceptionInfoCache;
import com.intellij.execution.filters.Filter;
import com.intellij.execution.filters.HyperlinkInfo;
import com.intellij.execution.filters.HyperlinkInfoFactory;
import com.intellij.openapi.editor.colors.CodeInsightColors;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.PsiShortNamesCache;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.util.ArrayList;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ExceptionWorker {
    @NonNls
    private static final String AT = "at";
    private static final String AT_PREFIX = "at ";
    private static final String STANDALONE_AT = " at ";
    private final Project myProject;
    private Filter.Result myResult;
    private PsiClass[] myClasses;
    private PsiFile[] myFiles;
    private String myMethod;
    private ParsedLine myInfo;
    private final ExceptionInfoCache myCache;

    public ExceptionWorker(@NotNull ExceptionInfoCache cache) {
        if (cache == null) {
            ExceptionWorker.$$$reportNull$$$0(0);
        }
        this.myClasses = PsiClass.EMPTY_ARRAY;
        this.myFiles = PsiFile.EMPTY_ARRAY;
        this.myProject = cache.getProject();
        this.myCache = cache;
    }

    public Filter.Result execute(String line, int textEndOffset) {
        Filter.Result result;
        ArrayList<VirtualFile> virtualFiles;
        this.myResult = null;
        this.myInfo = ExceptionWorker.parseExceptionLine(line);
        if (this.myInfo == null) {
            return null;
        }
        this.myMethod = this.myInfo.methodNameRange.substring(line);
        Pair<PsiClass[], PsiFile[]> pair = this.myCache.resolveClass(this.myInfo.classFqnRange.substring(line).trim());
        this.myClasses = (PsiClass[])pair.first;
        this.myFiles = (PsiFile[])pair.second;
        if (this.myFiles.length == 0 && this.myInfo.fileName != null) {
            this.myFiles = PsiShortNamesCache.getInstance(this.myProject).getFilesByName(this.myInfo.fileName);
        }
        if (this.myFiles.length == 0) {
            return null;
        }
        int textStartOffset = textEndOffset - line.length();
        int highlightStartOffset = textStartOffset + this.myInfo.fileLineRange.getStartOffset();
        int highlightEndOffset = textStartOffset + this.myInfo.fileLineRange.getEndOffset();
        ProjectFileIndex index = ProjectRootManager.getInstance((Project)this.myProject).getFileIndex();
        ArrayList<VirtualFile> virtualFilesInLibraries = new ArrayList<VirtualFile>();
        ArrayList<VirtualFile> virtualFilesInContent = new ArrayList<VirtualFile>();
        for (PsiFile file : this.myFiles) {
            VirtualFile virtualFile = file.getVirtualFile();
            if (index.isInContent(virtualFile)) {
                virtualFilesInContent.add(virtualFile);
                continue;
            }
            virtualFilesInLibraries.add(virtualFile);
        }
        TextAttributes attributes = EditorColorsManager.getInstance().getGlobalScheme().getAttributes(CodeInsightColors.HYPERLINK_ATTRIBUTES);
        if (virtualFilesInContent.isEmpty()) {
            Color libTextColor = UIUtil.getInactiveTextColor();
            attributes = attributes.clone();
            attributes.setForegroundColor(libTextColor);
            attributes.setEffectColor(libTextColor);
            virtualFiles = virtualFilesInLibraries;
        } else {
            virtualFiles = virtualFilesInContent;
        }
        HyperlinkInfo linkInfo = HyperlinkInfoFactory.getInstance().createMultipleFilesHyperlinkInfo(virtualFiles, this.myInfo.lineNumber - 1, this.myProject);
        this.myResult = result = new Filter.Result(highlightStartOffset, highlightEndOffset, linkInfo, attributes);
        return result;
    }

    private static int getLineNumber(String lineString) {
        if (lineString.isEmpty() || lineString.length() > 9 || !Character.isDigit(lineString.charAt(0))) {
            return -1;
        }
        try {
            return Integer.parseInt(lineString);
        }
        catch (NumberFormatException e) {
            return -1;
        }
    }

    public Filter.Result getResult() {
        return this.myResult;
    }

    public PsiClass getPsiClass() {
        return (PsiClass)ArrayUtil.getFirstElement((Object[])this.myClasses);
    }

    public String getMethod() {
        return this.myMethod;
    }

    public PsiFile getFile() {
        return (PsiFile)ArrayUtil.getFirstElement((Object[])this.myFiles);
    }

    public ParsedLine getInfo() {
        return this.myInfo;
    }

    private static int findAtPrefix(String line) {
        if (line.startsWith(AT_PREFIX)) {
            return 0;
        }
        int startIdx = line.indexOf(STANDALONE_AT);
        return startIdx < 0 ? line.indexOf(AT_PREFIX) : startIdx;
    }

    private static int findFirstRParenAfterDigit(String line) {
        int rParenIdx = -1;
        int rParenCandidate = line.lastIndexOf(41);
        while (rParenCandidate > 0) {
            if (Character.isDigit(line.charAt(rParenCandidate - 1))) {
                rParenIdx = rParenCandidate;
            }
            rParenCandidate = line.lastIndexOf(41, rParenCandidate - 1);
        }
        return rParenIdx;
    }

    @Nullable
    public static ParsedLine parseExceptionLine(String line) {
        ParsedLine result = ExceptionWorker.parseNormalStackTraceLine(line);
        if (result == null) {
            result = ExceptionWorker.parseYourKitLine(line);
        }
        if (result == null) {
            result = ExceptionWorker.parseForcedLine(line);
        }
        return result;
    }

    @Nullable
    private static ParsedLine parseNormalStackTraceLine(String line) {
        int startIdx = ExceptionWorker.findAtPrefix(line);
        int rParenIdx = ExceptionWorker.findFirstRParenAfterDigit(line);
        if (rParenIdx < 0) {
            return null;
        }
        TextRange methodName = ExceptionWorker.findMethodNameCandidateBefore(line, startIdx, rParenIdx);
        if (methodName == null) {
            return null;
        }
        int lParenIdx = methodName.getEndOffset();
        int dotIdx = methodName.getStartOffset() - 1;
        int moduleIdx = line.indexOf(47);
        int classNameIdx = moduleIdx > -1 && moduleIdx < dotIdx ? moduleIdx + 1 : startIdx + 1 + (startIdx >= 0 ? AT.length() : 0);
        return ParsedLine.createFromFileAndLine(new TextRange(classNameIdx, ExceptionWorker.handleSpaces(line, dotIdx, -1)), ExceptionWorker.trimRange(line, methodName), lParenIdx + 1, rParenIdx, line);
    }

    private static TextRange trimRange(String line, TextRange range) {
        int start = ExceptionWorker.handleSpaces(line, range.getStartOffset(), 1);
        int end = ExceptionWorker.handleSpaces(line, range.getEndOffset(), -1);
        if (start != range.getStartOffset() || end != range.getEndOffset()) {
            return TextRange.create((int)start, (int)end);
        }
        return range;
    }

    @Nullable
    private static ParsedLine parseYourKitLine(String line) {
        int lineEnd = line.length() - 1;
        if (lineEnd > 0 && line.charAt(lineEnd) == '\n') {
            --lineEnd;
        }
        if (lineEnd > 0 && Character.isDigit(line.charAt(lineEnd))) {
            TextRange methodName;
            int spaceIndex = line.lastIndexOf(32);
            int rParenIdx = line.lastIndexOf(41);
            if (rParenIdx > 0 && spaceIndex == rParenIdx + 1 && (methodName = ExceptionWorker.findMethodNameCandidateBefore(line, 0, rParenIdx)) != null) {
                return ParsedLine.createFromFileAndLine(new TextRange(0, methodName.getStartOffset() - 1), methodName, spaceIndex + 1, lineEnd + 1, line);
            }
        }
        return null;
    }

    @Nullable
    private static ParsedLine parseForcedLine(String line) {
        String dash = "- ";
        if (!line.trim().startsWith(dash)) {
            return null;
        }
        String linePrefix = "line=";
        int lineNumberStart = line.indexOf(linePrefix);
        if (lineNumberStart < 0) {
            return null;
        }
        int lineNumberEnd = line.indexOf(32, lineNumberStart);
        if (lineNumberEnd < 0) {
            return null;
        }
        TextRange methodName = ExceptionWorker.findMethodNameCandidateBefore(line, 0, lineNumberStart);
        if (methodName == null) {
            return null;
        }
        int lineNumber = ExceptionWorker.getLineNumber(line.substring(lineNumberStart + linePrefix.length(), lineNumberEnd));
        if (lineNumber < 0) {
            return null;
        }
        return new ParsedLine(ExceptionWorker.trimRange(line, TextRange.create((int)(line.indexOf(dash) + dash.length()), (int)(methodName.getStartOffset() - 1))), methodName, TextRange.create((int)lineNumberStart, (int)lineNumberEnd), null, lineNumber);
    }

    private static TextRange findMethodNameCandidateBefore(String line, int start, int end) {
        int lParenIdx = line.lastIndexOf(40, end);
        if (lParenIdx < 0) {
            return null;
        }
        int dotIdx = line.lastIndexOf(46, lParenIdx);
        if (dotIdx < 0 || dotIdx < start) {
            return null;
        }
        return TextRange.create((int)(dotIdx + 1), (int)lParenIdx);
    }

    private static int handleSpaces(String line, int pos, int delta) {
        char c;
        int len = line.length();
        while (pos >= 0 && pos < len && Character.isSpaceChar(c = line.charAt(pos))) {
            pos += delta;
        }
        return pos;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "cache", "com/intellij/execution/filters/ExceptionWorker", "<init>"));
    }

    public static class ParsedLine {
        @NotNull
        public final TextRange classFqnRange;
        @NotNull
        public final TextRange methodNameRange;
        @NotNull
        public final TextRange fileLineRange;
        @Nullable
        public final String fileName;
        public final int lineNumber;

        ParsedLine(@NotNull TextRange classFqnRange, @NotNull TextRange methodNameRange, @NotNull TextRange fileLineRange, @Nullable String fileName, int lineNumber) {
            if (classFqnRange == null) {
                ParsedLine.$$$reportNull$$$0(0);
            }
            if (methodNameRange == null) {
                ParsedLine.$$$reportNull$$$0(1);
            }
            if (fileLineRange == null) {
                ParsedLine.$$$reportNull$$$0(2);
            }
            this.classFqnRange = classFqnRange;
            this.methodNameRange = methodNameRange;
            this.fileLineRange = fileLineRange;
            this.fileName = fileName;
            this.lineNumber = lineNumber;
        }

        @Nullable
        private static ParsedLine createFromFileAndLine(@NotNull TextRange classFqnRange, @NotNull TextRange methodNameRange, int fileLineStart, int fileLineEnd, String line) {
            TextRange fileLineRange;
            String fileAndLine;
            int colonIndex;
            if (classFqnRange == null) {
                ParsedLine.$$$reportNull$$$0(3);
            }
            if (methodNameRange == null) {
                ParsedLine.$$$reportNull$$$0(4);
            }
            if ((colonIndex = (fileAndLine = (fileLineRange = TextRange.create((int)fileLineStart, (int)fileLineEnd)).substring(line)).lastIndexOf(58)) < 0) {
                return null;
            }
            int lineNumber = ExceptionWorker.getLineNumber(fileAndLine.substring(colonIndex + 1));
            if (lineNumber < 0) {
                return null;
            }
            return new ParsedLine(classFqnRange, methodNameRange, fileLineRange, fileAndLine.substring(0, colonIndex).trim(), lineNumber);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "classFqnRange";
                    break;
                }
                case 1: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "methodNameRange";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "fileLineRange";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/execution/filters/ExceptionWorker$ParsedLine";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "createFromFileAndLine";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

